/*
/////////// STATEMENT OF PURPOSE ///////////////////////////////////////////////////////////////////////////////////

SolarTransit.inc (version 1.0.0)

This utility will place the sun "approximately" in the correct 
location given thedate, the number of days in the year (i.e., leap 
year or not), time of day (24 Hour time or directly programmed 
in as elapsed minutes of the day) and the latitude. Southern hemisphere 
latitudes are represented as negative values.


Optional information for more sophisticated calculations include:

1] Daylight savings time settings.

2] The location of a city in a time zone (a shift from -30 to 30
   minutes to reflect the location of a city on a specific time 
   zone). 
   
   Sunrise is 4 minutes earlier per degree of longitude East of the imaginary
   time zone center line.

User's note:

This utility provides an approximation. It will be off (until 
further notice) by certain factors:

1] Issues related to the exact elliptical orbit of the earth around 
   the sun as governed by Kepler's Law. Nor does it handle the 
   heliocentric progression as governed by General Relativity. 
   
   This is very difficult to calculate. It would require astronomical data
   that changes annually. Could be noticably different.

2] Factors not resolvable to within a given day such as the EXACT 
   point of equinoxes and solstices. Most likely negligible factor.

3] Factors related to infinite plane horizons versus real 
   planetary curved horizons that have slightly different values 
   for sunrises and sunsets. Most likely negligible factor.
   
4] Factors related to the observed disc-size of the "true" sun ... 
   i.e., in this setting it is rendered as a point-light and not 
   an area light so sunrises and sunsets will be different.
   NOTE: A user can easily change this feature and implement a more 
   sophisticated light source. Could be noticably different.
   
   User's may experiment with disc-shaped light-sources.

5] issues related to an exact longitude are being dis-missed for now. They 
   can involve political issues related to what time zone you are in and whether or not 
   daylight savings time is in effect globally.

Additional note:

Issues related to atmospheric-induced spectrum at a given time-of-day that are 
coded and/or rendered for display purposes are considered "test-studies" and 
DO NOT reflect any serious commitment on the part of the developer. These may 
change at any time. Second-party development is openly invited.

INSTRUCTIONS FOR USE

1] Place the statement
   #include "SolarTransit.inc" 
   at the top of your code.

2] Place the statement
   TheSun 
   in the appropriate location for your code.

3] goto SolarTransit.inc and set the features needed.

4] Over-ride the default sun point-light if desired.

5] Render.     

User's Note: 

This makes the positive x-axis to be due North.

There are additional code sections in the utility used for 
this competition, such as potential animation loops and 
other #includes that can be removed if desired.

////////////////////////////////////////////////////////////////////////////////////////////////////////////

TERMS OF USE AGREEMENT   

Permission to use and distribute the software and is hereby granted provided that the entire STATEMENT OF PURPOSE
including this copyright notice appears in all copies. You are encouraged to distribute this software to 
as many individuals and groups as you wish.

I hereby grant any individual acting in good faith full rights to use this utility in any animation and/or 
rendering competition if written request is required for competition purposes and does not violate any 
other competition rules.

In addition, any changes to the utility will be fully documented in the style of the GNU-copyleft.


THE AUTHOR AND PUBLISHER MAKE NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE SOFTWARE, 
EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, 
FITNESS FOR A PARTICULAR PURPOSE, OR NON-INFRINGEMENT. THE AUTHORS AND PUBLISHER SHALL NOT BE LIABLE FOR ANY 
DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

The product is provided "AS IS" without any guarantees or warranty. Although the author has attempted 
to find and correct any bugs in the package, the author is under no obligation to provide service, corrections, or 
upgrades to this package. 
                          
BY DOWNLOADING, ACCEPTING, OR USING THIS PACKAGE YOU ARE ACCEPTING THIS DISCLAIMER.                          

////////////////////////////////////////////////////////////////////////////////////////////////////////////


thank you and enjoy!

-Ed


Copyright 2003 Edward Leibnitz

/////////// End of STATEMENT OF PURPOSE //////////////////////////////////////////////////////////////////////////////////////
*/

// code starts here ///////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////////
// user will need to view / change these values ///////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////
#declare NumberOfDaysOfYear = 365;  ///////////////////////////////////////////////
#declare Latitude = 40.5;  //////////////////////////// NYC ////
#declare Month = 7;                 ///////////////////////////////////////////////
#declare Day   = 4;                ///////////////////////////////////////////////

//number of minutes from -30 to 30 to represent location within a time zone ///////
#declare TimeZoneLagPushFactor = 0;  //////////////////////////////////////////////   
///////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////

// user should be less likely to change these values //////////////////////////////
#declare SunDistance = 1000000; // pretty far away .... looks good so far /////////
#declare TropicLineLatitude = 23 + 26/60; // Earth Setting ////////////////////////
///////////////////////////////////////////////////////////////////////////////////

// potential animation loops ////
//#include "ElapsedMinutesLoop.inc"  // must activate #include "DayCalcs.inc" and de-activate #include "StandardTime.inc"
//#include "DayOfYearLoop.inc"     // must activate #include "StandardTime.inc"
/////////////////////////////////

// misc include files //////////
#include "StandardTime.inc"
//#include "24HourTime.inc"
#include "DayCalcs.inc"


///////////this is final step for time of day ////////////////////////////////////////////////
#declare ElapsedMinutesOfDay = HourOf24HourDay * 60 + MinuteOfTheHour + TimeZoneLagPushFactor;    
// subtract to get solar time i.e., if sunrise is at 6:00am solar time  .... but
// clock is pushed "ahead" to 7:00am .... need to subtract hour to get solar time    
#if (DaylightSavingsFactor = yes)
    #declare ElapsedMinutesOfDay = ElapsedMinutesOfDay - 60;  
#end
///////////////////////////////////////////////////////////////////////////////////

///////////this is final step for calendar issues ////////////////////////////////////////////
#if (DayOfYear >=  VernalEquinox) 
    #if (DayOfYear <= NumberOfDaysOfYear) 
        #declare DaysPastVernalEquinox = DayOfYear-VernalEquinox;
    #end
#end

#if (DayOfYear < VernalEquinox)
    #declare DaysPastVernalEquinox = (NumberOfDaysOfYear-VernalEquinox)+DayOfYear;
#end
//////////////////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////////////////////
// not actually a sin^2 function .... the real parametric rotation                       /////
// orbit is an ellipse .... this is not a trivial calculation                            /////
// sin^2 is merely a simple "circular-periodic-style" function that                      /////
// simulates the rotation of the planet's tilt from vernal equinox --> summer solstice   /////
// --> autumnal equinox --> winter solstice --> vernal equinox in a function that        /////
// starts at 0 climbs evenly to 1 drop back to 0 and drops to -1 before it returns to 0  /////
//////////////////////////////////////////////////////////////////////////////////////////////

#declare OrbitPosition = sin(2*pi*(DaysPastVernalEquinox/NumberOfDaysOfYear));

#if (OrbitPosition >= 0 )
        #declare OrbitPosition = OrbitPosition*OrbitPosition;  // to make it sin^2
#end    

#if (OrbitPosition < 0 )
        #declare OrbitPosition = -OrbitPosition*OrbitPosition;  // to make it -sin^2 so that is is cyclical and allows negative values
#end    

#declare NoonSunAngle = (90-Latitude)+TropicLineLatitude*OrbitPosition; 

//////////////////////////////////////////////////////////////////////////////////////
// Warning: "may not" be correct .... looks good though! /////////////////////////////
#declare AccentricAngle = -TropicLineLatitude*OrbitPosition; /////////////////////////
//////////////////////////////////////////////////////////////////////////////////////

// 720 is noon, 0 and 1440 are both midnight, 360 is 6am, 1080 is 6pm
#declare TimeOfDayAngle = (ElapsedMinutesOfDay-720)*360/1440;

#declare SunX = -SunDistance*cos(TimeOfDayAngle/360*2*pi);
#declare SunY = 0;
#declare SunZ = SunDistance*sin(TimeOfDayAngle/360*2*pi);

#declare TheSun = 

// create a regular point light source
light_source { 

  <SunX,SunY,SunZ>  
  color rgb <1,1,1>    // light's color
  rotate <0,0,-NoonSunAngle>  
  
  translate <SunDistance*cos(NoonSunAngle/360*2*pi),-SunDistance*sin(NoonSunAngle/360*2*pi),0>
  rotate <0,0,-AccentricAngle>  
  translate <-SunDistance*cos(NoonSunAngle/360*2*pi),SunDistance*sin(NoonSunAngle/360*2*pi),0>
 
}

