
//    File: Myskies.inc 
//    This file was manufactured from elements of:


//    Persistence of Vision Ray Tracer version 3.5 Include File
//    File: skies.inc
//    Last updated: 2001.7.24
//    Description: Sky textures, sky_spheres, and sky objects.



#if (ElapsedMinutesOfDay <= 300)
     #declare HowMuchDayLight = 0;
#end

#if (ElapsedMinutesOfDay > 300)
    #declare HowMuchDayLight = sin( pi * adj_range2(ElapsedMinutesOfDay/1440, 300/1440, 1140/1440,  0, 1));
#end

#if (ElapsedMinutesOfDay > 1140)
     #declare HowMuchDayLight = 0;
#end



#declare Cloud =
pigment {
    wrinkles
    turbulence 0.1
    lambda 2.2
    omega 0.707
    color_map {
        [0.20 SkyBlue * 0.85*HowMuchDayLight ]
        [0.50 color<min(1,0.5+HowMuchDayLight),min(1,0.5+HowMuchDayLight),min(1,0.5+HowMuchDayLight)> ]
        [1.00 Gray70 * HowMuchDayLight]
    }
    scale <0.5, 0.15, 1>
}

#declare My_Cloud =
sky_sphere {
    pigment {
        gradient y
        pigment_map {
            [0.10  color<0.184314 + (0.196078-0.184314)*HowMuchDayLight  ,0.184314 + (0.6-0.184314)*HowMuchDayLight ,0.309804+ (0.8-0.309804)*HowMuchDayLight> ]                   // horizon
            [0.20 Cloud ]
        }
    }
}


 