#version 3.5 ;

#include "colors.inc"
#include "textures.inc"
#include "stones.inc"
#include "skies.inc"
#include "metals.inc"
#include "woods.inc"

global_settings
{
  assumed_gamma 1.8
}

// ----------------------------------------
#declare tclock=clock-1000;
#declare s1=5*seed(23);
#declare pi2=2*pi;

#declare place = <10,4,-65>;
//#declare place =<75,18,0>;
//#declare place =<0,5,-75>;


light_source { place + <-2,2,0> color <1,1,1>*.2}
light_source { place + <2,2,0> color <1,1,1>*.2}
/*light_source{place color<1,1,1>*.6}
*/

//light_source{ place color<1,1,1>}
light_source{ <-1000,1000,-1000> color<1,1,1>*.6}

//background { color SkyBlue }

sky_sphere{S_Cloud2 rotate 180*x rotate tclock*y/4}

camera {location place//-4 
right 16/9*x
//look_at <0,12,0>//WORKING
look_at <0,4,0>
angle  25// 17//10  20
sky <0,1,0>
}

//sphere {0,1 texture {T_Silver_1A}}

/*
plane {y, 0 texture {pigment {color rgb  <1,.8,0>}   }
finish {ambient .6 roughness .01 }
}
*/


#declare ground = object{
height_field{jpeg "/home/matt/povray/h-fields/flat-ground.jpg" smooth
translate <-.5,0,-.5>
scale <1000,1,1000>
pigment{color rgb<.8,.5,.2>}
finish{ambient .6 roughness .01}
normal{dents -1 scale 10}
//rotate -3*x
}
}//ground

object{ground}
object{ground rotate -1*x translate 1000*z}

#declare posts = union{
box {-1,1 scale <.5,12,.5> translate <-4,0,-4> }
box {-1,1 scale <.5,12,.5> translate <4,0,-4> }
box {-1,1 scale <.5,12,.5> translate <-4,0,4> }
box {-1,1 scale <.5,12,.5> translate <4,0,4> }
}//posts

#declare planks = union{
box {-1,1 scale <.5,.2,5> texture{T_Wood1 translate <rand(s1),rand(s1),rand(s1)>} 
translate <0,12,0> finish {ambient .6} }

box {-1,1 scale <.5,.2,5> texture{T_Wood1 translate <rand(s1),rand(s1),rand(s1)>} 
translate <1,12,0> finish {ambient .6} }
box {-1,1 scale <.5,.2,5> texture{T_Wood1 translate <rand(s1),rand(s1),rand(s1)>} 
translate <-1,12,0> finish {ambient .6} }

box {-1,1 scale <.5,.2,5> texture{T_Wood1 translate <rand(s1),rand(s1),rand(s1)>} 
translate <2,12,0> finish {ambient .6} }
box {-1,1 scale <.5,.2,5> texture{T_Wood1 translate <rand(s1),rand(s1),rand(s1)>} 
translate <-2,12,0> finish {ambient .6} }

box {-1,1 scale <.5,.2,5> texture{T_Wood1 translate <rand(s1),rand(s1),rand(s1)>} 
translate <3,12,0> finish {ambient .6} }
box {-1,1 scale <.5,.2,5> texture{T_Wood1 translate <rand(s1),rand(s1),rand(s1)>} 
translate <-3,12,0> finish {ambient .6} }

box {-1,1 scale <.5,.2,5> texture{T_Wood1 translate <rand(s1),rand(s1),rand(s1)>} 
translate <4,12,0> finish {ambient .6} }
box {-1,1 scale <.5,.2,5> texture{T_Wood1 translate <rand(s1),rand(s1),rand(s1)>} 
translate <-4,12,0> finish {ambient .6} }

}//planks

#declare crossbar=union{
box {-1,1 scale <.5,3.5,.5> //7
texture{T_Wood1 rotate 90*x translate <rand(s1),rand(s1),rand(s1)>} 
translate <-4,15.5,0> }//12

box {-1,1 scale <.5,3,.5> 
texture{T_Wood1 rotate 90*x translate <rand(s1),rand(s1),rand(s1)>} 
rotate 90*z translate <-1,18.5,0> }
}//crossbar

#declare stairs= union{
#declare i=0;
#while (i<17)
box {-1,1 scale <.5,.25,2.5> 
texture{T_Wood1 rotate 90*y  translate <rand(s1),rand(s1),rand(s1)>} 
translate <8-i*.5,i*.5,0> }
#declare i=i+1;
#end

}//stairs

#declare gallows= union{
object{posts texture {T_Wood1 rotate 90*x} finish{ambient .6}}
object{planks}
object {crossbar}
object {stairs translate <4,4,0> }
}

object{gallows translate -4*y}

#include "lb8.inc"

//object {b8f scale 1.25 translate 11.3*y} // top forward


#declare xscale =5;
#declare yscale =20;
//#declare flag_clock=clock;

#declare cloth =
//union {
object{
   #declare flag_xsize = xscale;
   #declare flag_xsteps = 20;// 20;
   #declare flag_xwave = 4;
   #declare flag_xanim = -.01;
   #declare flag_ysize = yscale;
   #declare flag_ysteps = 30;// 20;
   #declare flag_ywave = 1;//0;//.5;
   #declare flag_yanim = -.05;//0;//.5;
   #declare flag_angle = 40;
   #declare flag_amp = .15;
   object { #include "flag.inc"

texture {pigment{image_map{gif "cloth.gif" once

map_type 0} scale <xscale,yscale,1>}}
finish {ambient .8}
}
scale <.2,.4,1> rotate 90*y   translate 6*y
}
//!!!!!!z scale and translate changes x
object{ cloth scale <1,1,1> translate <0,-6.5,2.75> rotate 90*y translate -4*z}

#declare loop = difference{

lathe {cubic_spline
11,
<0,1>,
<0.00756218,0.951057>,
<0.0561285,0.809017>,
<0.166744,0.587785>,
<0.328582,0.309017>,
<0.5,0>,
<0.622475,-0.309017>,
<0.642273,-0.587785>,
<0.531657,-0.809017>,
<0.301455,-0.951057>,
<0,-1>
scale 1}

lathe {cubic_spline
11,
<0,1>,
<0.00756218,0.951057>,
<0.0561285,0.809017>,
<0.166744,0.587785>,
<0.328582,0.309017>,
<0.5,0>,
<0.622475,-0.309017>,
<0.642273,-0.587785>,
<0.531657,-0.809017>,
<0.301455,-0.951057>,
<0,-1>
scale .85}
}

#declare loop2 = intersection{
object {loop}
box{-2,2 scale <1,1,.075>}
}

#declare noose = union{
object{loop2}
#declare i=0;
#while (i<13)
torus{.15,.075 translate (.7+i*.15)*y}
#declare i=i+1;
#end
cylinder{<0,1,0>,<0,14,0> .15 }
}//noose

object{ noose
pigment{color rgb<.6,.5,0>} finish{ambient .6 roughness .01 crand .1}
rotate y*tclock
//translate 11*y
}

#if (clock>99)
#if (clock<1051)
object{b8f scale 1.25 rotate 0*y 
translate <0,3.2,-1>}
#end
#end

#if(clock>1050)
#if(clock<1102)
#declare rclock=clock-1051;

object{b8f scale 1.25 
//rotate y*180*rclock/50  //0-270
translate <0,3.2,-1>
translate <0  ,0,-20+20*(cos(pi2*.5*rclock/50))>}

#end
#end

#if (clock>1101)
#if (clock<1132)
#declare rclock=clock-1102;

object{b8f scale 1.25 
rotate y*90  //0-270
translate <0,3.2,-1>
translate <-16*(rclock/30),0,-20+20*(cos(pi2*.5*(1101-1051)/50))>}
#end
#end

#if (clock>1131)
#if (clock<1601)
#declare rclock=clock-1131;

object{b8f scale 1.25 
rotate y*180  //0-270
translate <0,3.2,-1>
translate <-16, 0, 

//                                  VV added at 1151
-20+20*(cos(pi2*.5*(1101-1051)/50))+10 +1*rclock >}
#end
#end

///LYRICS
#if (clock>1100)
#if (clock<1200)
text{ttf "/home/matt/povray/fonts/hamlet.ttf" 
"This time tomorrow"
.001, 0 
texture {pigment{Red}} finish{ambient 1.4 roughness .01 crand .1}
scale <1.25,1,1>  rotate -30*x translate <-4.5,9,-15>
no_shadow
}
text{ttf "/home/matt/povray/fonts/hamlet.ttf" 
"Reckon where he'll be"
.001, 0 
texture {pigment{Red}} finish{ambient 1.4 roughness .01 crand .1}
scale <1.25,1,1> rotate -30*x translate <-4.5,8,-15>
no_shadow
}

#end
#end

#if (clock>1199)
text{ttf "/home/matt/povray/fonts/hamlet.ttf" 
"By the way he's running"
.001, 0 
texture {pigment{Green}} finish{ambient .4 roughness .01 crand .1}
scale <1.25,1,1> rotate -30*x translate <-4.5,9,-15>
no_shadow
}
text{ttf "/home/matt/povray/fonts/hamlet.ttf" 
"He'll be in Tennessee"
.001, 0 
texture {pigment{Green}} finish{ambient .4 roughness .01 crand .1}
scale <1.25,1,1> rotate -30*x translate <-4.5,8,-15>
no_shadow
}
#end

