/*
===========================================================
     ATTENTION!!!!

     This file is in the Public Domain.
     Provided by the Internet Movie Project (www.imp.org)
===========================================================

 File        : sand.inc
 Project     : IRTC Entry for "The end of..." round
 cvs module  : theendof
 POV Version : 3.5
 Desc        : hourglass sand particle system file
 Date        : 20031031
 Created by  : Sascha Ledinsky 
 Edited by   :  Tom Galvin (tom - at - imp - dot - org)
 Copyright   : Released into the Public Domain
 
===========================================================
*/

// one unit = 1cm, time unit = 1sec

#local source		= <0,10,0>;
#local g 		= 9.81;		// gravity in m/s/s
#local t_start 		= 0;
#local t_end 		= 10;
#local particles	= 8000;		// number of paricles
#local grain_size	= 0.02;

#declare sand = material {
	texture {
		pigment {
			color rgb <.9,.8,.8>
		}
		finish {
			ambient 0.8 diffuse 0.2
		}
	}
}

/*
* compute start time of particle (evenly distributed)
*/
#macro particleStartTime(n)
	n * (t_end - t_fall) / particles
#end

/*
* compute horizontal particle speed (random)
*/
#macro particleHSpeed(n)
	#local r = seed(n*n+100);
	#local dummy = rand(r);
	<rand(r) - 0.5, 0, rand(r)* - 0.5> * 5;
#end

/*
* compute particles position at a given time
*/
#macro particlePosition(n,T)
	#local t_p = T - particleStartTime(n);		// how long has the particle been falling
	#local s = g * t_p * t_p / 2;			// a*t^2/2
	source - <0,s * 100,0> + t_p * particleHSpeed(n)
#end
		
#local s = source.y / 100;				// height to fall in meters
#local t_run = t_end - t_start;
#local t_fall = sqrt(2 * s / g);

#local time = clock_sand;
#local deltaT = clock_delta;

#local p1 = time * particles / (t_run - t_fall);
#local p0 = p1 - particles * t_fall / (t_run - t_fall);

#local p0 = int(max(0,p0));
#local p1 = int(min(particles - 1,p1));

#local p = p0;
#local rnd = seed(p);
#while (p <= p1)
	#local pos_this = particlePosition(p,time);
	#local pos_next = particlePosition(p,time + deltaT);
	union {
		sphere { pos_this, grain_size }
		sphere { pos_next, grain_size }
		cylinder { pos_this, pos_next, grain_size}
		material { sand }
	}
	#local p = p + 1;
#end




