/*
===========================================================
     ATTENTION!!!!

     This file is in the Public Domain.
     Provided by the Internet Movie Project (www.imp.org)
===========================================================

 File        : floor.inc
 Project     : IRTC Entry for "The end of..." round
 cvs module  : theendof
 POV Version : 3.5
 Description : a stone floor
 Date        : 20031116
 Created by  : Sascha Ledinsky
 Copyright   : Released into the Public Domain
 
===========================================================
*/

#declare stone1 = pigment {
	granite
	color_map {
		[0.0 color rgb 0.4]
		[1.0 color rgb 0.2]
	}
	turbulence 0.5
}

#declare stone2 = pigment {
	granite
	color_map {
		[0.0 color rgb 0.8]
		[1.0 color rgb 0.5]
	}
	scale 0.25
	turbulence 0.5
}

#declare stone_floor = material {
	texture {
		pigment {
			crackle
			pigment_map {
				[0.00 stone2]
				[0.20 stone2]
				[0.20 stone1]
				[1.00 stone1]
			}
			 turbulence 0.1
			 poly_wave 0.5
     			 scale 1
		}
		finish { ambient 0.0 diffuse 0.9 specular 0.5 roughness 0.05 }
		normal {
			crackle 0.75
			slope_map {
				[0.00 0.00]
				[0.20 0.00]
				[0.25 0.10]
				[0.30 0.15]
				[1.00 1.00]
			}
			turbulence 0.1
			poly_wave 0.5
		}
		scale 0.5
	}
}

plane {
	y,0
	material { stone_floor }
}
