/*
===========================================================
     ATTENTION!!!!

     This file is in the Public Domain.
     Provided by the Internet Movie Project (www.imp.org)
===========================================================

 File        : hourglass_holder.inc
 Project     : IRTC Entry for "The end of..." round
 cvs module  : theendof
 POV Version : 3.5
 Description : Makes Sythe
 Date        : 20031115
 Created by  : Dennis Borree
 Modified by : Dennis Borree 20031225 (trulayne - at - new - dot - rr - dot - com)
 Copyright   : Released into the Public Domain
 
===========================================================
*/

#include "include/metals.inc"

#declare sythe_texture1=T_Chrome_5A;
#declare sythe_texture2=T_Wood7;

#ifdef (clock02)
#declare highlight_clock = clock02 - 2;
#else
#declare highlight_clock = 0;
#end


#declare trans = 0;
#if (highlight_clock >=0 & highlight_clock < 1)
	#declare trans = highlight_clock;
#end
/*
#if (highlight_clock >= 1 & highlight_clock <=3)
	#declare trans = 1;
#end
*/
#if (highlight_clock >= 1 & highlight_clock <=2)
	#declare trans = (2 - highlight_clock);
#end

//#debug str(trans,5,5)

#macro highlight()
	disc {
		<0,0,0>,<0,0,-1>,1
		texture {
			pigment {
				onion
				pigment_map {
					[0.0 color rgbt <2,2,2,1-trans>]
					[0.1 radial
						triangle_wave
						frequency 16
						color_map {
							[0.0 color rgbt<0,0,0,1>]
							[0.6 color rgbt<0,0,0,1>]
							[0.8 color rgbt<2,2,1,1 - 0.5 * trans>]
							[1.0 color rgbt<2,2,2,1 - trans>]
						}
						rotate <90,0,0>
					]
					[0.6 transmit 1]
					[1.0 transmit 1]
				}
				rotate highlight_clock * 60 * z
			}
			finish { ambient 1 diffuse 0 }
		}
		texture {
			pigment {
				onion
				pigment_map {
					[0.0 color rgbt <2,2,2,1-trans>]
					[0.1 radial
						triangle_wave
						frequency 7
						color_map {
							[0.0 color rgbt<0,0,0,1>]
							[0.9 color rgbt<0,0,0,1>]
							[0.95 color rgbt<1,1,2,1 - 0.5 * trans>]
							[1.0 color rgbt<2,2,2,1 - trans>]
						}
						rotate <90,0,0>
					]
					[1.0 transmit 1]
				}
				rotate -highlight_clock * 40 * z
			}
			finish { ambient 1 diffuse 0 }
		}
		scale 0.5
		translate <-0.4,0.17,0.1>
		translate highlight_clock/2*<0.3,-0.07,0>
	}
	
#end

#declare sythe = union {
	difference {
		cylinder {<0,.5,0>,<0,.5,.1>,.5 texture {sythe_texture1}}
            	cylinder {<.05,.65,-1>,<.05,.65,1.2>,.6 texture {sythe_texture1}}
		box{<0,0,-.1>,<5,2,1> texture {sythe_texture1}}
		box{<.1,0,0>,<-5,2,-1> rotate x*5 texture {sythe_texture1}}
		box{<0,0,.1>,<-5,1,1> rotate x*-5 texture {sythe_texture1}} 
		translate x*0.01 scale <1.5,1,1>
	}
        cylinder {<0,0,.05>,<0,.06,.05>,.03 texture {sythe_texture1}}
            
            
              sphere_sweep {
    cubic_spline
    6,
    <0, -1.8, 0.05>, .025
    <0.003, 0, 0.05>, .025
    <-.08,  .5, 0.05>, .025
    < -.27, 1, 0.05>, .025
    < -.35,  1.5, 0.05>, .025
    < -.35,  1.6, 0.05>, .025
    texture {sythe_texture2 scale .2 rotate x*95}
  }
  cylinder {<0,0,0>,<-.13,0,0>,.020 rotate  z*25 translate <-.18,.8,.05>  texture {sythe_texture2 scale .2}}
  cylinder {<0,0,0>,<-.13,0,0>,.020 rotate  z*15 translate <-.27,1.1,.05> texture {sythe_texture2 scale .2}}
  
  //sphere {<-0.4,0.17,0.1>,0.03 pigment { color rgb 1 } finish { ambient 1 } }
  //sphere {<-0.1,0.1,0.1>,0.03 pigment { color rgb 1 } finish { ambient 1 } }
  //cylinder { <0,0,0>,<0,0,1>,0.05 pigment { color rgb 1 } finish { ambient 1 } }
  #ifdef (clock02)
  highlight()
  #end
}


