/*
===========================================================
     ATTENTION!!!!

     This file is in the Public Domain.
     Provided by the Internet Movie Project (www.imp.org)
===========================================================

 File        : name_plate.inc
 Project     : IRTC Entry for "The end of..." round
 cvs module  : theendof
 POV Version : 3.5
 Description : Name plates for hourglasses
 Date        : 20031214
 Created by  : Dennis Borree (trulayne - at - new - dot - rr - dot - com)
 Modified by : Dennis Borree 20031220 (trulayne - at - new - dot - rr - dot - com)
 Copyright   : Released into the Public Domain
 
===========================================================
*/


#include "include/shapes.inc"
#include "include/metals.inc"
#declare name_number=100;

#macro Name_Plate(name_number)

#declare name_text="meditg";

///////////////////////////////// names for hourglasses /////////////////////////////////

#if (name_number = 1) #local name_text = "KSVTHS1"; #end
#if (name_number = 2) #local name_text = "PMYAHS2"; #end
#if (name_number = 3) #local name_text = "XEWIUJ3"; #end
#if (name_number = 4) #local name_text = "PMHDFR4"; #end
#if (name_number = 5) #local name_text = "BVNCVD5"; #end
#if (name_number = 6) #local name_text = "QASWZX6"; #end
#if (name_number = 7) #local name_text = "POILKI7"; #end
#if (name_number = 8) #local name_text = "NBMHGF8"; #end
#if (name_number = 9) #local name_text = "QWERTY9"; #end
#if (name_number = 10) #local name_text = "CMVNTY10"; #end
#if (name_number = 11) #local name_text = "AXLJFG11"; #end
#if (name_number = 12) #local name_text = "ECDSJM12"; #end
#if (name_number = 13) #local name_text = "DFKTUR13"; #end
#if (name_number = 14) #local name_text = "EXDCGT14"; #end
#if (name_number = 15) #local name_text = "AZSXTG15"; #end
#if (name_number = 16) #local name_text = "TGBEDC16"; #end
#if (name_number = 17) #local name_text = "MJUVFR17"; #end
#if (name_number = 18) #local name_text = "XSWVGT18"; #end
#if (name_number = 19) #local name_text = "UJMADG19"; #end
#if (name_number = 20) #local name_text = "IKEDBG20"; #end
#if (name_number = 21) #local name_text = "ALSKDJ21"; #end
#if (name_number = 100) #local name_text = "SPAM"; #end
#if (name_number = 101) #local name_text = "BIGOTRY"; #end
#if (name_number = 102) #local name_text = "HATE"; #end
#if (name_number = 103) #local name_text = "DISEASE"; #end
#if (name_number = 104) #local name_text = "WARFARE"; #end

////////////////////////////////////////////////////////////////////////////////////////

//////////////////////////// calc for creating name plates /////////////////////////////
                               
#declare name_width= Text_Width(nameplate_font, name_text, 1, 0); // get standaed name width                             
#declare name_size= 0.09/name_width;                              // calc scaling
#if (name_size> 0.017) #declare name_size= 0.017; #end            // max scaling
#declare name_offset= 0.0125-0.35*name_size;                      // how much to move name up to center in name plate
#declare name_center= Text_Width(nameplate_font, name_text, name_size,0); // scene width of name
#declare screw_spread= 10000*base_width*base_width-1759.17*base_width+98.4; // screw spacing based on hourglass size

/////////////////////////////////////////////////////////////////////////////////////////

/////////////////////////////////// name plate builder //////////////////////////////////

#declare hg_screw = difference{sphere{<0, 0, 0>, 1}
                               box{<-2, 0.125, -0.3>,<2, -0.125, -2.3> }
                               scale 0.003 }
                               
#declare border_1= cylinder{<0, 0, 0>,<0, 0, -0.16>, 0.003}                              
#declare border_2= difference{box {<-0.053, 0.01025, -0.16><0.053, -0.01025, 0>  }
                              object{border_1 translate <-.053, 0.01025, 0>}
                              object{border_1 translate <.053, 0.01025, 0>}
                              object{border_1 translate <-.053, -0.01025, 0>}                     
                              object{border_1 translate <.053, -0.01025, 0>}
                                      }
                                      
#declare border_3 = difference{object {border_2 scale <1.02,1.1,1>}
                               object {border_2 scale <0.98, 0.9, 1>}
                               cylinder {<0, -0.2, 0>,<0, 0.02, 0>, 0.1528*base_width/0.08} pigment{rgb<1, 1, 0.6>} finish{ambient 0.0} // <0.8, 0.498039, 0.196078>
                               }                               
                               
#declare name_plate_name= difference{text {ttf nameplate_font name_text 10, 0  scale name_size translate <-name_center/2, name_offset, -0.15>} 
                                cylinder {<0, 0, 0>,<0, 0.025,0>, 0.1528*base_width/0.08} pigment{rgb <1, 1, 0.6>} finish{ambient 0.0}}                               


 difference{union{intersection{difference{cylinder {<0, 0, 0>,<0, 0.025, 0>, 0.153*base_width/0.08}
                                cylinder {<0, 0, 0>,<0, 0.03, 0>, 0.15*base_width/0.08}
                                object{name_plate_name}
                                }
                                superellipsoid {<0.2, 0.8> scale <0.06, 0.012, 1.21> translate <0, 0.0123, -0.15> }
                                texture{T_Brass_3B}}
                                object {hg_screw rotate z*(360*rand(r))translate <0, 0.006, -0.152*base_width/0.08> rotate y*screw_spread texture{T_Brass_4A}}
                                object {hg_screw rotate z*(3600*rand(r)) translate <0, 0.006, -0.152*base_width/0.08> rotate y*-screw_spread texture{T_Brass_4A}}
                                }
                                box {<-3, -3, 3>,<3, 3, 0> pigment {White}}
                                object {border_3 translate <0, 0.01225,0>}
                                }
                                
/////////////////////////////////////////////////////////////////////////////////////////                                
#end                                