/*
===========================================================
     ATTENTION!!!!

     This file is in the Public Domain.
     Provided by the Internet Movie Project (www.imp.org)
===========================================================

 File        : shot00.inc
 Project     : IRTC Entry for "The end of..." round
 cvs module  : theendof
 POV Version : 3.5
 Description : IMP Logo Shot
 Date        : 20031031
 Created by  : Tom Galvin (tom - at - imp - dot - org)
 Edited by   :  
 Copyright   : Released into the Public Domain
 
===========================================================
*/

//
//   15 seconds
//

#declare clock_logo = clock00/7;
#include "include/colors.inc"
#include "include/textures.inc"



camera {  angle 65                                               // changed  10/12/02 Dennis Borree
          up y * image_height                                    //     added to so camera    10/12/02
          right x * image_width                                  //     auto uses image size  Dennis Borree
#if (clock_logo < 1.5)
          location <13*(1-sin(radians(clock_logo/1.5*90))),0,-10*sin(radians(clock_logo/1.5*90))> //(1-sin(radians(clock_logo/1.5*90)))
        #else
          location <0,0,-10>
        #end
          look_at <0,0,0>}

#if (clock_logo >= 1)
	text {
		ttf "fonts/nuworld4.ttf"
		"I  N  T  E  R  N  E  T"
		0.25,0
		pigment {rgb <0.956862745098039+((1-0.956862745098039)*(1-cos(radians((clock_logo-1)*180)))),0.650980392156863+((1-0.650980392156863)*(1-cos(radians((clock_logo-1)*180)))),4.31372549019608E-02+((1-4.31372549019608E-02)*(1-cos(radians((clock_logo-1)*180))))>}
		scale <.85,1.4,1.0>
		translate <-2.2,0.7,0>
		
		#if (clock_logo>=1.3)                            //
		translate <0,0,0>                             //   10/22/02 Dennis Borree
		#else                                         //
		translate <0,0,0.126-0.126*(clock_logo-1)/0.3>   //
		#end
		
		//translate <0,0,0.126- (sin(radians((clock_logo-1)*1*90))*0.126) > //.126- (sin(radians((clock_logo-1)*1*90))*0.126)

	}
#end

#declare logo_fadeout=0;
#if (clock_logo > 1.875)
#declare logo_fadeout=(clock_logo-1.875)/.25;
#end

light_source {<-5,5,-7> White*(1-logo_fadeout)}    //.35
#if(clock_logo >1)
light_source {<0,5,-17> White*.05*(1-logo_fadeout) shadowless}
#end
#if (clock_logo < 1)
	light_source {
		<0,-1,-5>
		#if (clock_logo < 0.25)
			White*sin(radians(clock_logo*4*90))
		#else
			#if (clock_logo <= 0.75)
				White
			#else
				White*sin(radians(90-(((clock_logo*4)-3)*90)))
			#end
		#end
		spotlight
		point_at <-1.75+(clock_logo*3.5),0.6,0>
		radius 6
		tightness 2
		falloff 12
		translate <0,-0.375,0>
	}
#end

#if (clock_logo < 1)
	light_source {<-5+(5*sin(radians(clock_logo*90))),0,-5-(sin(radians(clock_logo*75))*2)> White spotlight point_at <0,(1-sin(radians(clock_logo*90)))*3,0> radius 10 tightness 2 falloff 20}
#else
	light_source {<0,0,-5-(sin(radians(clock_logo*60))*2)> White*(1-logo_fadeout) spotlight point_at <0,0,0> radius 10 tightness 2 falloff 20}//140 4 20
#end


#declare M_Offset = <-0.02002-(0.505859/2) + 0.075-.2,-0-(0.75/2),-0.125>;
#declare O_Offset = <-0.02002-(0.768066/2)-.05,0.006104-(0.768066/2),-0.125>;
#declare V_Offset = <-0.02002-(0.35498/2)-.2,-0-(0.75/2),-0.125>;
#declare I_Offset = <-0.020996-(0.063965/2),-0-(0.75/2),-0.125>;
#declare E_Offset = <-0.02002-(0.272949/2),-0-(0.75/2),-0.125>;

#declare M_Pos = -0.17749-1-0.768066-(0.505859/2) + 0.4685055;
#declare O_Pos = -0.17749-0.5-(0.768066/2) + 0.4685055;
#declare V_Pos = 0 + 0.4685055;
#declare I_Pos = 0.17749+0.5+(0.063965/2) + 0.4685055;
#declare E_Pos = 0.17749+1+0.063965+(0.272949/2) + 0.4685055;

#declare Project = text {
	ttf "fonts/riverave.ttf"
	"PROJECT"
	0.25, 0
	pigment {rgb <0.956862745098039+((1-0.956862745098039)*(1-cos(radians((clock_logo-1)*180)))),0.650980392156863+((1-0.650980392156863)*(1-cos(radians((clock_logo-1)*180)))),4.31372549019608E-02+((1-4.31372549019608E-02)*(1-cos(radians((clock_logo-1)*180))))>}
	scale <1.13,1.13,1>
	translate <-2.2,-1.05,0>
}

#declare Text_Y = 0.425;
#if (clock_logo >=1)
	disc {<0,0,0> <0,0,1> 0.35
		texture {
			pigment { //White
				image_map {
					gif "image/reel.gif"
				}
				scale 0.45
				translate .45/2
				rotate <0,0,(clock_logo-1)*100>
				//rotate <0,0,clock_logo*360>// this keeps it rotating //rotate <0,0,sin(radians((clock_logo-1)*180))*60>
				scale 1.35
				translate <-0.01,-.01,0>
			}
		}
		texture {
		#if (clock_logo <1.5)
			pigment {rgbf <0.956862745098039+((1-0.956862745098039)*(1-cos(radians((clock_logo-1)*180)))),0.650980392156863+((1-0.650980392156863)*(1-cos(radians((clock_logo-1)*180)))),4.31372549019608E-02+((1-4.31372549019608E-02)*(1-cos(radians((clock_logo-1)*180)))),1-cos(radians((clock_logo-1)*180))>} //1-cos(radians((clock_logo-1)*180))//0.956862745098039+((1-0.956862745098039)*(1-cos(radians((clock_logo-1)*90)))),0.650980392156863+((1-0.650980392156863)*(1-cos(radians((clock_logo-1)*90)))),4.31372549019608E-02+((1-4.31372549019608E-02)*(1-cos(radians((clock_logo-1)*90))))
	        #else
	        pigment {rgbf <1,1,1,1>}
	        #end
		}
		#if (clock_logo<1.5)
		translate <-0.17749-0.5-(0.768066/2)-.05 + 0.4685055,Text_Y,0.126-(sin(radians((clock_logo-1)*180))*0.226)>//0.126-(sin(radians((clock_logo-1)*90))*0.226)>//.225
		#else
		translate <-0.17749-0.5-(0.768066/2)-.05 + 0.4685055,Text_Y,-.1>
		#end
		translate <0,-0.375,0>
	}
#end

#declare Letter_Texture = texture {pigment {SkyBlue}};
#if (clock_logo < 1)
	#declare O_Letter_Texture = texture {pigment {rgb <0.196078, 0.6, 0.8>}};
#else
	#if (clock_logo < 1.5)
		#declare O_Letter_Texture = texture {pigment {rgb <0.196078+((1-0.196078)*sin(radians((clock_logo-1)*90))), 0.6+((1-0.6)*sin(radians((clock_logo-1)*90))), 0.8+((1-0.8)*sin(radians((clock_logo-1)*90)))>}}
	#else
		#declare O_Letter_Texture = texture {pigment {White}}
	#end
#end

#declare M = text {ttf "fonts/fashionv.ttf" "M" 0.25,0 texture {Letter_Texture} translate M_Offset translate <M_Pos,Text_Y,0>};
#declare O = text {ttf "fonts/cetus.ttf" "O" 0.25,0 texture {O_Letter_Texture}scale <1.1,1,1> translate O_Offset translate <O_Pos,Text_Y,0>};
#declare V = text {ttf "fonts/fashionv.ttf" "V" 0.25,0 texture {Letter_Texture} translate V_Offset translate <V_Pos,Text_Y,0>};
#declare I = text {ttf "fonts/fashionv.ttf" "I" 0.25,0 texture {Letter_Texture} translate I_Offset translate <I_Pos,Text_Y,0>};
#declare E = text {ttf "fonts/fashionv.ttf" "E" 0.25,0 texture {Letter_Texture}scale<1,-1,1> translate E_Offset translate <E_Pos,Text_Y+.70,0>};

union {

#switch (clock_logo)
	#range (0, 0.2)
		#declare NClock = clock_logo*5;
		object {M translate <0,0,0.251-(sin(radians((NClock)*90))*0.251)>}
	#break
	#range (0.2, 0.4)
		#declare NClock = (clock_logo*5)-1;
		object {O translate <0,0,0.251-(sin(radians((NClock)*90))*0.251)>}
		object {M}
	#break
	#range (0.4, 0.6)
		#declare NClock = (clock_logo*5)-2;
		object {V translate <0,0,0.251-(sin(radians((NClock)*90))*0.251)>}
		object {M}
		object {O}
	#break
	#range (0.6, 0.8)
		#declare NClock = (clock_logo*5)-3;
		object {I translate <0,0,0.251-(sin(radians((NClock)*90))*0.251)>}
		object {M}
		object {O}
		object {V}
	#break
	#range (0.8, 1)
		#declare NClock = (clock_logo*5)-4;
		object {E translate <0,0,0.251-(sin(radians((NClock)*90))*0.251)>}
		object {M}
		object {O}
		object {V}
		object {I}
	#break
	#range (0.99999999,10)
		object {M}
		object {O}
		object {V}
		object {I}
		object {E}
	#break
#end

#if (clock_logo >= 1)
	object {Project
	 
	        #if (clock_logo>=1.3)                           //
		translate <0,0,0>                            //
		#else                                        //  10/22/02 Dennis Borree
		translate <0,0,0.126-0.126*(clock_logo-1)/0.3>  //
		#end }                                       //
		//translate <0,0,0.126- (sin(radians((clock_logo-1)*1*90))*0.126) >} //.126- (sin(radians((clock_logo-1)*1*90))*0.126)
#end

translate <0,-0.375,0>
}

#declare Block_Height = 1.35;

union {
	box {<-2.5,-Block_Height-.5,0.125> <2.5,Block_Height+.5,0.25>pigment {rgb <0.956862745098039,0.650980392156863,4.31372549019608E-02>}}
	box {<-2.3,-Block_Height-0.05,0.175> <2.3,Block_Height+0.05,0.25>}

	union {
		triangle {<-2.25,Block_Height,0.125> <2.25,Block_Height,0.125> <2.3,Block_Height+0.05,0.175>}
		triangle {<-2.25,Block_Height,0.125> <-2.3,Block_Height+0.05,0.175> <2.3,Block_Height+0.05,0.175>}

		triangle {<-2.25,-Block_Height,0.125> <2.25,-Block_Height,0.125> <2.3,-Block_Height-0.05,0.175>}
		triangle {<-2.25,-Block_Height,0.125> <-2.3,-Block_Height-0.05,0.175> <2.3,-Block_Height-0.05,0.175>}


		triangle {<-2.25,-Block_Height,0.125> <-2.25,Block_Height,0.125> <-2.3,Block_Height+0.05,0.175>}
		triangle {<-2.25,-Block_Height,0.125> <-2.3,-Block_Height-0.05,0.175> <-2.3,1.05,0.175>}

		triangle {<2.25,-Block_Height,0.125> <2.25,Block_Height,0.125> <2.3,Block_Height+0.05,0.175>}
		triangle {<2.25,-Block_Height,0.125> <2.3,-Block_Height-0.05,0.175> <2.3,Block_Height+0.05,0.175>}
		pigment {SkyBlue}
	}
	
   }

#if (clock_logo > 1)
union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.450, 0.000, -0.200> <-0.443, 0.117, -0.200> <-0.406, 0.291, -0.200> <-0.303, 0.363, -0.200>
		<-0.450, 0.000, -0.140> <-0.443, 0.117, -0.140> <-0.406, 0.291, -0.140> <-0.303, 0.363, -0.140>
		<-0.450, 0.000, -0.060> <-0.443, 0.117, -0.060> <-0.404, 0.289, -0.060> <-0.303, 0.363, -0.060>
		<-0.450, 0.000, 0.000> <-0.443, 0.117, 0.000> <-0.404, 0.289, 0.000> <-0.303, 0.363, 0.000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.303, 0.363, -0.200> <-0.177, 0.453, -0.200> <-0.020, 0.514, -0.200> <0.173, 0.441, -0.200>
		<-0.303, 0.363, -0.140> <-0.177, 0.453, -0.140> <-0.020, 0.519, -0.140> <0.173, 0.446, -0.140>
		<-0.303, 0.363, -0.060> <-0.178, 0.456, -0.060> <-0.020, 0.531, -0.059> <0.173, 0.454, -0.060>
		<-0.303, 0.363, 0.000> <-0.178, 0.456, -0.000> <-0.020, 0.537, 0.000> <0.173, 0.459, -0.000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.173, 0.441, -0.200> <0.383, 0.361, -0.199> <0.408, 0.157, -0.199> <0.523, 0.050, -0.197>
		<0.173, 0.446, -0.140> <0.383, 0.367, -0.139> <0.394, 0.157, -0.141> <0.509, 0.050, -0.139>
		<0.173, 0.454, -0.060> <0.376, 0.372, -0.061> <0.383, 0.158, -0.059> <0.491, 0.050, -0.061>
		<0.173, 0.459, -0.000> <0.376, 0.378, -0.001> <0.369, 0.158, -0.001> <0.477, 0.050, -0.003>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.523, 0.050, -0.197> <0.608, -0.028, -0.196> <0.799, -0.064, -0.196> <0.838, -0.173, -0.190>
		<0.509, 0.050, -0.139> <0.594, -0.028, -0.138> <0.776, -0.052, -0.142> <0.815, -0.160, -0.136>
		<0.491, 0.050, -0.061> <0.562, -0.022, -0.062> <0.749, -0.049, -0.058> <0.784, -0.144, -0.064>
		<0.477, 0.050, -0.003> <0.548, -0.022, -0.004> <0.726, -0.037, -0.004> <0.761, -0.131, -0.010>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.838, -0.173, -0.190> <0.874, -0.272, -0.185> <0.783, -0.417, -0.171> <0.724, -0.504, -0.168>
		<0.815, -0.160, -0.136> <0.851, -0.259, -0.131> <0.757, -0.381, -0.130> <0.698, -0.469, -0.127>
		<0.784, -0.144, -0.064> <0.814, -0.223, -0.069> <0.714, -0.353, -0.070> <0.664, -0.421, -0.073>
		<0.761, -0.131, -0.010> <0.791, -0.211, -0.015> <0.688, -0.317, -0.030> <0.638, -0.385, -0.032>
	}
	pigment {White filter 1-sin(radians((clock_logo-1)*1*90))}
	scale 0.9
	translate <-0.17749-0.5-(0.768066/2) + 0.4685055,Text_Y,0.125>
	translate <0,-0.375,0>
}
#end


#if (clock_logo >=1.875)
        box {<-10,-5,-4> <10,5,-3>   pigment { color rgbt <0,0,0, 2*(2.375-clock_logo)>}}  // fade to black - go from 1.0 to .25 
#end
