/*
===========================================================
     ATTENTION!!!!

     This file is in the Public Domain.
     Provided by the Internet Movie Project (www.imp.org)
===========================================================

 File        : shot03.inc
 Project     : IRTC Entry for "The end of..." round
 cvs module  : theendof
 POV Version : 3.5
 Description : a shot in the narrow alleyway
 Date        : 20031108
 Created by  : Sascha Ledinsky
 Modified by : Dennis Borree 20031124 (trulayne - at - new - dot - rr - dot - com)
             : Dennis Borree 20031214 (trulayne - at - new - dot - rr - dot - com) 
 Copyright   : Released into the Public Domain
 
===========================================================
*/

//
//   14 seconds
//

/*
#include "include/colors.inc"
#include "include/textures.inc"
#include "include/shapes.inc"
#include "include/metals.inc"
#include "include/glass.inc"
#include "include/woods.inc"
*/

#declare clock_shelfs=clock03;
#declare camera_location = <0,3.4+.01*sin(clock_shelfs*2*pi/0.8/2),-2> + <0,0,1 * clock_shelfs * 0.8/2>; // up and down motion added

#include "scenes/flame/flame.inc"
#include "scenes/shelfs/shelfs.inc"
#include "scenes/shelfs/shelf_fill.inc"
#include "scenes/shelfs/hourglass_holder.inc"
#include "scenes/shelfs/torch.inc"



camera {
	right <16/9,0,0>
	up <0,1,0>
	location camera_location
	look_at <0,3.1,0> + <0,0,1 * clock_shelfs * 0.8/2>
	angle 70//90
	//translate <0,0,1 * clock_shelfs * 0.8/2>
}

#declare Dimmer=.7;

/*
light_source {
	<0,2.5,-5>
	color rgb 1*Dimmer
}

light_source {
	<0,5,0> 
	color rgb <1,0.7,0.4>*Dimmer
	fade_power 2
	fade_distance 100
} 

light_source {
	<-5,5,-5>
	color rgb 1*Dimmer
	shadowless
}

light_source {
	<0,10,25>
	color rgb <2,1.5,1> * 8*Dimmer
	shadowless
	spotlight
	point_at <0,0,25>
	radius 30
	falloff 50
}

*/

//////////// Fog //////////////////////

  /*fog {
    distance .5
    color rgbft<1, 1, 1, 0, .8>
    turbulence .2
    turb_depth .3
  }
  
  fog {
    distance 1.5
    color rgbft<1.0, 1.0, 1.0, 0, .9>
    turbulence 1
    turb_depth .9
    fog_type 2
    fog_offset .4
    fog_alt .3
  }
  
  box {<10,20,31>,<-10,0,30>}*/

//////////// Fill Shelves  /////////////////////////////////////////

#declare pre_row1=4;
#declare pre_row2=7;
#declare pre_column1=9;
#declare pre_column2=28;
#declare row_finish=9;//6;     //9
#declare column_finish=33;//15; //33
#declare row_start=3;//6;      //3
#declare column_start=9;   //9
#declare shelving=1;

shelf_fill(row_start,row_finish,column_start,column_finish,shelving)
 
#declare shelving=2;

shelf_fill(row_start,row_finish,column_start,column_finish,shelving)


///////////  Bat   //////////////////    


#declare bat_z1=clock03*0.4;
#declare bat_y1=-1;
#declare bat_z2=clock03*0.4;
#declare bat_y2=-1;

#declare bat_move1= spline{
                        cubic_spline
    
                       -0.2,  <0.0, 3.8+bat_y1, -0.1+bat_z1>
                        0.0,  <0.0, 4+bat_y1, 1+bat_z1>,
                        0.1,  <0.1,  8+bat_y1, 3+bat_z1>,
                        0.25, <-0.1,  6+bat_y1, 4+bat_z1>,
                        0.3,  < 0.2,  7+bat_y1, 3+bat_z1>,
                        0.4,  <-0.1, 5+bat_y1, 3.5+bat_z1>,
                        0.55, <-0.3, 4+bat_y1, 3+bat_z1>,
                        0.6,  <0.3, 6+bat_y1, 4+bat_z1>,
                        0.7,  <0.0, 5+bat_y1, 4+bat_z1>,
                        0.85, <0.2, 6+bat_y1, 3.5+bat_z1>,
                        0.9,  <0.3, 5+bat_y1, 4+bat_z1>,
                        1.0,  <0.5, 4+bat_y1, 5+bat_z1>,
                        1.1,  <0.0, 3.8+bat_y1, 6.1+bat_z1>,
                        }
                        
#declare bat_move2= spline{
                        cubic_spline
                        
                       -0.2,  <0.0, 3.8+bat_y2, 6.1+bat_z2>,
                        0.0,  <0.5, 4+bat_y2, 5+bat_z2>,
                        0.1,  <0.3, 5+bat_y2, 4+bat_z2>,
                        0.25, <0.2, 6+bat_y2, 3.5+bat_z2>,
                        0.3,  <0.0, 5+bat_y2, 4+bat_z2>,
                        0.4,  <0.3, 6+bat_y2, 4+bat_z2>,
                        0.55, <-0.3, 4+bat_y2, 3+bat_z2>,
                        0.6,  <-0.1, 5+bat_y2, 3.5+bat_z2>,
                        0.7,  < 0.2,  7+bat_y2, 3+bat_z2>,
                        0.85, <-0.1,  6+bat_y2, 4+bat_z2>,
                        0.9,  <0.1,  8+bat_y2, 3+bat_z2>,
                        1.0,  <0.0, 4+bat_y2, 1+bat_z2>,
                        1.1,  <0.0, 3.8+bat_y2, -0.1+bat_z2>
                                                
                        }


#declare bat_color=rgb 1;
#declare bat_time=clock03;
#include "scenes/room/bat.inc"
                   
object {bat scale 0.01 Spline_Trans(bat_move1,(bat_time/6), y, 0.01, 0.05) pigment{rgb bat_color}}
object {bat scale 0.01 Spline_Trans(bat_move2,(bat_time/6), y, 0.01, 0.05) pigment{rgb bat_color}}

/*#declare tt=0;
#while (tt<1)
sphere{<0,0,0>,.03 Spline_Trans(bat_move1,tt, y, .1, 0) translate x*0 pigment {Red}}
sphere{<0,0,0>,.03 Spline_Trans(bat_move2,tt, y, .1, 0) translate x*0 pigment {Blue}}
#declare tt=tt+.005;
#end*/

////// torch positions //////////////////////////

//#local flame_1_pos = <-.4,3.39+.5,-.7+.3*20>;
//#local flame_2_pos = <.4,3.39+.5,-.7+.3*40>;
//#local flame_3_pos = <-.4,3.39+.5,-.7+.3*60>;

#local torch_mount_height = 3.5;

#local flame_0_pos = <.4,torch_mount_height,-.7-.3*10>;  
#local flame_1_pos = <-.4,torch_mount_height,-.7+.3*05>;  
#local flame_2_pos = <.4,torch_mount_height,-.7+.3*20>;   
#local flame_3_pos = <-.4,torch_mount_height,-.7+.3*35>;

object{torch scale 0.66 translate flame_1_pos}
object{torch scale 0.66 rotate y*180 translate flame_2_pos}
object{torch scale 0.66 translate flame_3_pos}

//flame(camera_location, flame_position, flame_height, time, hotair)
/*
* flames
*/
#if(true)
	flame(camera_location, flame_0_pos, 0.7 * 0.66, clock03 - 100, false) // flame behind us
	flame(camera_location, flame_1_pos, 0.7 * 0.66, clock03, false)	// add flame with hot air
	flame(camera_location, flame_2_pos, 0.7 * 0.66, clock03 + 100, false)
	flame(camera_location, flame_3_pos, 0.7 * 0.66, clock03 + 200, false)
#end

/*
* to light the floor...
*/
#if(true)
	light_source {
		<0,3,-30> + <0,0,1 * clock_shelfs * 0.8/2>
		color rgb <3,3,2.5>
		spotlight
		point_at <0,0,6> + <0,0,1 * clock_shelfs * 0.8/2>
		radius 0
		falloff 1.2
	}
#end

/*
* bluish light originating from camera
*/
#if(true)
	light_source {
		camera_location
		color rgb <0.1,0.1,0.3>
		fade_power 2
		fade_distance 1.5
		shadowless
	}
#end

/*
fog {
	fog_type 2
	color rgb 0
	distance 10
	fog_alt 1
}
*/