/*
===========================================================
     ATTENTION!!!!

     This file is in the Public Domain.
     Provided by the Internet Movie Project (www.imp.org)
===========================================================

 File        : shot05.inc
 Project     : IRTC Entry for "The end of..." round
 cvs module  : theendof
 POV Version : 3.5
 Description : a shot in the narrow alleyway
 Date        : 20031108
 Created by  : Sascha Ledinsky
 Modified by : Dennis Borree 20031225 (trulayne - at - new - dot - rr - dot - com) 
 Copyright   : Released into the Public Domain
 
===========================================================
*/

//
//   14 seconds
//

/*
#include "include/colors.inc"
#include "include/textures.inc"
#include "include/shapes.inc"
#include "include/metals.inc"
#include "include/glass.inc"
#include "include/woods.inc"
*/

#declare clock_shelfs=clock05;

#include "scenes/shelfs/shelfs.inc"
#include "scenes/shelfs/shelf_fill.inc"
#include "scenes/shelfs/hourglass_holder.inc"
#include "scenes/room/skeleton_hand_presets.inc"
#include "scenes/room/skeleton_hand.inc"
#include "scenes/room/reaper.inc"


camera {
	right <16/9,0,0>
	up <0,1,0>
	location <0.5,0.5,0>
	look_at <-1,0.6 + clock_shelfs / 2,0>
	angle 90
}

#declare Dimmer=.7+0.3*clock05/4;

#if(true)
	light_source {
		<10,0,10>
		color rgb <0.4,0.4,0.8>*Dimmer*Dimmer
		shadowless
	}
	light_source {
		<10,0,-10>
		color rgb <0.8,0.8,0.4>*Dimmer*Dimmer
		shadowless
	}
#end

#if(true)
	light_source {
		<0.5,1,0>
		color rgb 1*Dimmer
		fade_power 2
		fade_distance 2
	}
#end

//////////// Fog //////////////////////

  fog {
    distance 4
    color rgb 0
  }

/////  Fill Shelves  //////////////////////////////////////////////

#declare pre_row1=0;
#declare pre_row2=7;
#declare pre_column1=3;
#declare pre_column2=20;
#declare row_finish=8;    
#declare column_finish=24; 
#declare row_start=0;      
#declare column_start=0;   
#declare shelving=1;

shelf_fill(row_start,row_finish,column_start,column_finish,shelving)

/// basic death figure ///////////



// material definitions for reaper

#declare Kolor= 0.2/Dimmer;

#declare robe_norm = normal {
    bump_map {
      jpeg "image/cloth_robe2.jpg"
       
      bump_size 0.1
    }
     no_bump_scale
  rotate 45}

  
#declare reaper_finish= finish{diffuse 0.8}  

#declare reaper_texture = texture{pigment { color rgb Kolor } 
                                  finish{reaper_finish}
                                  normal{robe_norm}
                                  }
                                  
                                  
/////////////////   Hand & Reaper settings

        #declare wrist_angle_rot=0;
        #declare wrist_angle_twist=0;
        #declare wrist_angle_pivot=0;
        #declare P_Finger1=30;
        #declare P_Finger2=10;
        #declare P_Finger3=20;
        #declare R_Finger1=30;
        #declare R_Finger2=10;
        #declare R_Finger3=20;
        #declare M_Finger1=30;
        #declare M_Finger2=10;
        #declare M_Finger3=20;
        #declare I_Finger1=30;
        #declare I_Finger2=10;
        #declare I_Finger3=20;
        #declare Thumb1=30;
        #declare Thumb1a=50;
        #declare Thumb2=5;
        #declare Thumb3=10;                                  

#switch (clock05)
#range (0.2, 0.4)
#declare I_Finger2=10+30*(clock05-0.2)/0.2;
#break
#range (0.4 ,0.6)
#declare I_Finger2=40-30*(clock05-0.4)/0.2;
#break
#end                                  
                                  
#declare LA_U_Rot=<-5*sind(clock05*180*1.5), 0, 0>;
#declare RA_U_Rot=<5*sind(clock05*180*1.5), 0, 0>;

#if(LA_U_Rot.x>0)
#declare LA_L_Rot=<10*sind((clock05*180*1.5+180)), 0, 0>;
#else
#declare LA_L_Rot=<0, 0, 0>;
#end

#if(RA_U_Rot.x>0)
#declare RA_L_Rot=<10*sind((clock05*180*1.5+180)), 0, 0>;
#else
#declare RA_L_Rot=<0, 0, 0>;
#end

#local LA_U_joint=<0, 68, 0>;
#local LA_L_joint=<0, 58, 1>;
#local RA_U_joint=<0, 68, 0>;
#local RA_L_joint=<0, 58, 0>;                                             

#local LA_L_joint_location=vrotate(LA_L_joint-LA_U_joint, LA_U_Rot);
#local RA_L_joint_location=vrotate(RA_L_joint-RA_U_joint, RA_U_Rot);                                   

/////// reaper figure ///////////

#declare reaper_hood_etc = union{object {reaper_hood texture { reaper_texture }}
                                 object {reaper_eyes pigment {rgb<0, 0, 1>}finish{ambient 1}}
                                 object {reaper_head pigment {rgb<1, 1, 0.8>}}
                                 }

#declare Reaper= merge{object { reaper_LL texture { reaper_texture }rotate x* (5*sind(clock05*180*1.5)) translate y*41 } 
                       object { reaper_RL texture { reaper_texture }rotate x* (-5*sind(clock05*180*1.5))  translate y*41 }
                       object { reaper_LA_U texture { reaper_texture }rotate LA_U_Rot  translate LA_U_joint } //LA_U
                 union{
                       object { reaper_LA_L texture { reaper_texture }}
                       object {Skeleton_hand() rotate <0,0,165> scale <-10,10,10> rotate <-30,90,-30>translate<15,-21,-3>}
                       rotate (LA_L_Rot+LA_U_Rot)  translate LA_L_joint_location translate LA_U_joint } //LA_L
                       object { reaper_RA_U texture { reaper_texture }rotate RA_U_Rot  translate RA_U_joint } //RA_U
                 union{
                       object { reaper_RA_L texture { reaper_texture }}
                       object {Skeleton_hand() rotate <0,0,165> scale <10,10,10> rotate <0,-90,0>translate<-12,-21,-3>}
                       rotate (RA_L_Rot+RA_U_Rot)  translate RA_L_joint_location translate RA_U_joint } //RA_L                           
                       object { reaper_robe texture { reaper_texture } translate y*72 } 
                       object { reaper_hood_etc  translate y*72   translate z*-2}
                       scale 0.035 
                       }
                       
object{Reaper translate <0, 0, (1-clock_shelfs*0.35*1.5)>}

///////////  Bat   ////////////////// 



/*#declare bat_z1=-2.5;
#declare bat_y1=-2;
#declare bat_z2=-2.5;
#declare bat_y2=-2;

#declare bat_move1= spline{
                        cubic_spline
    
                        -.2, <0, 3.8+bat_y1, -0.1+bat_z1>
                        0, <0, 4+bat_y1, 1+bat_z1>,
                        0.1, <-0.4,  8+bat_y1, 3+bat_z1>,
                        0.25, <-0.3,  5+bat_y1, 4+bat_z1>,
                        0.3, < -0.2,  6+bat_y1, 3+bat_z1>,
                        0.4, <-0.4, 5+bat_y1, 3.5+bat_z1>,
                        0.55, <-0.3, 4+bat_y1, 3+bat_z1>,
                        0.6, <-0.3, 6+bat_y1, 4+bat_z1>,
                        0.7, <0, 5+bat_y1, 4+bat_z1>,
                        0.85, <-0.5, 5.5+bat_y1, 3.5+bat_z1>,
                        0.9, <-0.3, 5+bat_y1, 4+bat_z1>,
                        1.0, <-0.5, 4+bat_y1, 5+bat_z1>,
                        1.1, <0, 3.8+bat_y1, 6.1+bat_z1>,
                        }
                        
#declare bat_move2= spline{
                        cubic_spline
                        
                        -.2, <0, 3.8+bat_y2, 6.1+bat_z2>,
                        0, <-0.5, 4+bat_y2, 5+bat_z2>,
                        0.1, <-0.3, 5+bat_y2, 4+bat_z2>,
                        0.25, <-0.4, 6+bat_y2, 3.5+bat_z2>,
                        0.3, <0, 5+bat_y2, 4+bat_z2>,
                        0.4, <-0.3, 6+bat_y2, 4+bat_z2>,
                        0.55, <-0.3, 4+bat_y2, 3+bat_z2>,
                        0.6, <-0.4, 5+bat_y2, 3.5+bat_z2>,
                        0.7, < -0.2,5.5+bat_y2, 3+bat_z2>,
                        0.85, <-0.4, 6+bat_y2, 4+bat_z2>,
                        0.9, <-0.2,6+bat_y2, 3+bat_z2>,
                        1.0, <0, 4+bat_y2, 1+bat_z2>,
                        1.1, <0, 3.8+bat_y2, -0.1+bat_z2>
                                                
                        }

#declare bat_color=rgb <1, 1, 0.7>*0.7;
#declare bat_time=clock05;
#include "scenes/room/bat.inc"
                   
object {bat scale 0.01 Spline_Trans(bat_move1,(bat_time/4), y, 0.01, 0.05) pigment{rgb bat_color}}
object {bat scale 0.01 Spline_Trans(bat_move2,(bat_time/4), y, 0.01, 0.05) pigment{rgb bat_color}}*/






/*#declare tt=0;
#while (tt<1)
sphere{<0,0,0>,.03 Spline_Trans(bat_move1,tt, y, .01, 0) translate x*0 pigment {Red}}
sphere{<0,0,0>,.03 Spline_Trans(bat_move2,tt, y, .01, 0) translate x*0 pigment {Blue}}
#declare tt=tt+.005;
#end */

sphere{<-.7,.03,.09>,.015 pigment{White}finish{ambient 1}}
sphere{<-.7,.03,.13>,.015 pigment{White}finish{ambient 1}}
sphere{<-.68,.04,.09>,.005 pigment{Black}}
sphere{<-.68,.04,.132>,.005 pigment{Black}}



