/* goblet.pov - part 2 of yinyang
Created:    2003.12.31.23.00
Last edied: 2004.01.08.19.15
By:         William de Beaumont
*/

/*
timeline (original idea... has since changed)
start above the goblet
curve down the left side (-x) and start moving clockwise, to view the goblet
while turning, start dragging the outside of the yinyang-to-be
curve back up the front of the goblet (-z)
dragged bits start to curve away from sides of goblet
dragged bits curl back, forming 'eyes'
eyes separate and start moving toward center
--after this file--
start zooming in, with yinyang stretching to fill corners of screen
*/

#include "colors.inc"
#include "textures.inc"
#include "functions.inc"

//#declare DEBUG=1;

#declare CAMPATH =
  spline
  {
    natural_spline
//    -.25, <0,2.64,-.11>,
    -.25, <0,2.64,-.1>,
    0.00, <0,2.64,-.1>,
    0.10, <-0.4, 2.4, -.8>,
    0.18, <-1.6,1.3,-1.2>,
    0.42, <-1.4,1,1.4>,
    0.60, <1.2,1,1.2>,
    0.67, <1.6,1,0>,
    0.75, <1,1,-1>,
//    0.85, <.3,2,-.5>,
    0.85, <.22,1.8,-.7>,
    1.00, <0,2,-.1>,
    1.25, <0,2,0>
  }

#ifdef (DEBUG)
  #declare camframe = 50;
  #while (camframe < 100)
    #declare camtime = camframe / 100;
    sphere
    { CAMPATH(camtime), .02
      texture
      {
        finish {ambient .5}
        #if (clock > camtime)
          pigment {color Green}
        #else
          pigment {color Blue}
        #end
      }
    }
    #declare camframe = camframe + 1;
  #end
#end

#ifndef (DEBUG)
  camera
  {
    location CAMPATH(clock)
    look_at <0,0,0>
  }
#else
/*  camera //around the edge
  {
    location <0,3,-3>
    look_at <0,1,0>
    rotate y*clock*360
  }*/
  camera //overhead
  {
    location <0,3,-.01>
    look_at <0,0,0>
  }
#end

light_source {<0,9,0> color White}

plane
{ y, -5
  texture
  {
    finish {ambient .5}
    pigment
    { checker Black White
      scale 2
    }
  }
}

box
{ <-10,-10,-10>,<10,10,10>
  inverse
  texture
  {
    finish {reflection .7 ambient 0}
    pigment {color Black}
  }
  texture
  {
    finish {ambient .5}
    pigment
    { bozo
      color_map
      {
	[0 rgbt<.5,.5,.5,0>]
	[1 rgbt<.5,.5,.5,.5>]
      }
      scale .1
    }
  }
}

//vertical members of mirror frames
cylinder {<-10,-5,-10>,<-10,10,-10>,.3 pigment {color Gray50}}
cylinder {<-10,-5, 10>,<-10,10, 10>,.3 pigment {color Gray50}}
cylinder {< 10,-5,-10>,< 10,10,-10>,.3 pigment {color Gray50}}
cylinder {< 10,-5, 10>,< 10,10, 10>,.3 pigment {color Gray50}}

//floor members
cylinder {<-10,-5,-10>,<-10,-5, 10>,.3 pigment {color Gray50}}
cylinder {<-10,-5, 10>,< 10,-5, 10>,.3 pigment {color Gray50}}
cylinder {< 10,-5, 10>,< 10,-5,-10>,.3 pigment {color Gray50}}
cylinder {< 10,-5,-10>,<-10,-5,-10>,.3 pigment {color Gray50}}

//goblet contents
intersection
{
  sphere
  { <0,0,0>,1
    scale <1,2.5,1>
  }
  plane
  { y, 0
  }
  texture
  {
    finish {ambient .5}
    pigment //TODO eyes
    {
      #declare swirlrot = function(x,y,z) {(x*x+z*z)*clock};
      function { f_th(x,y,z)/6.28 + swirlrot(x,y,z) }
      color_map
      {
	[0 Black]
	[0.49999 Black]
	[0.50001 White]
	[1 White]
      }
      scale <-2.5,1,2.5>
    }
  }
}

#declare dot_size = .1*clock;
cone
{ <0,-.1,0>,0,<0,.001,0>,dot_size
  texture
  {
    finish {ambient .5}
    pigment
    { function { f_th(x,y,z)/6.28 + swirlrot(x,y,z) }
      color_map
      {
	[0 White]
	[1-clock*.999 Black]
	[1 Black]
      }
      rotate y*180
      rotate y*480*clock
      scale dot_size
    }
  }
  translate z*(1-dot_size)
  #if (clock > .8)
   translate z*-(clock-.8)
  #end
  rotate y*59*clock
}
cone
{ <0,-.1,0>,0,<0,.001,0>,dot_size
  texture
  {
    finish {ambient .5}
    pigment
    { function { f_th(x,y,z)/6.28 + swirlrot(x,y,z) }
      color_map
      {
	[0 Black]
	[1-clock*.999 White]
	[1 White]
      }
      rotate y*480*clock
      scale dot_size
    }
  }
  translate z*(-1+dot_size)
  #if (clock > .8)
   translate z*(clock-.8)
  #end
  rotate y*59*clock
}


#ifndef (DEBUG)
//goblet
merge
{
  torus { 1.02, .02 }
  difference
  {
    blob
    {
      threshold .27
      sphere { <0,0,0>, 1, 1 scale <1,2.5,1> scale 1.5 }
      cylinder { <0,-2.5,0>, <0,-5,0>, .3, 1 }
      sphere { <0,0,0>, 1, 1 scale <1,.1,1> scale 1.5 translate y*-5 }
    }
    sphere { <0,0,0>,1.001 scale <1,2.5,1> }
    plane  { -y, 0 }
  }
  material {M_Glass3}
  //the glass/border shrinks at each end of the scene
  #if (clock < .1)
   scale .96+clock*2/5
   translate y*-(.02-clock/5)
  #end
  #if (clock > .9)
   scale .96 + (1-clock)*2/5
   translate y*-(.02-(1-clock)/5)
  #end
}
#end

