/* planes.pov - yinyang with eyes  turns into a mountain with planes
Created:     2004.01.07.20.35
Last edited: 2004.01.08.19.15
By:          William de Beaumont
*/

/* TODO
fix peak in isosurface
fix visibility of plane tail fin on underside
*/

#include "colors.inc"
#include "functions.inc"

#macro circle2square(squareness)
  f_sphere(x,y,z,
    (
      1-squareness + 
      1/cos(
	(mod(abs(atan2(x,y))/.78535 + 1, 2) - 1) * .78535
      ) * squareness
    )
  )
#end

// note the change in orientation compared to previous scenes
#declare CAMPATH =
  spline
  { natural_spline
    -.25, <0,-.1,-2>,
    0.00, <0,-.1,-2>,
    0.35, <0,0,-1.5>,
    0.50, <0,0,-1>,
    0.75, <.1,-.1,-.5>,
    0.90, <.15,-.15,-.35>,
    1.00, <.2,-.2,-.2>,
    1.25, <.2,-.2,-.2>
  }

camera
{
  location CAMPATH(clock) //<0,-.2*clock,-2+1.8*clock*clock>
  look_at <0,0,0>
}

light_source {<-5*clock,5*clock,-5> color White}

#if (clock < .2)
plane
{ -z, -5
  texture
  {
    finish {ambient .5}
    pigment
    { checker White Black
      scale 2
    }
  }
}
#end

isosurface
{
#if (clock < .2)
  function {circle2square(pow(clock*5,2))}
  contained_by {box {<-1,-1,0>,<1,1,1>}}
  scale <1+clock*.33/.2,1,1>
#else
  function
  { -z + 
    (clock-.2) * (.1 * f_noise3d(x*8,y*8,0) +
		  .2-.2*pow( sin(f_th(x,z,y) +
				 6.28*(pow(x/(-2.5-2*clock),2) + 
				       pow(y/(2.5+2*clock),2)
				      )
				),3
			   ) +
                  select(f_r(x,y,z) - .1, .1 - f_r(x,y,z), 0)
		 )
  }
//  contained_by {box {<-1.33,-1,0>,<1.33,1,1>}}
  contained_by {box {<-10,-10,0>,<10,10,10>}}
  max_gradient 1.2 + 144*pow(clock,4)
#end
  
  texture
  {
    finish {ambient .5 phong clock phong_size 240-clock*200}
    pigment
    {
      function { f_th(x,z,y)/6.28 + (x*x+y*y) }
      color_map
      {
	[0 Black]
	[0.49999 Black]
	[0.50001 White]
	[1 White]
      }
      scale <-2.5-2*clock,2.5+2*clock,1>
    }
  }
//  pigment {gradient z color_map {[0 Red] [1 Blue]}}
}

#if (clock < .2)
  #declare clk = 0;
#else
  #if (clock < .8)
    #declare clk = (clock-.2)/.6;
  #else
    #declare clk = 1;
  #end
#end

#if (clock < .2)
sphere
{ <0,0,0>,.1
  scale <1,1,clock*5+.001>
#else
intersection
{
  blob
  { threshold .2
    sphere {<0,0,0>,1.35,1 + clk scale <1-.8*clk,1-.8*clk,1 - .1*clk>}
    cylinder
    {<0,0,.15>,<1,0,-.15>,.3 + .3*(1-clk),1 + clk scale <1,1-.8*clk,1>}
    cylinder
    {<0,0,.15>,<-1,0,-.15>,.3 + .3*(1-clk),1 + clk scale <1,1-.8*clk,1>}
    sphere {<0,0,-1.2>,.6 + (1-clk),1 + clk scale <1,.15,1>}
    sphere {<0,0,-1.2>,.6 + (1-clk),1 + clk scale <.15,1,1>}
  }
  sphere{<0,0,0>,1}
  scale .1
  rotate y*180
  rotate x*-90
#end
  translate z*-.001
  translate y*.1
  translate y*.6*(1-clock)
  rotate z*-59
  texture
  {
    finish {ambient .5 phong 1}
    pigment {color Black}
  }
}

#if (clock < .2)
sphere
{ <0,0,0>,.1
  scale <1,1,clock*5+.001>
#else
intersection
{
  blob
  { threshold .2
    sphere {<0,0,0>,1.35,1 + clk scale <1-.8*clk,1-.8*clk,1 - .1*clk>}
    cylinder
    {<0,0,.15>,<1,0,-.15>,.3 + .3*(1-clk),1 + clk scale <1,1-.8*clk,1>}
    cylinder
    {<0,0,.15>,<-1,0,-.15>,.3 + .3*(1-clk),1 + clk scale <1,1-.8*clk,1>}
    sphere {<0,0,-1.2>,.6 + (1-clk),1 + clk scale <1,.15,1>}
    sphere {<0,0,-1.2>,.6 + (1-clk),1 + clk scale <.15,1,1>}
  }
  sphere{<0,0,0>,1}
  scale .1
  rotate x*-90
#end
  translate z*-.001
  translate y*-.1
  translate y*.6*-(1-clock)
  rotate z*-59
  texture
  {
    finish {ambient .5 phong 1}
    pigment {color White}
  }
}

