// 2004 - Gene Wadleigh
#declare upperArmLength = 20.0;
#declare forearmLength = 20.0;
#declare forearmSmallRadius = 0.5;
#declare forearmLargeRadius = 1.5;
#declare forearmRotation = 120*cos(40*clock*2*pi);
#declare wristRotation   = 30 + 30*sin(clock*2*pi);

#macro forearm ( _forearmLength , _forearmSmallRadius , _forearmLargeRadius , _forearmRotation)
union
{
	cone {0,_forearmLargeRadius,<0.5,_forearmLength,0>,_forearmSmallRadius}
	cone {0,_forearmLargeRadius,<0.0,_forearmLength,0>,_forearmSmallRadius}
	rotate _forearmRotation*y
}
#end
#macro thumb (_rotation)
union
{
	sphere {0,1 scale <0.2,0.7,0.3> translate .5*y rotate _rotation*x translate y}
	sphere {0,1 scale <0.5,1,0.3> }
	translate y
}
#end
#declare fingerSegment = sphere {0,1 translate y scale <0.2,0.4,0.2> }
#macro finger (_firstJointFromTipRotation,_secondJointFromTipRotation,_thirdJointFromTipRotation)
union
{
	union
	{
		union
		{
			object { fingerSegment rotate _firstJointFromTipRotation*x scale 0.7 translate 0.5*y }
			object { fingerSegment scale 0.8 }
			rotate _secondJointFromTipRotation*x
			translate 0.5*y
		}
		object { fingerSegment scale 0.9}
		rotate _thirdJointFromTipRotation*x
		translate 2.2*y
	}
	object { fingerSegment scale <1,3,1> }
}
#end
#macro rightHand (_forearmRotation,_curl)
union
{
	object {finger(_curl,_curl,_curl) scale 1.2 rotate  10*z}
	object {finger(_curl,_curl,_curl) scale 1.3 rotate   5*z}
	object {finger(_curl,_curl,_curl) scale 1.2 rotate   0*z}
	object {finger(_curl,_curl,_curl) scale 1.1 rotate  -5*z}

	object {thumb(_curl) rotate 30*z}
	rotate _forearmRotation*y
	translate -1*y
}
#end
#macro leftHand (_forearmRotation,_curl)
union
{
	object {finger(_curl,_curl,_curl) scale 1.2 rotate  10*z}
	object {finger(_curl,_curl,_curl) scale 1.3 rotate   5*z}
	object {finger(_curl,_curl,_curl) scale 1.2 rotate   0*z}
	object {finger(_curl,_curl,_curl) scale 1.1 rotate  -5*z}

	object {thumb(_curl) rotate -30*z}
	rotate _forearmRotation*y
	translate -1*y
}
#end
#declare rightArm =
union
{
	union
	{
		object { rightHand(forearmRotation,wristRotation) scale 2 rotate wristRotation*x translate forearmLength*y }
		object { forearm ( forearmLength , forearmSmallRadius , forearmLargeRadius , forearmRotation) }
		rotate -90*abs(sin(300*pi*clock))*x
		translate (upperArmLength)*y
	}
	sphere {0,forearmLargeRadius}
	cylinder {0,upperArmLength*y,forearmLargeRadius}
	sphere {0,forearmLargeRadius translate upperArmLength*y}
}
#declare leftArm =
union
{
	union
	{
		object { leftHand(forearmRotation,wristRotation) scale 2 rotate wristRotation*x translate forearmLength*y }
		object { forearm ( forearmLength , forearmSmallRadius , forearmLargeRadius , forearmRotation) }
		rotate -90*abs(sin(300*pi*clock))*x
		translate (upperArmLength)*y
	}
	sphere {0,forearmLargeRadius}
	cylinder {0,upperArmLength*y,forearmLargeRadius}
	sphere {0,forearmLargeRadius translate upperArmLength*y}
}
#declare arms =
union
{
	object { leftArm  translate -5*x rotate (90-90*sin(20*pi*clock))*x} 
	object { rightArm translate  5*x rotate (90-90*sin(20*pi*clock))*x} 
}
#declare rightArmHoldingHandleBar =
union
{
	union
	{
		object { rightHand(60,40) scale 4 translate forearmLength*y }
		object { forearm ( forearmLength , forearmSmallRadius , forearmLargeRadius , 0) }
		translate (upperArmLength)*y
	}
	sphere {0,forearmLargeRadius}
	cylinder {0,upperArmLength*y,forearmLargeRadius}
	sphere {0,forearmLargeRadius translate upperArmLength*y}
}
#declare leftArmHoldingHandleBar =
union
{
	union
	{
		object { leftHand(60,40) scale 4 translate forearmLength*y }
		object { forearm ( forearmLength , forearmSmallRadius , forearmLargeRadius , 0) }
		translate (upperArmLength)*y
	}
	sphere {0,forearmLargeRadius}
	cylinder {0,upperArmLength*y,forearmLargeRadius}
	sphere {0,forearmLargeRadius translate upperArmLength*y}
}
#declare armsHoldingHandleBars =
union
{
	object {leftArmHoldingHandleBar  rotate -90*y rotate 90*x rotate -10*y translate -4*x}
	object {rightArmHoldingHandleBar rotate -90*y rotate 90*x rotate  10*y translate  4*x}
}
