// Persistence of Vision Ray Tracer Scene Description File
// File: desert_showoff.pov
// Vers: 3.5
// Desc: Desert Backdrop with sky/clouds 
// Date: 11.09.04 (dd.mm.yy)
// Auth: Tim Nikias Wenclawiak
// Last Update: 14.10.04 (dd.mm.yy)

//Description
// A small showoff of the desert-background

/* Commandline
+W1280 +H640 +AM2 +A0.3 +R2
*/

//Homepage:
// www.nolights.de
//Email:
// LOWERCASEONLYtimISNTnikias[AT]gmx.netWARE

#default{finish{ambient 0}}

global_settings{
  assumed_gamma 1
  max_trace_level 35
  ambient_light 0
  photons{
    spacing .005
    autostop .5
  }
}

#declare Desert_HFDetail = 250;
#declare Desert_BaseColor = <.7,.3,.1>;
#declare Desert_UseDetailTex = 0;
#declare Desert_UseSun = on;
#declare Desert_SunPos = <500,500,300>;
#declare Desert_SunArealights = 25;
#declare Desert_SunColor = <1,1,1>;
#declare Desert_SunSizeMultiplier = 5;

#declare Desert_Clouds = on;
#declare Desert_CloudPercentage = 50;
#declare Desert_CloudTransform = transform{translate <0,2,0> scale <1,1,1>};
#declare Desert_CloudShadow = off;

#include "bkdrp_desert.inc"
Create_Backdrop()

camera{
  location <0,1,-5>
  up <0,1,0>
  right <2,0,0>
  look_at <0,1,0>
  rotate y*360*clock
}

#declare Test_Object=
union{
  sphere{0,.5 scale <1,2,1> translate y}
  torus{.75,.125 translate y*.25}
}

//Test-Object #1: Reflective
object{Test_Object
  pigment{rgb .15}
  finish{
    specular .6 roughness .01
    brilliance 6
    reflection{.5,1 falloff 2}
  }
  translate <-1.5,0,0>
}
//Test-Object #2: Glass
object{Test_Object
  pigment{rgbt 1}
  interior{
    ior 1.45
    fade_power 2 fade_distance 1
  }
  finish{
    specular 1 roughness .001
    brilliance 4
    reflection{0,1 fresnel}
  }
  translate <1.5,0,0>
  photons{target refraction on reflection on}
}
