// Persistence of Vision Ray Tracer Scene Description File
// File: custom.inc
// Vers: 3.5
// Desc: Modified versions of other macros
// Date: 22.09.04 (dd.mm.yy)
// Auth: Tim Nikias Wenclawiak
// Last Update: 14.10.04 (dd.mm.yy)

//Required Files

//Description

//Homepage:
// www.nolights.de
//Email:
// LOWERCASEONLYtimISNTnikias[AT]gmx.netWARE

#ifndef (_bsplines_inc_tnw) #include "bsplines.inc" #end

//This macro gets added almost all the time... I wonder why... :)
/****  VNormalize()  ****/
#macro VNormalize(_Vec)
 //Create proper return-value
 #if (vlength(_Vec))
  #local _Ret=vnormalize(_Vec); #else
  #local _Ret=<0,0,0>; #end
 //Return:
 _Ret
#end
//Creates a 4D-Vector out of 3D
#macro V4(_3comp)
 <_3comp.x,_3comp.y,_3comp.z,0>
#end

//==========================================
//Modified Macros from my Glare-Include-File
//==========================================
#ifndef (Camera_Location)     #declare Camera_Location = <0,0,-1>; #end
#ifndef (Camera_Look_At)      #declare Camera_Look_At = <0,0,0>; #end
#ifndef (Camera_Sky)          #declare Camera_Sky = <0,1,0>; #end
#ifndef (Camera_Aspect_Ratio) #declare Camera_Aspect_Ratio = <image_width/image_height,1,1>; #end

//Unmodified copies from "glare.inc"
#macro Glare_Transform(_Pos)
 #local Cam_D = VNormalize(Camera_Look_At-Camera_Location);
 #local Cam_X = VNormalize(vcross(VNormalize(Camera_Sky),Cam_D));
 #local Cam_Y = -VNormalize(vcross(Cam_X,Cam_D));
 #declare Cam_Matrix =
  transform{matrix
   <Cam_X.x, Cam_X.y, Cam_X.z,
    Cam_Y.x, Cam_Y.y, Cam_Y.z,
    Cam_D.x, Cam_D.y, Cam_D.z,
    0,       0,       0>
   };
 #local _F=function{transform{Cam_Matrix}}
 #local Ret=_F(_Pos.x*Camera_Aspect_Ratio.x*_Pos.z,_Pos.y*Camera_Aspect_Ratio.y*_Pos.z,_Pos.z)+Camera_Location;
 Ret
#end

#macro Glare_PlaceImage(_Pigment,_DistanceToCamera)
 #local _UL=Glare_Transform(<-.5, .5,_DistanceToCamera>);
 #local _LL=Glare_Transform(<-.5,-.5,_DistanceToCamera>);
 #local _UR=Glare_Transform(< .5, .5,_DistanceToCamera>);
 #local _LR=Glare_Transform(< .5,-.5,_DistanceToCamera>);
 mesh{
  triangle{_UL,_LL,_UR uv_vectors <0,1>,<0,0>,<1,1>}
  triangle{_UR,_LR,_LL uv_vectors <1,1>,<1,0>,<0,0>}
  texture{uv_mapping _Pigment}
  hollow
  no_shadow no_reflection
  photons{refraction off reflection off collect off pass_through}
  }
#end

//Camera()
// Camera-Statement which uses all set declarations
#macro Camera()
  camera{
    location Camera_Location
    right Camera_Aspect_Ratio*<1,0,0>
    up Camera_Aspect_Ratio*<0,1,0>
    sky Camera_Sky
    look_at Camera_Look_At
  }
#end

//Modified Glare_Layer-Macro with added transparency-capabilities and diffuse/ambient switch
//Text_Layer
//Parameters:
// 1. Pigment with default image-map (<0,0,0> to <1,1,0>)
// 2. POV-Units distance of Layer to camera
// 3. <Exponent for color-map, Ambient brightness, transparency>
// 4. true=ambient, false=diffuse
//Returns:
// 1. Specularity layer in front of camera
#macro Text_Layer(_ImagePigment,_DistanceToCamera,_ExpBright,_Light)
  #local _I=function{pigment{_ImagePigment}}
  #local _Image=
    texture{
      pigment{function{_I(x,y,z).gray} color_map{[0 rgbt <1,1,1,1>][1 rgbt <1,1,1,_ExpBright.z>]} poly_wave _ExpBright.x}
      #if (_Light)
        finish{ambient _ExpBright.y diffuse 0}
      #else
        finish{ambient 0 diffuse _ExpBright.y}
      #end
      }
  Glare_PlaceImage(_Image,_DistanceToCamera)
#end

//Modified Glare_Layer-Macro with added transparency-capabilities and diffuse/ambient switch
//Radar_Layer
//Parameters:
// 1. Pigment with default image-map (<0,0,0> to <1,1,0>)
// 2. POV-Units distance of Layer to camera
// 3. <Exponent for color-map, Ambient brightness, transparency>
// 4. true=ambient, false=diffuse
//Returns:
// 1. Specularity layer in front of camera
#macro Radar_Layer(_ImagePigment,_DistanceToCamera,_ExpBright,_Light)
  #local _I=function{pigment{_ImagePigment}}
  #local _Image=
    texture{
      pigment{function{_I(x,y,z).gray} color_map{[0 rgbt <0,1,0,1>][1 rgbt <0,1,0,_ExpBright.z>]} poly_wave _ExpBright.x}
      #if (_Light)
        finish{ambient _ExpBright.y diffuse 0}
      #else
        finish{ambient 0 diffuse _ExpBright.y}
      #end
      }
  Glare_PlaceImage(_Image,_DistanceToCamera)
#end


//=================================
//Macro for subtle hovering effects
//=================================

//Excerpt from "bsplines.inc"
#macro Linear_Pos(_Linear_Array,_LI_Mover)
 #local _Linear_Sections = dimension_size(_Linear_Array,1)-1;
 #if (_LI_Mover > 1) #local _LI_Mover=1; #end
 #if (_LI_Mover < 0) #local _LI_Mover=0; #end
 #if (_LI_Mover = 0)
  #local _Linear_Pos_ = V3(_Linear_Array[0]);
 #end
 #if (_LI_Mover = 1)
  #local _Linear_Pos_ = V3(_Linear_Array[_Linear_Sections]);
 #end
 #if (_LI_Mover > 0 & _LI_Mover < 1)
  #local _Actual = floor(_LI_Mover*_Linear_Sections);
  #local _Next = floor(_LI_Mover*_Linear_Sections)+1;
  #local _Time = _LI_Mover*(_Linear_Sections)-_Actual;
  #local _Linear_Pos_ = V3(_Linear_Array[_Actual]+(_Linear_Array[_Next]-_Linear_Array[_Actual])*_Time);
 #end
_Linear_Pos_
#end

//Returns translation vector to be applied to hovering object
#macro Hover(_Radius,_Positions,_Seed)
  #local _R=seed(_Seed);
  #local _Array=array[_Positions];
  #local _A=0;
  #while (_A<_Positions)
    #local _Array[_A]=vnormalize(<rand(_R),rand(_R),rand(_R)>*2-1)*_Radius;
    #local _A=_A+1;
  #end 
  #local _Return = Linear_Pos(_Array,clock);
  _Return
#end


//=======================
//Macro for Shake-Effects
//=======================
#macro _ShakePos(_Seed)
  #local _R=seed(_Seed);
  #declare _Seed=rand(_R)*10000;
  #local _Return = vnormalize(<rand(_R),rand(_R),rand(_R)>*2-1)*(.5+.5*sqrt(rand(_R)))*_ShRadius;
  _Return
#end

#macro Create_Shake(_ShNodes,_ShRadius,_ShSeed,_File,_LinearName)
  #ifndef (_Shake_DirLength)
    #local _Shake_DirLength=0;
  #end
  #ifndef (Override_Shake)
    #local Override_Shake=0;
  #end
  #if ((frame_number = 1 & !Override_Shake) | !file_exists(_File))
    #local Shake_BSpline = array[_ShNodes*2];
    #local Shake_BSpline[1]=<0,0,0,0>;
    #local Shake_BSpline[_ShNodes*2-1]=<0,0,0,0>;
    #local A=0;
    #while (A<=_ShNodes*2-2)
      #if (A<_ShNodes*2)
        #local Shake_BSpline[A] = V4(_ShakePos(_ShSeed));
      #end
      #if (A>=4)
        #local _Dir1 = Shake_BSpline[A-2]-Shake_BSpline[A-4];
        #local _Dir2 = Shake_BSpline[ A ]-Shake_BSpline[A-2];
        #if (_Shake_DirLength=0)
          #local _Mid = (_Dir1+_Dir2)/2;
        #else
          #local _Mid = vnormalize(V3(_Dir1+_Dir2))*_Shake_DirLength;
        #end
        #local Shake_BSpline[A-3] = V4(_Mid);
      #end
      #local A=A+2;
    #end

    #local _Dir1 = Shake_BSpline[A-4]-Shake_BSpline[A-6];
    #local _Dir2 = Shake_BSpline[A-2]-Shake_BSpline[A-4];
    #if (_Shake_DirLength=0)
      #local _Mid = (_Dir1+_Dir2)/2;
    #else
      #local _Mid = vnormalize(V3(_Dir1+_Dir2))*_Shake_DirLength;
    #end
    #local Shake_BSpline[A-3] = V4(_Mid);
    BSpline2Linear_Ext(Shake_BSpline,final_frame*200,final_frame,_File,"Shake_BSpline",_LinearName)
  #end
  #include _File
#end

//=========================================
//Macros from my IO-Macro-Set "io_macs.inc"
//=========================================
//Saving single vectors
#macro Save_Value(_val,_filename)
 #fopen _O _filename write
  #write (_O, _val)
 #fclose _O
#end
//Loading single vectors
#macro Load_Value(_filename)
 #if (file_exists(_filename))
  #fopen _O _filename read
   #read (_O, _val)
  #fclose _O
 #else
  #warning concat("Warning issued by Load_Value-Macro: Loading file ",_filename," failed, file not found!\n")
  #local _val=0;
 #end
 _val
#end
//Loading arrays
#macro Load_Array(_filename)
 #if (file_exists(_filename))
  #fopen _O _filename read
   #read (_O, _d)
   #local _dd=array[_d]
   #local A=0;
   #while (A<_d)  
    #read (_O, _a)
    #local _dd[A]=_a;
    #undef _a
   #local A=A+1;
   #end
   #if (_d=1)
    #local _array=array[_dd[0]]
    #local A=0; #while (A<_dd[0])
     #read (_O, _a)
     #local _array[A]=_a;
     #undef _a
    #local A=A+1; #end  
   #end
   #if (_d=2)
    #local _array=array[_dd[0]][_dd[1]]
    #local A=0; #while (A<_dd[0])
     #local B=0; #while (B<_dd[1])
      #read (_O, _a)
      #local _array[A][B]=_a;
      #undef _a
     #local B=B+1; #end  
    #local A=A+1; #end  
   #end
   #if (_d=3)
    #local _array=array[_dd[0]][_dd[1]][_dd[2]]
    #local A=0; #while (A<_dd[0])
     #local B=0; #while (B<_dd[1])
      #local C=0; #while (C<_dd[2])
       #read (_O, _a)
       #local _array[A][B][C]=_a;
       #undef _a
      #local C=C+1; #end  
     #local B=B+1; #end  
    #local A=A+1; #end  
   #end
   #if (_d=4)
    #local _array=array[_dd[0]][_dd[1]][_dd[2]][_dd[3]]
    #local A=0; #while (A<_dd[0])
     #local B=0; #while (B<_dd[1])
      #local C=0; #while (C<_dd[2])
       #local D=0; #while (D<_dd[3])
        #read (_O, _a)
        #local _array[A][B][C][D]=_a;
        #undef _a
       #local D=D+1; #end  
      #local C=C+1; #end  
     #local B=B+1; #end  
    #local A=A+1; #end  
   #end
   #if (_d=5)
    #local _array=array[_dd[0]][_dd[1]][_dd[2]][_dd[3]][_dd[4]]
    #local A=0; #while (A<_dd[0])
     #local B=0; #while (B<_dd[1])
      #local C=0; #while (C<_dd[2])
       #local D=0; #while (D<_dd[3])
        #local E=0; #while (E<_dd[4])
         #read (_O, _a)
         #local _array[A][B][D][E]=_a;
         #undef _a
        #local E=E+1; #end  
       #local D=D+1; #end  
      #local C=C+1; #end  
     #local B=B+1; #end  
    #local A=A+1; #end  
   #end
  #fclose _O
 #else
  #warning concat("Warning issued by Load_Array-Macro: Loading file ",_filename," failed, file not found!\n")
  #local _array=array[2] {0,0}
 #end
 _array
#end

