// Persistence of Vision Ray Tracer Scene Description File
// File: io_macs.pov
// Vers: 3.5
// Desc: Some handy macros for i-o with values
// Date: 27.04.02 (dd.mm.yy)
// Auth: Tim Nikias Wenclawiak
// Last Update: 26.03.03 (dd.mm.yy)

/*Example Usage

To save one value, simply use Save_Value like the following:

  #declare A_Vector=<2,3,4>;
  Save_Value(A_Vector,"avec.dat")

To load that value, use Load_Value:

  #declare The_Loaded_Vector=Load_Value("avec.dat")

The same applies to array:

  #declare Some_Array=array[2][2] { {1,2},{3,4} }
  Save_Array(Some_Array,"array.dat")

  #declare Loaded_Array=Load_Array("array.dat")

With these macros, File I/O is a child's game!

If you use these macros, just do me two favors:
1. Mention me somewhere in the credits
2. For any major image/animation/whatever, let me know and see!

If loading fails because you're attempting to load non-existant
files, the macros will issue a warning and load default
values (0 for Load_Value, Array is array[2] {0,0}). If you're
loading files which haven't been created with the IO-Macros, you're
on you're own if the macros don't work properly. Nontheless, if
you need help, below is my email-address.

Homepage:
 www.digitaltwilight.de/no_lights
Email:
 Tim.Nikias@gmx.de
*/

//If you're using other includes of mine, its best
//to keep the following line:
#declare _io_macs_inc_tnw=1;

//My include files check each other, in case macros are needed
//which are defined in other includes. E.g., if some include-file
//would need this file, it'd check if _io_macs_inc_tnw is
//defined. If its not, this file wasn't included before, thus
//its included when needed.
//Doesn't hinder Users to include this file more than once though, or
//after including the file which includes this file...

/**************/
/**Save_Value**/
/**************/
//Give: 1. Value (vector/float/boolean)
//      2. filename-string
//Result: Value is saved to file, loadable with Load_Value
#macro Save_Value(_val,_filename)
 #fopen _O _filename write
  #write (_O, _val)
 #fclose _O
#end

/**************/
/**Load_Value**/
/**************/
//Give: filename
//Return: vector/float for declaration
#macro Load_Value(_filename)
 #if (file_exists(_filename))
  #fopen _O _filename read
   #read (_O, _val)
  #fclose _O
 #else
  #warning concat("Warning issued by Load_Value-Macro: Loading file ",_filename," failed, file not found!\n")
  #local _val=0;
 #end
 _val
#end

/**************/
/**Save_Array**/
/**************/
//Give: 1. array (up to 5 dimensions), filled with vectors/floats/boolean
//      2. filename-string
//Result: Array saved to filename, loadable with Load_Array

//Notes:
//-Saves dimensions as first value, then the depths for each dimension
//-Then, determined by the dimensions, the different loop-sequences
// are called, and, beginning from last dimension, first index,
// moves until first dimension, last index
//-Every 10 saved values, a "\n" is added to keep things in order in
// the file (may be changed by setting _max to something different)
#macro Save_Array(_array,_filename)
 #local _max=10; //Values per line
 #fopen _O _filename write
  #local _d=dimensions(_array);
  #write (_O, _d) //Save dimensions
  #local _dd=array[_d] //Dimension-Depths

  #local A=0;
  #while (A<_d)  
   #local _dd[A]=dimension_size(_array,A+1);
   #write (_O, ",",_dd[A]) //Save dimension-depths
  #local A=A+1;
  #end
  
  #write (_O, "\n")
  #local _m=1; //value-counter initiates with 1, of course

  #if (_d=1)
   #local B=0; #while (B<_dd[0])
    #write (_O, ",",_array[B])
    //Keeps track of values per line and adds "return" if needed
    #if (_m=_max) #write (_O, "\n") #local _m=0; #end #local _m=_m+1;
   #local B=B+1; #end  
  #end

  #if (_d=2)
   #local A=0; #while (A<_dd[0])
    #local B=0; #while (B<_dd[1])
     #write (_O, ",",_array[A][B])
     //Keeps track of values per line and adds "return" if needed
     #if (_m=_max) #write (_O, "\n") #local _m=0; #end #local _m=_m+1;
    #local B=B+1; #end  
   #local A=A+1; #end  
  #end

  #if (_d=3)
   #local A=0; #while (A<_dd[0])
    #local B=0; #while (B<_dd[1])
     #local C=0; #while (C<_dd[2])
      #write (_O, ",",_array[A][B][C])
      //Keeps track of values per line and adds "return" if needed
      #if (_m=_max) #write (_O, "\n") #local _m=0; #end #local _m=_m+1;
     #local C=C+1; #end  
    #local B=B+1; #end  
   #local A=A+1; #end  
  #end
  
  #if (_d=4)
   #local A=0; #while (A<_dd[0])
    #local B=0; #while (B<_dd[1])
     #local C=0; #while (C<_dd[2])
      #local D=0; #while (D<_dd[3])
       #write (_O, ",",_array[A][B][C][D])
       //Keeps track of values per line and adds "return" if needed
       #if (_m=_max) #write (_O, "\n") #local _m=0; #end #local _m=_m+1;
      #local D=D+1; #end  
     #local C=C+1; #end  
    #local B=B+1; #end  
   #local A=A+1; #end  
  #end

  #if (_d=5)
   #local A=0; #while (A<_dd[0])
    #local B=0; #while (B<_dd[1])
     #local C=0; #while (C<_dd[2])
      #local D=0; #while (D<_dd[3])
       #local E=0; #while (E<_dd[4])
        #write (_O, ",",_array[A][B][C][D][E])
        //Keeps track of values per line and adds "return" if needed
        #if (_m=_max) #write (_O, "\n") #local _m=0; #end #local _m=_m+1;
       #local E=E+1; #end  
      #local D=D+1; #end  
     #local C=C+1; #end  
    #local B=B+1; #end  
   #local A=A+1; #end  
  #end

 #fclose _O

#end

/**************/
/**Load_Array**/
/**************/
//Give: filename-string
//Result: Array loaded from filename
#macro Load_Array(_filename)
 #if (file_exists(_filename))
  #fopen _O _filename read
   #read (_O, _d)
   #local _dd=array[_d] //Dimension-Depths
 
   //Read-In dimension-depths
   #local A=0;
   #while (A<_d)  
    #read (_O, _a)
    #local _dd[A]=_a;
    #undef _a
   #local A=A+1;
   #end
 
   #if (_d=1)
    #local _array=array[_dd[0]]
    #local A=0; #while (A<_dd[0])
     #read (_O, _a)
     #local _array[A]=_a;
     #undef _a
    #local A=A+1; #end  
   #end
 
   #if (_d=2)
    #local _array=array[_dd[0]][_dd[1]]
    #local A=0; #while (A<_dd[0])
     #local B=0; #while (B<_dd[1])
      #read (_O, _a)
      #local _array[A][B]=_a;
      #undef _a
     #local B=B+1; #end  
    #local A=A+1; #end  
   #end
 
   #if (_d=3)
    #local _array=array[_dd[0]][_dd[1]][_dd[2]]
    #local A=0; #while (A<_dd[0])
     #local B=0; #while (B<_dd[1])
      #local C=0; #while (C<_dd[2])
       #read (_O, _a)
       #local _array[A][B][C]=_a;
       #undef _a
      #local C=C+1; #end  
     #local B=B+1; #end  
    #local A=A+1; #end  
   #end
 
   #if (_d=4)
    #local _array=array[_dd[0]][_dd[1]][_dd[2]][_dd[3]]
    #local A=0; #while (A<_dd[0])
     #local B=0; #while (B<_dd[1])
      #local C=0; #while (C<_dd[2])
       #local D=0; #while (D<_dd[3])
        #read (_O, _a)
        #local _array[A][B][C][D]=_a;
        #undef _a
       #local D=D+1; #end  
      #local C=C+1; #end  
     #local B=B+1; #end  
    #local A=A+1; #end  
   #end
 
   #if (_d=5)
    #local _array=array[_dd[0]][_dd[1]][_dd[2]][_dd[3]][_dd[4]]
    #local A=0; #while (A<_dd[0])
     #local B=0; #while (B<_dd[1])
      #local C=0; #while (C<_dd[2])
       #local D=0; #while (D<_dd[3])
        #local E=0; #while (E<_dd[4])
         #read (_O, _a)
         #local _array[A][B][D][E]=_a;
         #undef _a
        #local E=E+1; #end  
       #local D=D+1; #end  
      #local C=C+1; #end  
     #local B=B+1; #end  
    #local A=A+1; #end  
   #end
   
  #fclose _O
  
 #else
  #warning concat("Warning issued by Load_Array-Macro: Loading file ",_filename," failed, file not found!\n")
  #local _array=array[2] {0,0}
 #end
 //Return the array
 _array

#end