// Persistence of Vision Ray Tracer Scene Description File
// File: mesh_gen.pov
// Vers: 3.6.1
// Desc: Creates all Meshes required for Duel-Entry 
// Date: 10.10.04 (dd.mm.yy)
// Auth: Tim Nikias Wenclawiak
// Last Update: 14.10.04 (dd.mm.yy)

/*Commandline
+W100 +H100
*/

//Homepage:
// www.nolights.de
//Email:
// LOWERCASEONLYtimISNTnikias[AT]gmx.netWARE

#include "mmm.inc"
#include "io_macs.inc"

#include "jet_mesh.inc"
#include "ufo_mesh.inc"

//Crater for final Impact of UFO
//==============================
#debug "\nCalculating Crater-Meshes...\n"
#declare Crater_Detail = <150,150>;
#declare Crater_Mesh=array[Crater_Detail.u][Crater_Detail.v]

#declare Crater_LowDetail = <20,20>;
#declare Crater_LowMesh=array[Crater_LowDetail.u][Crater_LowDetail.v]

#declare Crater_Size = <50,50>;
#declare Crater_Pigment =
  pigment{
    spherical
    color_map{[0 rgb 0][.5 rgb 0][.9 rgb 1][1 rgb 1]}
    poly_wave .5
    turbulence .1 omega .4 lambda 2.8 octaves 8
    scale 20
  }
#declare Crater_Function = function{pigment{Crater_Pigment}}

#declare CraterRim_Pigment =
  pigment{
    spherical
    color_map{[0 rgb 0][.05 rgb 1][1 rgb 0]}
    poly_wave 2
    turbulence .1 omega .4 lambda 2.8 octaves 8
    scale 20
  }
#declare CraterRim_Function = function{pigment{CraterRim_Pigment}}

#declare Noise_Pigment =
  pigment{
    bozo color_map{[0 rgb 0][1 rgb 1]}
    scale .2
    warp{black_hole <0,0,0>,1.5 falloff 4 strength 2}
  }
#declare None = pigment{rgb 0}
#declare NoiseSP_Pigment =
  pigment{
    spherical
    pigment_map{[0 None][.3 Noise_Pigment][1 Noise_Pigment]}
    scale 17
  }
#declare Debris_Function = function{pigment{NoiseSP_Pigment}}

#declare A=0;
#while (A<Crater_Detail.u)
  #declare B=0;
  #while (B<Crater_Detail.v)
    #declare _Cur=x*Crater_Size.u*A/(Crater_Detail.u-1);
    #declare _Cur=_Cur+z*Crater_Size.v*B/(Crater_Detail.v-1);
    #declare _Cur=_Cur+<Crater_Size.u,0,Crater_Size.v>*-.5;
    #declare _Cx=_Cur.x;
    #declare _Cy=_Cur.y;
    #declare _Cz=_Cur.z;
    
    #declare _Cur=_Cur-9*y*Crater_Function(_Cx,_Cy,_Cz).gray;
    #declare _Cur=_Cur+y*CraterRim_Function(_Cx,_Cy,_Cz).gray;
    #declare _Cur=_Cur+3*y*Debris_Function(_Cx,_Cy,_Cz).gray;
    
    #declare Crater_Mesh[A][B] = _Cur;

    #declare B=B+1;
  #end
  #declare A=A+1;
#end

#declare A=0;
#while (A<Crater_LowDetail.u)
  #declare B=0;
  #while (B<Crater_LowDetail.v)
    #declare _Cur=x*Crater_Size.u*A/(Crater_LowDetail.u-1);
    #declare _Cur=_Cur+z*Crater_Size.v*B/(Crater_LowDetail.v-1);
    #declare _Cur=_Cur+<Crater_Size.u,0,Crater_Size.v>*-.5;
    #declare _Cx=_Cur.x;
    #declare _Cy=_Cur.y;
    #declare _Cz=_Cur.z;
    
    #declare _Cur=_Cur-9*y*Crater_Function(_Cx,_Cy,_Cz).gray;
    #declare _Cur=_Cur+y*CraterRim_Function(_Cx,_Cy,_Cz).gray;
    #declare _Cur=_Cur+2*y*Debris_Function(_Cx,_Cy,_Cz).gray;
    
    #declare Crater_LowMesh[A][B] = _Cur;

    #declare B=B+1;
  #end
  #declare A=A+1;
#end

#declare Crater_Normals = Make_Normals(Crater_Mesh)
#declare Crater_LowNormals = Make_Normals(Crater_LowMesh)

#debug "-Crater-Calculations finished...\n"
Write_Smooth_Mesh(Crater_Mesh,Crater_Normals,"crater.msh")
Write_Smooth_Mesh(Crater_LowMesh,Crater_LowNormals,"crater_l.msh")
#debug "Crater saved!\n"

// Points on crater to place smaller smoke-trails
//================================================
//Size adjusted with scale to fit the used scale in the movie
#declare Crater_Object = object{#include "crater.msh" scale 1.5}

#declare _R=seed(516);
#declare SmSmoke = array[25];
#declare A=0;
#while (A<25)
  #if (rand(_R)<.5)
    #declare _Start=vrotate(<rand(_R)*12+8,10,0>,y*(100+90*rand(_R)));
  #else
    #declare _Start=vrotate(<rand(_R)*12+8,10,0>,y*(270+60*rand(_R)));
  #end
  #declare _End = trace(Crater_Object,_Start,-y);
  #declare SmSmoke[A]=_End;
  
  #declare A=A+1;
#end
Save_Array(SmSmoke,"ufo/smoke.arr")

// Scene to show that its finished
global_settings{assumed_gamma 1 ambient_light 5}
camera{location <1,1,-10> look_at <1,1,0>}
union{
  sphere{x*-2,.25}
  cylinder{x*-2,y*-2,.25}
  sphere{y*-2,.25}
  cylinder{y*-2,<6,4,0>,.25}
  sphere{<6,4,0>,.25}
  pigment{rgb y}
}
