// Persistence of Vision Ray Tracer Scene Description File
// File: scene2_.pov
// Vers: 3.6.1
// Desc: Scene 2 of Duel-Entry : Rotating radar dish comes into view
// Date: 22.09.04 (dd.mm.yy)
// Auth: Tim Nikias Wenclawiak
// Last Update: 23.09.04 (dd.mm.yy)

//Description
// Scene 2 of Duel-Entry
// A short introduction on the desert, with heat-effect, pan to radar dish.

/*Commandline
+KFI1 +KFF200 +AM2 +A0.3 +R2
*/

//Homepage:
// www.nolights.de
//Email:
// LOWERCASEONLYtimISNTnikias[AT]gmx.netWARE

#declare Animation_Time = 8;
//Revolvements of Dish per second
#declare Dish_Speed = 180;

#default{finish{ambient 0}}
global_settings{
  assumed_gamma 1
  max_trace_level 25
}

#include "bkdrp_desert.inc"
#include "timers.inc"
#include "bsplines.inc"

//Backdrop-Setup
#declare Desert_HFDetail = 450;
#declare Desert_BaseColor = <.7,.3,.1>;
#declare Desert_UseDetailTex = false;
#declare Desert_UseSun = on;
#declare Desert_SunPos = <200,1200,-900>;
#declare Desert_SunArealights = 25;
#declare Desert_SunColor = 1;
#declare Desert_SunSizeMultiplier=1;

#declare Desert_Clouds = on;
#declare Desert_CloudTransform = transform{translate x*.01*clock*Animation_Time}
#declare Desert_CloudPercentage = 40;
#declare Desert_CloudShadow = off;

#declare Desert_ObjectScale = 4;

//Calls Macro to create Desert-Background
Create_Backdrop()
//Three point lighting to simulate ground-reflected/ambient light
light_source{<-1,1,-1>*Desert_SunPos rgb <.2,.2,.4> shadowless}
light_source{<-1,-1,1>*Desert_SunPos rgb Desert_BaseColor*.2 shadowless}

// Camera
//========
#declare Camera_Clock = Clock_Cubic(2,3);
#declare Camera_Location = <-4,8,-25>;

#declare Camera_Look_At = vrotate(<0,-4*Camera_Clock,25>,y*(142-122*Camera_Clock))+Camera_Location;

camera{
  location Camera_Location
  look_at Camera_Look_At
}

// Heathaze
//==========
#declare Heat_Distance = 30;
#declare Heat_Height = 14;
#declare Heat_Scale = .02;
#declare Heat_Depth = .001;
#declare Heat_TrS = y*3;

#declare Black=normal{bumps 0}
#declare Bozo_1=normal{bozo Heat_Depth no_bump_scale translate Heat_TrS*clock*Animation_Time scale .5*<1,.75,1>*Heat_Scale}
#declare Bozo_2=normal{bozo Heat_Depth no_bump_scale translate Heat_TrS*clock*Animation_Time scale <1,.75,1>*Heat_Scale}

sphere{0,1
  hollow
  pigment{rgbt <0,0,0,1>}
  interior{ior 2}
  normal{
    gradient y
    normal_map{
      [0 Black]
      [.2*Heat_Height/Heat_Distance Bozo_1]
      [.4*Heat_Height/Heat_Distance Bozo_2]
      [.7*Heat_Height/Heat_Distance Bozo_2]
      [.98*Heat_Height/Heat_Distance Black]
      [1 Black]
    }
    translate -y*Camera_Location/Heat_Distance
  }
  scale Heat_Distance
  translate Camera_Location 
  no_shadow
  no_reflection
}

// Concrete-Base
//===============
box{<-7,-1,-7>,<7,3,7>
  pigment{
    bozo
    color_map{[0 rgb .8][1 rgb .7]}
    scale <.5,1,.5>
  }
}
//Various little boxes on front of concrete-base
box{<.5,2.2,-7.1><1.2,2.8,-7> pigment{rgb .1}}
box{<-6,2.7,-7.05>,<-5.2,2.1,-7> pigment{rgb x}}
box{<-5.9,2.6,-7.1>,<-5.3,2.2,-7> pigment{rgb 1.25}}
//Structure on top
union{
  box{<-.5,2,-6>,<5,3.6,-3.5>}
  sphere{0,1 scale <1,.4,1> translate <1,3.6,-4.5>}
  sphere{0,1 scale <1,.4,1> translate <3.5,3.6,-4.5>}
  pigment{rgb .7}
}

//Dish-Base on Block
union{
  cylinder{0,y*3.5,2.5}
  cylinder{0,y*3.75,2.25}
  torus{2.25,.25 translate y*3.5}
  pigment{rgb <.8,.8,.6>}
  finish{
    specular .8 roughness .02
    brilliance 2
  }
}

// Dish
//======
#declare WhiteMetal_Tex=
  texture{
    pigment{rgb .9}
    finish{
      diffuse 1.1
      specular .8 roughness .01
      brilliance 2
    }
  }

#macro Dish_Struts(_Scale,_Tr)
  #local _Amount = 6;
  #local _Array=array[_Amount][2];
  #local _A=0;
  #while (_A<_Amount)
    #local _Array[_A][0] = vrotate(x*sqrt(pow(_Scale,2)-pow(.5*_Scale,2))-y*_Scale*.5,y*360/_Amount*_A);
    #local _Array[_A][1] = vrotate(x*.65*_Scale-y*.9*_Scale,y*360/_Amount*_A);
    #local _A=_A+1;
  #end
  union{
    #local _A=0;
    #while (_A<_Amount)
      //Holding the dish
      sphere{_Array[_A][0],.22}
      cylinder{_Array[_A][0],_Array[_A][1],.2}
      sphere{_Array[_A][1],.22}
      cylinder{_Array[_A][1],<0,-1*_Scale-.25,0>,.2}
      //Circumferance
      cylinder{_Array[_A][1],_Array[mod(_A+1,_Amount)][1],.15}
      //Attachment to base
      cylinder{_Array[_A][1],-_Tr-y*.35,.2}
      #local _A=_A+1;
    #end
    //Base-Sphere
    sphere{<0,-1*_Scale-.25,0>,.265}
    //Dish-Rim
    torus{_Array[0][0].x-.15,.15 translate -y*_Scale*.5}
    
    //Receiver
    #local _A=0;
    #while (_A<_Amount)
      cylinder{_Array[_A][0],_Array[_A][0]+y*.5,.1}
      sphere{_Array[_A][0]+y*.5,.1}
      cylinder{_Array[_A][0]+y*.5,(_Array[_A][0]+3.5)*y,.1}
      #local _A=_A+2;
    #end
    sphere{(_Array[0][0]+3.5)*y,.15}
    cylinder{(_Array[0][0]+3.5)*y,(_Array[0][0]+2.9)*y,.125}
    //Counterweights
    cylinder{_Array[1][0],(_Array[1][0]+_Array[0][0])/2-y*_Tr*1.25,.2}
    cylinder{_Array[0][0],(_Array[1][0]+_Array[0][0])/2-y*_Tr*1.25,.2}
    cylinder{-_Tr,(_Array[1][0]+_Array[0][0])/2-y*_Tr*1.25,.2}
    
    cylinder{_Array[_Amount-1][0],(_Array[_Amount-1][0]+_Array[0][0])/2-y*_Tr*1.25,.2}
    cylinder{_Array[0][0],(_Array[_Amount-1][0]+_Array[0][0])/2-y*_Tr*1.25,.2}
    cylinder{-_Tr,(_Array[_Amount-1][0]+_Array[0][0])/2-y*_Tr*1.25,.2}
    //Black parts: Receiver and Weights
    union{
      cylinder{(_Array[0][0]+2.9)*y,(_Array[0][0]+2.3)*y,.3}
      sphere{(_Array[1][0]+_Array[0][0])/2-y*_Tr*1.25,.75}
      sphere{(_Array[_Amount-1][0]+_Array[0][0])/2-y*_Tr*1.25,.75}
      pigment{rgb .05}
      finish{
        specular .2 roughness .1
      }
    }
    texture{WhiteMetal_Tex}
    translate _Tr
  }
#end

//Dish
union{
  //Base
  torus{2.25,.25}
  cylinder{-y*.25,y*.25,2.25}
  cone{y*.25,1.8,y*2,.5}
    cylinder{<1.8,.25,0>,<.5,2,0>,.2}
    cylinder{<1.8,.25,0>,<.5,2,0>,.2 rotate y*90}
    cylinder{<1.8,.25,0>,<.5,2,0>,.2 rotate y*180}
    cylinder{<1.8,.25,0>,<.5,2,0>,.2 rotate y*270}
    sphere{<1.8,.25,0>,.2}
    sphere{<1.8,.25,0>,.2 rotate y*90}
    sphere{<1.8,.25,0>,.2 rotate y*180}
    sphere{<1.8,.25,0>,.2 rotate y*270}
    torus{.5,.2 translate y*2}
  cylinder{y*1.9,y*3,.5}
  //Main Dish
  union{
    difference{
      sphere{0,1}
      sphere{0,.95}
      box{<1.1,1.1,1.1>,<-1.1,-.5,-1.1>}
      scale 5
      translate y*7
    }
    sphere{0,.5}
    Dish_Struts(5,y*7)
    rotate z*50
    translate y*3
  }
  rotate y*clock*Animation_Time*Dish_Speed+y*112
  pigment{rgb .8}
  finish{
    specular .6 roughness .01
    reflection{0,.4 falloff 2}
    brilliance 3
  }
  translate y*4
}

// Generator
//===========
union{
  //Metallic parts
  superellipsoid{<.15,.15>
    scale <2,1,1>
    pigment{rgb <.2,.2,.4>}
    finish{
      specular 1 roughness .001
      reflection{.2,.8 falloff 2}
      brilliance 3
    }
  }
  //Yellow painted
  union{
    torus{2,.2 rotate z*90 scale <1,.75,1> translate < 1.5,0,0>}
    torus{2,.2 rotate z*90 scale <1,.75,1> translate <-1.5,0,0>}
    pigment{rgb <1,1,.1>}
    finish{
      specular .2 roughness .02
      brilliance 1
    }
  }
  //Opaque parts 
  union{
    superellipsoid{<.25,.25>
      scale <.35,.75,1.5>
      translate <-.75,.75,0>
    }
    superellipsoid{<.25,.25>
      scale <.35,.75,1.5>
      translate y*.75
    }
    superellipsoid{<.25,.25>
      scale <.35,.75,1.5>
      translate <.75,.75,0>
    }
    pigment{rgb .05}
    finish{
      specular .3 roughness .12
      brilliance 1.25
    }
  }
  translate <4,0,-9>
  pigment{rgb 1}
}

//Red/green cables
#declare Cable_BSpline_Red=array[4]
  {
    <.1,.5,.1,0>,<-1,-.2,0,0>,
    <-1,2.5,2,0>,<0,0,1,0>,
  }
#declare Cable_BSpline_Green=array[4]
  {
    <.1,.5,-.1,0>,<-1.5,-.2,0,0>,
    <-1.3,2.5,2,0>,<0,0,1,0>,
  }

union{
  Show_BSpline(Cable_BSpline_Red,.07,20)
  pigment{rgb x}
  translate <2,0,-9>
}
union{
  Show_BSpline(Cable_BSpline_Green,.07,20)
  pigment{rgb y}
  translate <2,0,-9>
}

// Powerlines
//============
#declare ElecCable_BSpline = array[4]
  {
    <0,0,0,0>,<0,-.9,.6,0>*2,
    <0,0,30,0>,<0,.9,.6,0>*2,
  }

#declare ElecCable =
  union{
    Show_BSpline(ElecCable_BSpline,.12,20)
    pigment{rgb .05}
    finish{
      specular .1 roughness .2
    }
  }
#declare Pole =
  union{
    cylinder{0,y*8,.2}
    box{<0,7,-.15><-2.5,7.3,.5>}
    cylinder{<-1.5,7.15,0>,<-.2,6.5,0>,.15}
    pigment{rgb <.2,.1,0>}
  }

#declare A=-10;
#while (A<15)
  object{Pole translate x*18+z*30*A-z*10}
  object{ElecCable translate x*18+z*30*A-z*10+<-2.3,7,0>}
  #declare A=A+1;
#end

// Street
//========
cylinder{z*1250,z*-1250,4 scale <1,.01,1>
  //Base-Layer
  texture{
    pigment{rgb .3}
  }
  //Dotted line
  texture{
    pigment{
      gradient z
      color_map{
        [0 rgbt 1]
        [.7 rgbt 1]
        [.7 rgb <1,1,0>]
        [.99 rgb <1,1,0>]
        [.99 rgbt 1]
        [1 rgbt 1]
      }
      scale 6
    }
  }
  //Limiting line to center
  texture{
    pigment{
      gradient x
      color_map{
        [0 rgb .3]
        [.47 rgb .3]
        [.47 rgbt 1]
        [.53 rgbt 1]
        [.53 rgb .3]
        [1 rgb .3]
      }
      translate x*.5 scale 8
    }
  }
  translate x*13
}

// Cable-Support 
//===============
union{
  cylinder{<7,-1,-14>,<7,6,-14>,.1}
  sphere{<7,6,-14>,.11}
  cylinder{<7,6,-14>,<7,6,-13>,.1}
  sphere{<7,6,-13>,.1}

  cylinder{x*.75,y*1.5,.1 rotate y*0 translate <7,0,-14>}
  cylinder{x*.75,y*1.5,.1 rotate y*90 translate <7,0,-14>}
  cylinder{x*.75,y*1.5,.1 rotate y*180 translate <7,0,-14>}
  cylinder{x*.75,y*1.5,.1 rotate y*270 translate <7,0,-14>}
  
  pigment{rgb .5}
  finish{
    specular .7 roughness .01
    reflection{.3,.7 falloff 2}
  }
}
box{-1,<1,.2,1> translate <7,0,-14>
  pigment{rgb .5}
}

// Cable
//=======
#declare EFeed1_BSpline = array[4]
  {
    <15.7,7,-10,0>,<0,-1,0,0>,
    <7,5.9,-13.5,0>,<0,1,0,0>,
  }
#declare EFeed2_BSpline = array[4]
  {
    <7,5.9,-13.5,0>,<0,-3,0,0>,
    <6,.5,-9,0>,<-1,0,0,0>,
  }

union{
  Show_BSpline(EFeed1_BSpline,.1,100)
  Show_BSpline(EFeed2_BSpline,.1,100)
  pigment{rgb .05}
  finish{
    specular .1 roughness .2
  }
}