// Persistence of Vision Ray Tracer Scene Description File
// File: scene4_.pov
// Vers: 3.6.1
// Desc: Scene 4 of Duel-Entry : UFO enters Atmosphere 
// Date: 25.09.04 (dd.mm.yy)
// Auth: Tim Nikias Wenclawiak
// Last Update: 25.09.04 (dd.mm.yy)

//Description
// Scene 4 of Duel-Entry
// The UFO's first appearance, drops from outer space through the clouds
// and embarks on its mission.

/*Commandline
+KFI1 +KFF100 +AM2 +A0.3 +R1
*/

//Homepage:
// www.nolights.de
//Email:
// LOWERCASEONLYtimISNTnikias[AT]gmx.netWARE

#include "duel.inc"
#include "timers.inc"

#declare Animation_Time = 4;

#default{finish{ambient 0}}
global_settings{
  assumed_gamma 1
  max_trace_level 25
}

// Sky-Color
//===========
#declare Sky_Clock = Clock_Cubic(.5,2.2);
background{rgb 0+<.3,.3,.6>*Sky_Clock}

// Sunlight
//==========
#declare SunLight_Pos = <400,1500,-300>;
light_source{SunLight_Pos rgb 1}
light_source{SunLight_Pos*<1,-1,1> rgb <.3,.3,.6>*.5*Sky_Clock shadowless}

// Camera
//========
//For the camera's shaking
Create_Shake(40,.75,1,"splines/sc4_cam.spl","Cam_Pos")

#declare CamPan_Clock = Clock_Cubic(1,2.5);
#declare CamShake_Clock = Clock_Cubic(0,3.75);
#declare CamFocal_Clock = Clock_Cubic(0,2);

#declare CShake = 1-pow(CamShake_Clock,2);

#declare Cam_1 = <9,-9,-12>;
#declare Cam_2 = <1,-6,-6>;

#declare Camera_Location = Cam_1+(Cam_2-Cam_1)*CamPan_Clock+Linear_Pos(Cam_Pos,clock)*CShake;
#declare Camera_Look_At =<0,.1,0>+Linear_Pos(Cam_Pos,1-clock)*CShake*(1+(1-CamFocal_Clock));

camera{
  location Camera_Location
  look_at Camera_Look_At 
}

// Fire
//======
//For the size and turbulence
Create_Shake(8,.5,2,"splines/sc4_fire.spl","Fire_Size")
#declare Fire_Clock = Clock_Cubic(1,2);
#declare Pull_Clock = Clock_Cubic(2.2,.5);

#declare Fire_Rise = 3;

#declare FireT_Pig =
  pigment{
    bozo poly_wave 2
    color_map{
      [0 rgbt <.6,.1,0,.3+.7*Pull_Clock>]
      [.8 rgbt <1,.4,0,.2+.8*Pull_Clock>]
      [1 rgbt <1,1,1,Pull_Clock>]
    }
    scale <.1,.04,.1>
    translate y*Fire_Rise*Animation_Time*clock
  }

#declare Fire_Pig = 
  pigment{
    bozo poly_wave 2
    color_map{
      [0 rgbt <.6,.1,0,Pull_Clock>]
      [.8 rgbt <1,.4,0,Pull_Clock>]
      [1 rgbt <1,1,1,Pull_Clock>]
    }
    scale <.1,.04,.1>
    translate y*Fire_Rise*Animation_Time*clock
  }

#declare Clear_Pig = pigment{rgbt <.5,.25,0,1>}


#declare Fire_Tex =
  texture{
    pigment{
      spherical
      #if (!Fire_Clock)
        pigment_map{[0 Clear_Pig][.3 FireT_Pig][1 Fire_Pig]}
      #end
      #if (Fire_Clock!=1 & Fire_Clock!=0)
        pigment_map{[0 Clear_Pig][.3-.29*Fire_Clock FireT_Pig][.95-Fire_Clock Fire_Pig][1-Fire_Clock Clear_Pig][1-Fire_Clock Clear_Pig]}
      #end
      translate Linear_Pos(Fire_Size,1-clock)*2 
      warp{turbulence .1 lambda 3 omega .6}
      translate -Linear_Pos(Fire_Size,1-clock)*2 
      scale .7+vlength(Linear_Pos(Fire_Size,clock))
      translate -y
    }
    finish{ambient 1}
  }

#declare FireTilt_Clock = Clock_Cubic(1.85,.25);

#if (Fire_Clock!=1)
union{
  sphere{0,1 hollow
    clipped_by{box{1.1,-<1.1,1.1,0>}}
    texture{Fire_Tex}
    scale <5,2,5>
  }
  sphere{0,1 hollow
    clipped_by{box{-1.1,<1.1,1.1,0>}}
    texture{Fire_Tex}
    scale <5,2,8>
  }
  rotate x*(15-15*FireTilt_Clock)
  no_shadow
}
#end

// UFO
//=====
#declare UFOTilt1_Clock = Clock_Cubic(1.85,1);
#declare UFOSpeed_Clock = Clock_Cubic(2.8,1);

#declare UFO_Condition = 0;
#declare UFO_Textured = 1;
#declare UFO_Lights = on;
#declare UFO_LightClock = Animation_Time*clock;

#include "ufo.inc"

object{UFO
  rotate x*(15-75*UFOTilt1_Clock)
  translate vrotate(-z*15*UFOSpeed_Clock,x*-60)
}


// Clouds
//========
#declare Cloud_Clock = Clock_Cubic(1.7,1.2);

#if (Animation_Time*clock > 57/25)

#declare A=0;
#while (A<5)

plane{y,0 hollow
  pigment{
    bozo
    color_map{
      [0 rgbt 1]
      [.6 rgbt 1]
      [.7 rgbt <.6,.6,.8,.5>]
      [1 rgbt <1,1,1,.3>]
    }
    translate y*.05*A+A*40
    warp{turbulence .3 lambda 3 omega .55}
    scale 50-35*clock
  }
  translate -y*(30+30*A)+y*250*Cloud_Clock
  
  double_illuminate
  finish{ambient .3 diffuse .8}
}

#declare A=A+1;
#end

#end

// Cloud-Haze
//============
// A small part of the scene is hazed with
// white, which is achieved with a layer in
// front of the camera.
#declare Cloud_Pig =
  pigment{
    bozo 
    color_map{
      [0 rgb .5]
      [.7-.2*clock rgb .7]
      [.8-.2*clock rgb 1]
      [1 rgb 1]
    }
    turbulence .3 lambda 3 omega .6 octaves 8
    scale <1,.5,1>
    translate x*.5+y*35*clock
  }


#declare Visibility_Clock = Clock_Cubic(48/25,15/25);

#if (sin(radians(180*Visibility_Clock)))
  Text_Layer(Cloud_Pig,.2,<2,1,1-sin(radians(180*Visibility_Clock))>,1)
#end