// Persistence of Vision Ray Tracer Scene Description File
// File: scene7_.pov
// Vers: 3.6.1
// Desc: Scene 7 of Duel-Entry : Jet shoots first missile 
// Date: 29.09.04 (dd.mm.yy)
// Auth: Tim Nikias Wenclawiak
// Last Update: 29.09.04 (dd.mm.yy)

//Description
// Scene 7 of Duel-Entry
// View from above/behind Jet. Sparkle alerts the Pilot of the UFO near the horizon, and
// 1st missile is launched.

/*Commandline
+KFI1 +KFF225 +AM2 +A0.3 +R1
*/

//Homepage:
// www.nolights.de
//Email:
// LOWERCASEONLYtimISNTnikias[AT]gmx.netWARE

#declare Animation_Time = 9;

global_settings{
  assumed_gamma 1
  max_trace_level 56
}

#include "duel.inc"
#include "booms.inc"
#include "timers.inc"
#include "bkdrp_desert.inc"

//Various Shakes for various objects
Create_Shake(4,.02,1,"splines/sc7_jet.spl","Jet_Hover")
Create_Shake(5,.03,2,"splines/sc7_cam.spl","Cam_Focal")
Create_Shake(30,1,3,"splines/sc7_flare.spl","Flare_Size")

// Backdrop
//==========
#declare Desert_HFDetail = 450;
#declare Desert_HF_Smooth = on;
#declare Desert_BaseColor = <.7,.3,.1>;
#declare Desert_UseDetailTex = false;
#declare Desert_UseSun = on;
#declare Desert_SunPos = <200,1200,-900>;
#declare Desert_SunArealights = 25;
#declare Desert_SunColor = 1;
#declare Desert_SunSizeMultiplier=1;

#declare Desert_Clouds = on;
#declare Desert_CloudTransform = transform{translate x*.01*clock*Animation_Time}
#declare Desert_CloudPercentage = 40;
#declare Desert_CloudShadow = off;

#declare Desert_ObjectScale = 1;

Create_Backdrop()
//Three point lighting to simulate ground-reflected/ambient light
light_source{<-1,1,-1>*Desert_SunPos rgb <.2,.2,.4> shadowless}
light_source{<0,6,5> rgb Desert_BaseColor*.3 shadowless}

// Jet
//=====
#declare Jet_Condition = 0;
#declare Jet_Textured = 1;
#declare Jet_Missiles = <0,1,1,1>;
#declare Jet_Exhaust = .5;

#include "jet.inc"

object{Jet
  rotate y*-90
  translate <0,25,0>+Linear_Pos(Jet_Hover,clock)
  }

// Missile
//=========
//Clocks for the Missile
#declare MisDrop_Clock = Clock_Cubic(6.75,.5);
#declare MisGo_Clock = Clock_Cubic(7.1,4);
//Position for the missile
#declare Missile_Align = vrotate(Jet_MissilePos_1,y*-90)+y*25+Linear_Pos(Jet_Hover,clock);
#declare Missile_Move = <-.25,-.3,0>*MisDrop_Clock+<50,0,0>*MisGo_Clock;
#declare Missile_Position = Missile_Align+Missile_Move;

//Missile
object{
  Missile(MisDrop_Clock)
  //Fit to Jet
  translate Jet_MissilePos_1
  rotate y*-90
  translate <0,25,0>+Linear_Pos(Jet_Hover,clock)
  //Move
  translate Missile_Move
}

// Camera
//========
//Move from Near-Ship to Cockpit-Perspective
#declare Cam_Zoom = Clock_Cubic(3,2);
//Pan from Cockpit to Missile
#declare Cam_CP2Mis = Clock_Cubic(4,2.5);

#declare Camera_Direction = vrotate(vrotate(<1,0,0>,(1-Cam_Zoom)*z*-10),<0,-220,0>*Cam_CP2Mis);
#declare Camera_Location = <.6,25.2,-.6>+<0,-.5,-.4>*Cam_CP2Mis+(1-Cam_Zoom)*<-2.4,.8,-.5>;

#declare Camera_Look_At = Camera_Location+Camera_Direction;
//Revert from directed camera to focus onto missile
#declare Camera_Look_At = Camera_Look_At+(Missile_Position-Camera_Look_At)*MisDrop_Clock;

//Controls the subtle shake of the camera
#declare Focal_Distance = vlength(Camera_Look_At-Camera_Location);
#declare Camera_Look_At = Camera_Look_At+Linear_Pos(Cam_Focal,clock)*Focal_Distance; 

camera{
  location Camera_Location
  look_at Camera_Look_At
}

// Subtitle
//==========
#declare txtJet_Clock = Duration(1.25,3);
#declare txt_Jet = pigment{image_map{tga "texts/sc7_j.tga"}}
#if (txtJet_Clock)
  Text_Layer(txt_Jet,.5,<2,1,0>,1)
#end

// Smoke-Particles
//=================
//Create Smoke at start, not during entire flight
#if (MisDrop_Clock & MisDrop_Clock != 1)
  #declare A=0;
  #while (A<5)
    Add_Smoke(
      Missile_Position-x*.75,
      <-20,0,0>,
      .1,
      2)
    #declare A=A+1;
  #end
#end

Parsys_Run()
Show_Smoke()

// Glare from UFO
//================
#declare Flare1_Clock = Clock_Cubic(.25,.75);
#declare Flare2_Clock = Clock_Cubic(1,.75);
#declare Flare_Clock = Flare1_Clock-Flare2_Clock;
#declare FlareSize_Clock = Duration_Faded(.25,1.5,<1.5,0>);
#declare UFO_Pos_Clock = Clock_Cubic(.25,1.5);

#declare UFO_Pos = <300,33-3*UFO_Pos_Clock,0>;
#declare Flare_Nor = vnormalize(UFO_Pos-Camera_Location);
#declare Flare_Loc = Camera_Location+Flare_Nor;

disc{0,Flare_Nor,1 hollow
  pigment{
    spherical poly_wave 3
    color_map{
      [0 rgbt 1]
      [1 rgbt <1,1,1,1-Flare_Clock>]
    }
  }
  finish{ambient 1 diffuse 0}
  scale .1+.05*Linear_Pos(Flare_Size,FlareSize_Clock).z
  translate Flare_Loc
  no_shadow no_reflection
}

// Animated Ground
//=================
#declare Clear = pigment{rgbt <.7,.3,.1,1>}
#declare Variation = pigment{bozo color_map{[0 rgb <.7,.3,.1>*.8][1 rgb <.7,.3,.1>*1.2]}scale 1/120*<2,2,4.5> translate -x*.5*Animation_Time*clock}

disc{
  y*5,y,120 hollow
  pigment{
    spherical pigment_map{[0 Clear][.4 Variation][1 Variation]} scale 120
  }
  no_shadow
}
