// Persistence of Vision Ray Tracer Scene Description File
// File: scene9_.pov
// Vers: 3.6.1
// Desc: Scene 9 of Duel-Entry : Missile flying towards Plasma
// Date: 01.10.04 (dd.mm.yy)
// Auth: Tim Nikias Wenclawiak
// Last Update: 01.10.04 (dd.mm.yy)

//Description
// Scene 9 of Duel-Entry
// The missile in profile heading towards the plasma.

/*Commandline
+KFI1 +KFF25 +AM2 +A0.3 +R1
*/

//Homepage:
// www.nolights.de
//Email:
// LOWERCASEONLYtimISNTnikias[AT]gmx.netWARE

#declare Animation_Time = 1;

global_settings{
  assumed_gamma 1
  max_trace_level 56
}

#include "bkdrp_desert.inc"
#include "duel.inc"
#include "timers.inc"
#include "booms.inc"

//Various Shakes for various objects
Create_Shake(13,1,26,"splines/sc9_fire.spl","Missile_Burner")

// Backdrop
//==========
#declare Desert_HFDetail = 450;
#declare Desert_HF_Smooth = on;
#declare Desert_BaseColor = <.7,.3,.1>;
#declare Desert_UseDetailTex = false;
#declare Desert_UseSun = on;
#declare Desert_SunPos = <200,1200,-900>;
#declare Desert_SunArealights = 25;
#declare Desert_SunColor = 1;
#declare Desert_SunSizeMultiplier=1;

#declare Desert_Clouds = on;
#declare Desert_CloudTransform = transform{translate x*.01*clock*Animation_Time}
#declare Desert_CloudPercentage = 40;
#declare Desert_CloudShadow = off;

#declare Desert_ObjectScale = 1;

Create_Backdrop()
//Ambient light
light_source{<-1,1,-1>*Desert_SunPos rgb <.2,.2,.4> shadowless}
light_source{<0,2,5> rgb Desert_BaseColor*.4 shadowless}

// Jet
//=====
#declare Jet_Condition = 0;
#declare Jet_Textured = 1;
#declare Jet_Missiles = <0,1,1,1>;
#declare Jet_Exhaust = .5;

#include "jet.inc"

// Camera
//========
#declare Camera_Location = <0,24.7,-2>;
#declare Camera_Look_At = y*24.8;

camera{
  location Camera_Location
  look_at Camera_Look_At
}

// Missile
//=========
object{
  Missile(.9+.1*Linear_Pos(Missile_Burner,clock).y)
  rotate y*-90
  rotate x*(24-78*clock)
  translate <0,25,0>+x*(-.3+.8*clock)+y*sin(radians(223*clock+132))*.02
}

// Animated Ground
//=================
#declare Clear = pigment{rgbt <.7,.3,.1,1>}
#declare Variation = pigment{bozo color_map{[0 rgb <.7,.3,.1>*.8][1 rgb <.7,.3,.1>*1.2]}scale 1/120*<2,2,4.5> translate -x*.5*Animation_Time*clock}

disc{
  y*5,y,120 hollow
  pigment{
    spherical pigment_map{[0 Clear][.4 Variation][1 Variation]} scale 120
  }
  no_shadow
}
