// Persistence of Vision Ray Tracer Scene Description File
// File: scene10_.pov
// Vers: 3.6.1
// Desc: Scene 10 of Duel-Entry : Plasma flying towards Missile
// Date: 02.10.04 (dd.mm.yy)
// Auth: Tim Nikias Wenclawiak
// Last Update: 02.10.04 (dd.mm.yy)

//Description
// Scene 10 of Duel-Entry
// Plasma heading towards missile.

/*Commandline
+KFI1 +KFF25 +AM2 +A0.3 +R1
*/

//Homepage:
// www.nolights.de
//Email:
// LOWERCASEONLYtimISNTnikias[AT]gmx.netWARE

#declare Animation_Time = 1;

global_settings{
  assumed_gamma 1
  max_trace_level 256
}

#include "bkdrp_desert.inc"
#include "duel.inc"
#include "booms.inc"

//Various Shakes for various objects
Create_Shake(12,1,6,"splines/sc10_flar.spl","Flare_Size")

// Backdrop
//==========
#declare Desert_HFDetail = 450;
#declare Desert_HF_Smooth = on;
#declare Desert_BaseColor = <.7,.3,.1>;
#declare Desert_UseDetailTex = false;
#declare Desert_UseSun = on;
#declare Desert_SunPos = <200,1200,-900>;
#declare Desert_SunArealights = 0;
#declare Desert_SunColor = 1;
#declare Desert_SunSizeMultiplier=1;

#declare Desert_Clouds = on;
#declare Desert_CloudTransform = transform{translate x*.01*clock*Animation_Time+<32,53,12>}
#declare Desert_CloudPercentage = 40;
#declare Desert_CloudShadow = off;

#declare Desert_ObjectScale = 1;

Create_Backdrop()
light_source{<-1,1,-1>*Desert_SunPos rgb <.2,.2,.4> shadowless}
light_source{<0,2,5> rgb Desert_BaseColor*.4 shadowless}

// Camera
//========
#declare Camera_Location = <0,24.2,-10>;
#declare Camera_Look_At = y*24.8;

camera{
  location Camera_Location
  look_at Camera_Look_At
}

// Flare/Plasma
//==============
#declare Plasma_Location = y*25+x*(2-5*clock);
Plasma_Bomb(Plasma_Location,<1,1,1>,<0,0,0>,<-10,0,0>)

#declare Camera_FocalLength = vlength(Camera_Look_At-Camera_Location);
#declare Flare_Nor = vnormalize(Plasma_Location-Camera_Location);
#declare Flare_Loc = Camera_Location+Flare_Nor;

disc{0,z,1 hollow
  pigment{
    spherical poly_wave 3
    color_map{
      [0 rgbt 1]
      [.7 rgbt <.8,.9,1,.3>]
      [1 rgbt <1,1,1,0>]
    }
  }
  finish{ambient 1 diffuse 0}
  scale <12,1,1>*(.15+1/Camera_FocalLength+.1*Linear_Pos(Flare_Size,clock).x)
  rotate Look_At(Camera_Look_At-Camera_Location)
  translate Flare_Loc
  no_shadow no_reflection
}

// Animated Ground
//=================
#declare Clear = pigment{rgbt <.7,.3,.1,1>}
#declare Variation = pigment{bozo color_map{[0 rgb <.7,.3,.1>*.8][1 rgb <.7,.3,.1>*1.2]}scale 1/120*<2,2,4.5> translate x*.5*Animation_Time*clock}

disc{
  y*5,y,120 hollow
  pigment{
    spherical pigment_map{[0 Clear][.4 Variation][1 Variation]} scale 120
  }
  no_shadow
}
