// Persistence of Vision Ray Tracer Scene Description File
// File: standard_.pov
// Vers: 3.6.1
// Desc: Scene 11 of Duel-Entry : Missile and Plasma "meet"
// Date: 02.10.04 (dd.mm.yy)
// Auth: Tim Nikias Wenclawiak
// Last Update: 02.10.04 (dd.mm.yy)

//Description
// Scene 11 of Duel-Entry
// Missile and Plasma hit in the air and explode.

/*Commandline
*/

//Homepage:
// www.nolights.de
//Email:
// LOWERCASEONLYtimISNTnikias[AT]gmx.netWARE

#declare Animation_Time = 4;

#default{finish{ambient 0}}
global_settings{
  assumed_gamma 1
  max_trace_level 256
}

#include "duel.inc"
#include "booms.inc"
#include "timers.inc"
#include "bkdrp_desert.inc"

//Various shakes
Create_Shake(9,1,5,"splines/sc11_flar.spl","Flare_Size")
Create_Shake(9,1,3,"splines/sc11_mis.spl","Missile_Burner")
Create_Shake(24,1,8,"splines/sc11_cam.spl","Cam_Shaker")

// Backdrop
//==========
#declare Desert_HFDetail = 450;
#declare Desert_BaseColor = <.7,.3,.1>;
#declare Desert_UseDetailTex = false;
#declare Desert_UseSun = on;
#declare Desert_SunPos = <200,1200,-900>;
#declare Desert_SunArealights = 0;
#declare Desert_SunColor = 1;
#declare Desert_SunSizeMultiplier=1;

#declare Desert_Clouds = on;
#declare Desert_CloudTransform = transform{translate x*.01*clock*Animation_Time}
#declare Desert_CloudPercentage = 40;
#declare Desert_CloudShadow = off;

#declare Desert_ObjectScale = 2;

Create_Backdrop()
light_source{<-1,1,-1>*Desert_SunPos rgb <.2,.2,.4> shadowless}
light_source{<-1,-1,1>*Desert_SunPos rgb Desert_BaseColor*.3 shadowless}

// Various Timers
//================
#declare PlMove_Clock = Clock_Linear(0,1);
#declare Plasma_Location = <20-19.8*PlMove_Clock,25,0>;

#declare MisMove_Clock = Clock_Linear(0,1);
#declare Missile_Location = <-20+19.8*MisMove_Clock,25,0>;

// Camera
//========
#declare CamMove = Clock_Cubic(0,4);
#declare CamZoom = Clock_Cubic(3,1);

#declare CamShakes = Clock_Linear(1,1);
#declare Shake_Apply = Duration_Faded(1,2,<.05,1.75>);

#declare Camera_Location = vrotate(<0,0,-20>,<-10+35*CamMove,-25+60*CamMove,0>)+y*25;

#declare Camera_Focal = <0,25,0>-y*2*CamZoom;

#declare Camera_Look_At = Camera_Location+vnormalize(Camera_Focal-Camera_Location);
#declare Camera_Look_At = Camera_Look_At+Linear_Pos(Cam_Shaker,CamShakes)*.1*pow(Shake_Apply,2);

camera{
  location Camera_Location
  look_at Camera_Look_At
}

// Explosion
//===========
//Settings for the Fire-Explosion
#declare ExpFire_Normal = <-1,0,0>;
#declare ExpFire_Timer = 1;
#declare ExpFire_Location = <0,25,0>;
#declare ExpFire_Scale = 1;
#declare ExpFire_Gravity = .5;
#declare ExpFire_Trails = 25;
//Settings for Plasma-Explosion
#declare ExpPlasma_Normal = <1,0,0>;
#declare ExpPlasma_Timer = ExpFire_Timer;
#declare ExpPlasma_Location = <0,25,0>;
#declare ExpPlasma_Scale = 1;
#declare ExpPlasma_Clouds = 11;


Generate_ExpFire()
Parsys_Run()
Show_ExpFire()
Show_ExpPlasma()

//Timer for the projectiles
#declare Shots = Duration(0,1);

#if (Shots)
//Plasma-Shot
Plasma_Bomb(Plasma_Location,<1,1,1>*.4,<0,0,0>,<-10,0,0>)

#declare Camera_FocalLength = vlength(Camera_Focal-Camera_Location);
#declare Flare_Nor = vnormalize(Plasma_Location-Camera_Location);
#declare Flare_Loc = Camera_Location+Flare_Nor;

disc{0,z,1 hollow
  pigment{
    spherical poly_wave 3
    color_map{
      [0 rgbt 1]
      [.7 rgbt <.8,.9,1,.3>]
      [1 rgbt <1,1,1,0>]
    }
  }
  finish{ambient 1 diffuse 0}
  scale <12,1,1>*(.15+1/Camera_FocalLength+.1*Linear_Pos(Flare_Size,clock).x)*.1
  rotate Look_At(Camera_Focal-Camera_Location)
  translate Flare_Loc
  no_shadow no_reflection
}

//Missile-Shot
object{
  Missile(.9+.1*Linear_Pos(Missile_Burner,clock).y)
  rotate y*-90
  scale 1
  rotate x*(24-78*clock)
  translate Missile_Location
}
#end

// Animated Ground
//=================
#declare Clear = pigment{rgbt <.7,.3,.1,1>}
#declare Variation = pigment{bozo color_map{[0 rgb <.7,.3,.1>*.8][1 rgb <.7,.3,.1>*1.2]}
  scale 1/120*<2,2,4.5>
  }

disc{
  y*5,y,120 hollow
  pigment{
    spherical pigment_map{[0 Clear][.4 Variation][1 Variation]} scale 120
  }
  no_shadow
}
