// Persistence of Vision Ray Tracer Scene Description File
// File: scene15_.pov
// Vers: 3.6.1
// Desc: Scene 15 of Duel-Entry : Missile flying towards Plasma and miss
// Date: 04.10.04 (dd.mm.yy)
// Auth: Tim Nikias Wenclawiak
// Last Update: 04.10.04 (dd.mm.yy)

//Description
// Scene 15 of Duel-Entry
// The missile heads towards the plasma, but misses... Is the UFO the
// better pilot?

/*Commandline
+KFI1 +KFF100 +AM2 +A0.3 +R1
*/

//Homepage:
// www.nolights.de
//Email:
// LOWERCASEONLYtimISNTnikias[AT]gmx.netWARE

#declare Animation_Time = 4;

global_settings{
  assumed_gamma 1
  max_trace_level 56
}

#include "duel.inc"
#include "booms.inc"
#include "timers.inc"
#include "bkdrp_desert.inc"

// Shakes
//========
Create_Shake(13,1,85,"splines/sc15_fire.spl","Missile_Burner")
Create_Shake(23,1,19,"splines/sc15_mis.spl","Missile_Pos")
Create_Shake(42,1,25,"splines/sc15_flar.spl","Flare_Size")
Create_Shake(12,1,46,"splines/sc15_cam.spl","Cam_Focal")

// Backdrop
//==========
#declare Desert_HFDetail = 450;
#declare Desert_HF_Smooth = on;
#declare Desert_BaseColor = <.7,.3,.1>;
#declare Desert_UseDetailTex = false;
#declare Desert_UseSun = on;
#declare Desert_SunPos = <200,1200,-900>;
#declare Desert_SunArealights = 25;
#declare Desert_SunColor = 1;
#declare Desert_SunSizeMultiplier=1;

#declare Desert_Clouds = on;
#declare Desert_CloudTransform = transform{translate x*.01*clock*Animation_Time}
#declare Desert_CloudPercentage = 40;
#declare Desert_CloudShadow = off;

#declare Desert_ObjectScale = 1;

Create_Backdrop()
light_source{<-1,1,-1>*Desert_SunPos rgb <.2,.2,.4> shadowless}
light_source{<0,2,5> rgb Desert_BaseColor*.4 shadowless}

// Missile
//=========
#declare Missile_Location = y*25+x*(-100+150*clock)+z*1.5;
#declare Plasma_Location = y*25+x*(100-150*clock)-z*1.5;

object{
  Missile(.9+.1*Linear_Pos(Missile_Burner,clock).y)
  rotate y*-90
  rotate x*(24-78*clock)
  translate Missile_Location+Linear_Pos(Missile_Pos,clock)*.04
}

// Camera
//========
#declare Cam2Pl_Zoom = Clock_Cubic(2.5,1.5);

#declare Camera_Location = Missile_Location+<-3,-.5,-.75>;
#declare Camera_Focal = Plasma_Location;
#declare Camera_Look_At = Camera_Location+vnormalize(Plasma_Location-Camera_Location)+(.05-.02*Cam2Pl_Zoom)*Linear_Pos(Cam_Focal,clock);

#declare C_Dir = vnormalize(Camera_Look_At-Camera_Location);

#if ((Camera_Look_At-Camera_Location).x > 0)
  #declare C_Sky = vrotate(y,x*(36-72*Clock_Cubic(0,4)));
#else
  #declare C_Sky = vrotate(y,-x*(36-72*Clock_Cubic(0,4)));
#end

#declare C_SkyOnDir = C_Sky+vdot(C_Dir,C_Sky)*C_Dir;
#declare Angle = degrees(acos(vdot(C_SkyOnDir,y)));

camera{
  location Camera_Location
  angle 66-55*Cam2Pl_Zoom
  sky C_Sky
  look_at Camera_Look_At
  
}

// Flare/Plasma
//==============
Plasma_Bomb(Plasma_Location,<1,1,1>,<0,0,0>,<-10,0,0>)

#declare Camera_FocalLength = vlength(Camera_Focal-Camera_Location);
#declare Flare_Nor = vnormalize(Plasma_Location-Camera_Location);
#declare Flare_Loc = Camera_Location+Flare_Nor;

disc{0,z,1 hollow
  pigment{
    spherical poly_wave 3
    color_map{
      [0 rgbt 1]
      [.7 rgbt <.8,.9,1,.3>]
      [1 rgbt <1,1,1,0>]
    }
  }
  finish{ambient 1 diffuse 0}
  scale <12,1,1>*(.05+1/Camera_FocalLength+.03*Linear_Pos(Flare_Size,clock).x)*(1-.5*Cam2Pl_Zoom)
  scale 1+3*Duration_Faded(65/25,6/25,<2/25,2/25>)
  #if (clock > .5)
    rotate z*Angle
  #else
    rotate -z*Angle
  #end
  rotate Look_At(Camera_Focal-Camera_Location)
  translate Flare_Loc
  no_shadow no_reflection
}

// Animated Ground
//=================
#declare Clear = pigment{rgbt <.7,.3,.1,1>}
#declare Variation = pigment{bozo color_map{[0 rgb <.7,.3,.1>*.8][1 rgb <.7,.3,.1>*1.2]}scale 1/120*<2,2,4.5> translate -x*Animation_Time*clock}

light_group{
  light_source{Desert_SunPos rgb 1 shadowless}
  light_source{<-1,1,-1>*Desert_SunPos rgb <.2,.2,.4> shadowless}
  light_source{<0,2,5> rgb Desert_BaseColor*.4 shadowless}
  disc{
    y*5,y,120 hollow
    pigment{
      spherical pigment_map{[0 Clear][.4 Variation][1 Variation]} scale 120
    }
    no_shadow
  }
  global_lights off
}