// Persistence of Vision Ray Tracer Scene Description File
// File: scene16_.pov
// Vers: 3.6.1
// Desc: Scene 16 of Duel-Entry : Jet evades Plasma-Shot
// Date: 04.10.04 (dd.mm.yy)
// Auth: Tim Nikias Wenclawiak
// Last Update: 04.10.04 (dd.mm.yy)

//Description
// Scene 16 of Duel-Entry
// Jet evades the plasma with a swift banking.

/*Commandline
+KFI1 +KFF125 +AM2 +A0.3 +R1
*/

//Homepage:
// www.nolights.de
//Email:
// LOWERCASEONLYtimISNTnikias[AT]gmx.netWARE

#declare Animation_Time = 5;

global_settings{
  assumed_gamma 1
  max_trace_level 56
}

#include "duel.inc"
#include "booms.inc"
#include "timers.inc"
#include "bkdrp_desert.inc"

// Shakes
//========
Create_Shake(32,1,73,"splines/sc16_flar.spl","Flare_Size")
Create_Shake(4,.04,67,"splines/sc16_jet.spl","Jet_Hover")
Create_Shake(22,1,37,"splines/sc16_cam.spl","Cam_Focal")

// Backdrop
//==========
#declare Desert_HFDetail = 450;
#declare Desert_HF_Smooth = on;
#declare Desert_BaseColor = <.7,.3,.1>;
#declare Desert_UseDetailTex = false;
#declare Desert_UseSun = on;
#declare Desert_SunPos = <200,1200,-900>;
#declare Desert_SunArealights = 0;
#declare Desert_SunColor = 1;
#declare Desert_SunSizeMultiplier=1;

#declare Desert_Clouds = on;
#declare Desert_CloudTransform = transform{translate x*.01*clock*Animation_Time}
#declare Desert_CloudPercentage = 40;
#declare Desert_CloudShadow = off;

#declare Desert_ObjectScale = 1;

Create_Backdrop()
light_source{<-1,1,-1>*Desert_SunPos rgb <.2,.2,.4> shadowless}
light_source{<0,6,5> rgb Desert_BaseColor*.3 shadowless}

// Jet
//=====
#declare Jet_Condition = 0;
#declare Jet_Textured = 1;
#declare Jet_Missiles = <0,1,1,0>;
#declare Jet_Exhaust = .5;

#include "jet.inc"

#declare JR_Tilt = Clock_Cubic(0,1.5);
#declare JR_DeTilt = Clock_Cubic(1.5,2);
#declare JM_Tilting = Clock_Cubic(.5,3.5);

#declare Plasma_Location = <100-400*clock,25,0>;

light_group{
  light_source{Plasma_Location rgb 5*<.6,.8,1> fade_power 2 fade_distance 1}
  object{Jet
    rotate y*-90
    translate y*-6
    rotate x*-45*sin(radians(JR_Tilt*90+90*JR_DeTilt))
    translate y*6
    translate <0,25,0>+<0,-3,-5.5>*JM_Tilting+Linear_Pos(Jet_Hover,clock)
    pigment{rgb 0}
  }
  global_lights on
}

// Camera
//========

#declare Cam_Focus = Clock_Cubic(1.5,3);
#declare Camera_Location = y*25+vrotate(<0,0,-15+5*clock>,<15-10*clock,55-145*clock,0>);
#declare Camera_Focal = <2-5*Clock_Cubic(1,2),24,0>+<0,-3,-5.5>*Cam_Focus;

//Controls the subtle shake of the camera
#declare Focal_Distance = vlength(Camera_Look_At-Camera_Location);
#declare Camera_Look_At = Camera_Location+vnormalize(Camera_Focal-Camera_Location);
#declare Camera_Look_At = Camera_Look_At+Linear_Pos(Cam_Focal,clock)*(.04+.02*Duration_Faded(14/25,30/25,<.1,.4>)-.03*Clock_Cubic(3,1.5));

camera{
  location Camera_Location
  look_at Camera_Look_At
}

// Plasma
//========
Plasma_Bomb(Plasma_Location,<1,1,1>*.75,<0,0,0>,<-10,0,0>)

#declare Camera_FocalLength = vlength(Camera_Focal-Camera_Location);
#declare Flare_Nor = vnormalize(Plasma_Location-Camera_Location);
#declare Flare_Loc = Camera_Location+Flare_Nor;

disc{0,z,1 hollow
  pigment{
    spherical poly_wave 3
    color_map{
      [0 rgbt 1]
      [.7 rgbt <.8,.9,1,.3>]
      [1 rgbt <1,1,1,0>]
    }
  }
  finish{ambient 1 diffuse 0}
  scale <12,1,1>*(.05+1/Camera_FocalLength+.03*Linear_Pos(Flare_Size,clock).x)*(1-.75*Clock_Cubic(1.5,2.5))
  rotate Look_At(Camera_Look_At-Camera_Location)
  translate Flare_Loc
  no_shadow no_reflection
}

// Animated Ground
//=================
#declare Clear = pigment{rgbt <.7,.3,.1,1>}
#declare Variation = pigment{bozo color_map{[0 rgb <.7,.3,.1>*.8][1 rgb <.7,.3,.1>*1.2]}scale 1/120*<2,2,4.5> translate -x*.5*Animation_Time*clock}

light_group{
  light_source{Desert_SunPos rgb 1 shadowless}
  light_source{<-1,1,-1>*Desert_SunPos rgb <.2,.2,.4> shadowless}
  light_source{<0,6,5> rgb Desert_BaseColor*.3 shadowless}
  disc{
    y*4,y,120 hollow
    pigment{
      spherical pigment_map{[0 Clear][.4 Variation][1 Variation]} scale 120
    }
    no_shadow
  }
  global_lights off
}