// Persistence of Vision Ray Tracer Scene Description File
// File: scene17_.pov
// Vers: 3.6.1
// Desc: Scene 17 of Duel-Entry : Missile flying towards UFO
// Date: 04.10.04 (dd.mm.yy)
// Auth: Tim Nikias Wenclawiak
// Last Update: 04.10.04 (dd.mm.yy)

//Description
// Scene 17 of Duel-Entry
// View along missile. Zoom in on UFO.

/*Commandline
+KFI1 +KFF25 +AM2 +A0.3 +R1
*/

//Homepage:
// www.nolights.de
//Email:
// LOWERCASEONLYtimISNTnikias[AT]gmx.netWARE

#declare Animation_Time = 4;

global_settings{
  assumed_gamma 1
  max_trace_level 56
}

#include "duel.inc"
#include "booms.inc"
#include "timers.inc"
#include "bkdrp_desert.inc"

// Shakes
//========
Create_Shake(13,1,26,"splines/sc17_fire.spl","Missile_Burner")
Create_Shake(21,1,38,"splines/sc17_cam.spl","Cam_Focal")
Create_Shake(12,1,48,"splines/sc17_mis.spl","Missile_Pos")
Create_Shake(9,1,48,"splines/sc17_ufo.spl","UFO_Hover")

// Backdrop
//==========
#declare Desert_HFDetail = 1000;
#declare Desert_HF_Smooth = on;
#declare Desert_BaseColor = <.7,.3,.1>;
#declare Desert_UseDetailTex = false;
#declare Desert_UseSun = on;
#declare Desert_SunPos = <200,1200,-900>;
#declare Desert_SunArealights = 25;
#declare Desert_SunColor = 1;
#declare Desert_SunSizeMultiplier=1;

#declare Desert_Clouds = on;
#declare Desert_CloudTransform = transform{translate x*.01*clock*Animation_Time}
#declare Desert_CloudPercentage = 40;
#declare Desert_CloudShadow = off;

#declare Desert_ObjectScale = 1;

Create_Backdrop()
light_source{<-1,1,-1>*Desert_SunPos rgb <.2,.2,.4> shadowless}
light_source{<0,2,5> rgb Desert_BaseColor*.4 shadowless}

// Missile
//=========
#declare Missile_Location = <-100,25,0>;
object{
  Missile(.9+.1*Linear_Pos(Missile_Burner,clock).y)
  rotate y*-90
  rotate x*(54+28*clock)
  translate Missile_Location+Linear_Pos(Missile_Pos,clock)*.03+y*sin(radians(223*clock+182))*.02
}

// Camera
//========
#declare Camera_Location = <0,24.7,-2>;
#declare Camera_Location = Missile_Location+<-3,-.5,-.5>;

#declare Camera_Look_At = Camera_Location+vnormalize(<50,25,0>-Camera_Location)+Linear_Pos(Cam_Focal,clock)*(.04-.03*Clock_Cubic(.5,3));

camera{
  location Camera_Location
  angle 66-63.5*Clock_Cubic(.5,3)
  look_at Camera_Look_At
}

// UFO
//=====
#declare UFO_Condition = 0;
#declare UFO_Textured = 1;
#declare UFO_Lights = on;
#declare UFO_LightClock = Animation_Time*clock+.33;

#include "ufo.inc"

object{UFO
  scale .25
  rotate y*90
  translate <50,25,0>+Linear_Pos(UFO_Hover,clock)*.01
  }

// Animated Ground
//=================
#declare Clear = pigment{rgbt <.7,.3,.1,1>}
#declare Variation = pigment{bozo color_map{[0 rgb <.7,.3,.1>*.8][1 rgb <.7,.3,.1>*1.2]}scale 1/120*<2,2,4.5> translate -x*.5*Animation_Time*clock}

light_group{
  light_source{Desert_SunPos rgb 1 shadowless}
  light_source{<-1,1,-1>*Desert_SunPos rgb <.2,.2,.4> shadowless}
  light_source{<0,2,5> rgb Desert_BaseColor*.4 shadowless}
  disc{
    y*5,y,120 hollow
    pigment{
      spherical pigment_map{[0 Clear][.4 Variation][1 Variation]} scale 120
    }
    no_shadow
  }
  global_lights off
}