// Persistence of Vision Ray Tracer Scene Description File
// File: scene19_.pov
// Vers: 3.6.1
// Desc: Scene 19 of Duel-Entry : Missile follows UFOs first evasion attempt
// Date: 05.10.04 (dd.mm.yy)
// Auth: Tim Nikias Wenclawiak
// Last Update: 05.10.04 (dd.mm.yy)

//Description
// Scene 19 of Duel-Entry
// Missile backs away from camera, follows the UFO's path of the former scene.

/*Commandline
+KFI1 +KFF50 +AM2 +A0.3 +R1
*/

//Homepage:
// www.nolights.de
//Email:
// LOWERCASEONLYtimISNTnikias[AT]gmx.netWARE

#declare Animation_Time = 2;

global_settings{
  assumed_gamma 1
  max_trace_level 56
}

#include "duel.inc"
#include "booms.inc"
#include "timers.inc"
#include "bkdrp_desert.inc"

// Shakes
//========
Create_Shake(13,1,95,"splines/sc19_fire.spl","Missile_Burner")
Create_Shake(12,1,37,"splines/sc19_mis.spl","Missile_Pos")
Create_Shake(9,1,64,"splines/sc19_cam.spl","Cam_Focal")

// Backdrop
//==========
#declare Desert_HFDetail = 450;
#declare Desert_HF_Smooth = on;
#declare Desert_BaseColor = <.7,.3,.1>;
#declare Desert_UseDetailTex = false;
#declare Desert_UseSun = on;
#declare Desert_SunPos = <200,1200,-900>;
#declare Desert_SunArealights = 25;
#declare Desert_SunColor = 1;
#declare Desert_SunSizeMultiplier=1;

#declare Desert_Clouds = on;
#declare Desert_CloudTransform = transform{translate x*.01*clock*Animation_Time}
#declare Desert_CloudPercentage = 40;
#declare Desert_CloudShadow = off;

#declare Desert_ObjectScale = 1;

Create_Backdrop()
light_source{<-1,1,-1>*Desert_SunPos rgb <.2,.2,.4> shadowless}
light_source{<0,2,5> rgb Desert_BaseColor*.4 shadowless}

// Camera
//========
#declare Camera_Location = <0-1*clock,25.1,-4>;
#declare Camera_Focal = <1-1*clock,25,0>;

#declare Camera_FocalLength = vlength(Camera_Focal-Camera_Location);
#declare Camera_Look_At = Camera_Location+vnormalize(Camera_Focal-Camera_Location)+Linear_Pos(Cam_Focal,clock)*.02;

camera{
  location Camera_Location
  look_at Camera_Look_At
}

// Missile
//=========
#declare Mis_Move = Clock_Cubic(.5,1.5);

object{
  Missile(.9+.1*Linear_Pos(Missile_Burner,clock).y)
  rotate y*-90
  rotate x*(24+90*Mis_Move+12*clock)
  translate <0,25,0>+Linear_Pos(Missile_Pos,clock)*.05
  translate z*4*Mis_Move
}

// Animated Ground
//=================
#declare Clear = pigment{rgbt <.7,.3,.1,1>}
#declare Variation = pigment{bozo color_map{[0 rgb <.7,.3,.1>*.8][1 rgb <.7,.3,.1>*1.2]}scale 1/120*<2,2,4.5> translate -x*.5*Animation_Time*clock}

disc{
  y*5,y,120 hollow
  pigment{
    spherical pigment_map{[0 Clear][.4 Variation][1 Variation]} scale 120
  }
  no_shadow
}
