// Persistence of Vision Ray Tracer Scene Description File
// File: scene23_.pov
// Vers: 3.6.1
// Desc: Scene 23 of Duel-Entry : UFO's ascends and tries to outrun Missile
// Date: 05.10.04 (dd.mm.yy)
// Auth: Tim Nikias Wenclawiak
// Last Update: 05.10.04 (dd.mm.yy)

//Description
// Scene 23 of Duel-Entry
// UFO now tries to outrun the missile, maybe even head off into space
// to leave it behind.

/*Commandline
+KFI1 +KFF100 +AM2 +A0.3 +R1
*/

//Homepage:
// www.nolights.de
//Email:
// LOWERCASEONLYtimISNTnikias[AT]gmx.netWARE

#declare Animation_Time = 4;

#default{finish{ambient 0}}
global_settings{
  assumed_gamma 1
  max_trace_level 25
}

#include "duel.inc"
#include "booms.inc"
#include "timers.inc"
#include "bkdrp_desert.inc"

// Shakes
//========
Create_Shake(23,1,64,"splines/sc23_fire.spl","Missile_Burner")
Create_Shake(14,1,93,"splines/sc23_cam1.spl","Cam_Focal")
Create_Shake(13,1,76,"splines/sc23_cam2.spl","Cam_Shake")

// Backdrop
//==========
#declare Desert_HFDetail = 450;
#declare Desert_BaseColor = <.7,.3,.1>;
#declare Desert_UseDetailTex = false;
#declare Desert_UseSun = on;
#declare Desert_SunPos = <200,1200,-900>;
#declare Desert_SunArealights = 0; //25;
#declare Desert_SunColor = 1;
#declare Desert_SunSizeMultiplier=1;

#declare Desert_Clouds = on;
#declare Desert_CloudTransform = transform{translate x*.01*clock*Animation_Time}
#declare Desert_CloudPercentage = 40;
#declare Desert_CloudShadow = off;

#declare Desert_ObjectScale = 2;

Create_Backdrop()
light_source{<-1,1,-1>*Desert_SunPos rgb <.2,.2,.4> shadowless}
light_source{<-1,-1,1>*Desert_SunPos rgb Desert_BaseColor*.2 shadowless}

//Relocate all objects in scene for proper height
#declare Scene_Center = <-50,0,0>;

// UFO
//=====
#declare UFO_Condition = 0;
#declare UFO_Textured = 1;
#declare UFO_Lights = on;
#declare UFO_LightClock = Animation_Time*clock+.65;

#include "ufo.inc"

#declare UFO_Rot = Clock_Cubic(0,1.75);
#declare UFO_Pos = vrotate(-y*150,z*-90*Clock_Linear(0,2))+y*150+<150,25,0>+y*Clock_Linear(2,2)*(.5*pi*150);

object{UFO
  rotate y*90
  rotate z*-90*UFO_Rot
  translate UFO_Pos
  translate Scene_Center
}

// Missile
//=========
object{
  Missile(.9+.1*Linear_Pos(Missile_Burner,clock).y)
  scale 10-7*Clock_Cubic(2,1)
  rotate y*-90
  rotate z*90
  translate y*150*Clock_Linear(2,2)+<-27,0,-6>
  translate Scene_Center
}

// Camera
//========
#declare Cam2Missile = Clock_Cubic(1.25,1);

#declare Camera_Location = <30-90*Clock_Cubic(0,4),29,-20+10*Clock_Linear(0,4)>;
#declare Camera_Look_At = UFO_Pos*<1,1-.4*Clock_Cubic(0,4),1>;
#declare Camera_Look_At = Camera_Location+vnormalize(Camera_Look_At-Camera_Location)+Linear_Pos(Cam_Focal,clock)*.03;
#declare Camera_Look_At = Camera_Look_At+Linear_Pos(Cam_Shake,Clock_Linear(60/25,20/25))*(Clock_Cubic(60/25,.1)-Clock_Cubic(65/25,.7))*.08;

camera{
  location Camera_Location
  look_at Camera_Look_At
  translate Scene_Center
}

// Animated Ground
//=================
#declare Clear = pigment{rgbt <.7,.3,.1,1>}
#declare Variation = pigment{bozo color_map{[0 rgb <.7,.3,.1>*.8][1 rgb <.7,.3,.1>*1.2]}scale 1/120*<2,2,4.5>}

light_group{
  light_source{Desert_SunPos rgb 1 shadowless}
  light_source{<-1,1,-1>*Desert_SunPos rgb <.2,.2,.4> shadowless}
  light_source{<-1,-1,1>*Desert_SunPos rgb Desert_BaseColor*.2 shadowless}
  disc{
    y*5,y,120 hollow
    pigment{
      spherical pigment_map{[0 Clear][.4 Variation][1 Variation]} scale 120
    }
    no_shadow
  }
  global_lights off
}
