// Persistence of Vision Ray Tracer Scene Description File
// File: scene31_.pov
// Vers: 3.6.1
// Desc: Scene 24 of Duel-Entry : UFO is tracked by Missile
// Date: 13.10.04 (dd.mm.yy)
// Auth: Tim Nikias Wenclawiak
// Last Update: 13.10.04 (dd.mm.yy)

//Description
// Scene 31 of Duel-Entry
// White flash fades to black and leaves remainder of jeet's sentence:
// ...END.

/*Commandline
+KFI1 +KFF75 +AM2 +A0.3 +R1
*/

//Homepage:
// www.nolights.de
//Email:
// LOWERCASEONLYtimISNTnikias[AT]gmx.netWARE

#declare Animation_Time = 3;

#default{finish{ambient 0}}
global_settings{
  assumed_gamma 1
  max_trace_level 25
}

#include "timers.inc"
#include "duel.inc"

#declare Camera_Location = <0,0,-5>;
#declare Camera_Look_At = <0,0,0>;

camera{
  location Camera_Location
  look_at Camera_Look_At
}

background{rgb 1-Clock_Cubic(.25,1)}

// Subtitle
//==========
#declare txtJet_Clock = Duration_Faded(0,3,<0,.5>);
#if (txtJet_Clock)
  #declare txt_Jet = pigment{image_map{tga "texts\sc31_j.tga"}}
  Text_Layer(txt_Jet,1,<2,1,1-txtJet_Clock>,1)
#end
