// Persistence of Vision Ray Tracer Scene Description File
// File: timers.inc
// Vers: 3.5
// Desc: Macros to time
// Date: 20.09.04 (dd.mm.yy)
// Auth: Tim Nikias Wenclawiak
// Last Update: 02.10.04 (dd.mm.yy)

//Required Files

//Description
// Duration_Faded
// Clock_Cubic


//Homepage:
// www.nolights.de
//Email:
// LOWERCASEONLYtimISNTnikias[AT]gmx.netWARE

#ifndef (Animation_Time) #declare Animation_Time = final_frame/25; #end

//Duration
//Function:
// Returns 0->1
//Parameters:
// 1. Start-Second
// 2. Total Duration (with fades)
//Returns:
// 0->1
//Notes:
// None
#macro Duration(_Start,_Duration)
  #local _Current = clock*Animation_Time;
  #if (_Current >= _Start & _Current <= _Start+_Duration)
    #local _Return = 1;
  #else
    #local _Return = 0;
  #end
  _Return
#end


//Duration_Faded
//Function:
// Returns 0->1 with fade-in and -out
//Parameters:
// 1. Start-Second
// 2. Total Duration (with fades)
// 3. <Fade_In,Fade_Out>
//Returns:
// 0->1 with given fades
//Notes:
// None
#macro Duration_Faded(_Start,_Duration,_Fading)
  #local _Current = clock*Animation_Time;
  #if (_Current >= _Start & _Current <= _Start+_Duration)
    #local _Return = 1;
    #if (_Current < _Start+_Fading.u)
      #local _Return = (_Current-_Start)/_Fading.u;
    #end
    #if (_Current >= _Start+_Duration-_Fading.v)
      #local _Return = 1-((_Current-_Start-_Duration+_Fading.v)/_Fading.v);
    #end
  #else
    #local _Return = 0;
  #end
  _Return
#end

//Clock_Cubic
//Function:
// Returns 0->1 with smooth transition
//Parameters:
// 1. Start-Second
// 2. Duration
//Returns:
// 0->1
//Notes:
// None
#macro Clock_Cubic(_Start,_Duration)
  #local _Current=clock*Animation_Time;
  #local _Return = 0;
  #if (_Current >= _Start)
    #local _LClock = (_Current-_Start)/_Duration;
    //#local _Return = pow(1-_LClock,3)+3*pow(1-_LClock,2)*_LClock+3*(1-_LClock)*pow(_LClock,2)+pow(_LClock,3);
    #local _Return = 3*(1-_LClock)*pow(_LClock,2)+pow(_LClock,3);
  #end
  #if (_Current >= _Start+_Duration)
    #local _Return = 1;
  #end
  _Return
#end

//Clock_Linear
//Function:
// Returns 0->1
//Parameters:
// 1. Start-Second
// 2. Duration
//Returns:
// 0->1
//Notes:
// None
#macro Clock_Linear(_Start,_Duration)
  #local _Current=clock*Animation_Time;
  #local _Return = 0;
  #if (_Current >= _Start)
    #local _Return = (_Current-_Start)/_Duration;
  #end
  #if (_Current >= _Start+_Duration)
    #local _Return = 1;
  #end
  _Return
#end
