// Persistence of Vision Ray Tracer Scene Description File
// File: ufo.inc
// Vers: 3.5
// Desc: Declarations for UFO-Parts
// Date: 14.09.04 (dd.mm.yy)
// Auth: Tim Nikias Wenclawiak
// Last Update: (dd.mm.yy)

//Required Files
// "io_macs.inc" : To load a vector generated by "ufo_mesh.pov"

//Description
// This file incorporates all model-versions of the UFO:
//  -new and unharmed, shiny metal
//  -hit at side by a rocket, a few marks on the texture
//  -crashed into the ground, pretty banged up textures
// After using the four declarations to select which model to use,
// simply place the UFO using "object{UFO}".

//Homepage:
// www.nolights.de
//Email:
// Tim.Nikias(@)nolights.de

/* Copy/Paste following lines
//UFO-Setup
#declare UFO_Condition = 0;
#declare UFO_Textured = 1;
#declare UFO_Lights = on;
#declare UFO_LightClock = 4;
*/

#ifndef (_io_macs_inc_tnw) #include "io_macs.inc" #end

//-1=Low-Poly, 0=Good, 1=1st hit, 2=Crashed
#ifndef (UFO_Condition) #declare UFO_Condition = 0; #end
//-1=Black with highlights for glare, 0=Black for Occlusion, 1=Textured according to condition
#ifndef (UFO_Textured) #declare UFO_Textured = 1; #end
#ifndef (UFO_Lights) #declare UFO_Lights = on; #end
#ifndef (UFO_LightClock) #declare UFO_LightClock = 0; #end

//=================
//Parts with meshes
//=================
#declare UFO_Top_Tex_Fine = texture{pigment{rgb <.6,.65,.8>}finish{specular .3 roughness .03 metallic .5 reflection{0,.4 falloff 2}}}
#declare UFO_Top_Tex_Hit = texture{pigment{rgb .05}finish{specular .04 roughness .2 brilliance 2}}

#declare UFO_Top=
  union{
    disc{0,y,1 hollow translate y*.75 pigment{rgb 0}}
    object{
      //** Meshes **/
      //Mesh for preview
      #if (UFO_Condition = -1)
        #include "ufo\ufo_tlow.msh"
      #end
      //Mesh for good condition
      #if (UFO_Condition=0 | UFO_Condition=1)
        #include "ufo\ufo_top.msh"
      #end
      //Mesh for destroyed condition
      #if (UFO_Condition=2)
        #include "ufo\ufo_tdst.msh"
      #end
      //** Textures **//
      //Highlighted Black
      #if (UFO_Textured=-1)
        texture{
          pigment{rgb 0}
          finish{
            specular .3 roughness .03
          }
        }
      #end
      //Non-Textured
      #if (UFO_Textured=0)
        texture{
          pigment{rgb 0}
          finish{ambient 0 diffuse 0}
        }
      #end
      //Textured and in good condition
      #if (UFO_Textured=1 & UFO_Condition!=2)
        texture{
          pigment{rgb <.6,.65,.8>}
          finish{
            specular .3 roughness .03 metallic .5
            reflection{0,.4 falloff 2}
          }
        }
      #end
      //Textured and in bad condition
      #if (UFO_Textured=1 & UFO_Condition=2)
      texture{
        planar
        poly_wave 1.5
        texture_map{
          [0 UFO_Top_Tex_Fine]
          [.8 UFO_Top_Tex_Hit]
          [1 UFO_Top_Tex_Hit]
        }
        poly_wave 1.5
        turbulence .7 omega .5 lambda 2.5 octaves 8
        rotate z*90 scale <6,3,3> translate -x*3.75 
      }
      #end
    }
  }

#declare UFO_Base_Tex_Fine = texture{pigment{rgb <.6,.65,.8>}finish{specular .3 roughness .03 metallic .5 reflection{0,.4 falloff 2}}}
#declare UFO_Base_Tex_Hit = texture{pigment{rgb <.2,.2,.2>}finish{specular .04 roughness .2 brilliance 2}}

#local Hit_Pos = Load_Value("ufo/ufo_hit.vec");

#declare UFO_Base=
  object{
    //** Meshes **//
    //Low-Poly Prevuew
    #if (UFO_Condition=-1)
      #include "ufo\ufo_blow.msh"
    #end
    //Good condition
    #if (UFO_Condition=0)
      #include "ufo\ufo_base.msh"
    #end
    //Hit condition
    #if (UFO_Condition=1 | UFO_Condition =2)
      #include "ufo\ufo_bhit.msh"
    #end
    //** Textures **//
    //Highlight Black
    #if (UFO_Textured=-1)
      texture{
        pigment{rgb 0}
        finish{
          specular .3 roughness .03
        }
      }
    #end
    //Non-Textured
    #if (UFO_Textured=0)
      texture{
        pigment{rgb 0}
        finish{ambient 0 diffuse 0}
      }
    #end
    //Textured and in good condition
    #if (UFO_Textured=1 & UFO_Condition=0)
      texture{
        pigment{rgb <.6,.65,.8>}
        finish{
          specular .3 roughness .03 metallic .5
          reflection{0,.4 falloff 2}
        }
      }
    #end
    //Textured and in hit condition
    #if (UFO_Textured=1 & (UFO_Condition=1 | UFO_Condition=2))
      texture{
        spherical scale 2 translate Hit_Pos
        texture_map{
          [0 UFO_Base_Tex_Fine]
          [.6 UFO_Base_Tex_Hit]
          [1 UFO_Base_Tex_Hit]
        }
      }
    #end
  }

//=========
//CSG-Parts
//=========
#declare UFO_Cockpit_Bar=
union{
  union{
  intersection{
    torus{1,.05 rotate z*90 scale <2,1,1>}
    box{<-.2,1.1,0>,<.2,-1.1,1.1>}
  }
  sphere{<0,1,0>,.05 scale <2,1,1>}
  rotate x*-20
  }
  union{
    difference{
      box{<-.1,1,0><.1,0,2>}
      cylinder{<-.2,0,0><.2,0,0>,1}
    }
    cylinder{<0,1,0><0,1,2>,.05 scale <2,1,1>}
    rotate x*30
  }
  //** Textures **/
  //Highlighted Black
  #if (UFO_Textured=-1)
    pigment{rgb 0}
    finish{
      specular .2 roughness .1
      brilliance 3
    }
  #end
  //Non-Textured
  #if (UFO_Textured=0)
    pigment{rgb 0}
    finish{ambient 0 diffuse 0}
  #end
  //Textured
  #if (UFO_Textured=1)
    pigment{rgb .2}
    finish{
      specular .2 roughness .1
      brilliance 3
    }
  #end
}

#declare UFO_CP_Normal = normal{bumps 0}
#declare UFO_CP_HitNormal = normal{crackle .2 no_bump_scale scale .12 solid}

#declare UFO_Cockpit =
union{
  sphere{y,.95
    //** Textures **//
    //Highlighted Black
    #if (UFO_Textured=-1)
      pigment{rgb 0}
      finish{
        specular 1 roughness .002
        brilliance 4
      }
    #end
    //Non-Textured
    #if (UFO_Textured=0)
      pigment{rgb 0}
      finish{ambient 0 diffuse 0}
    #end
    //Textured
    #if (UFO_Textured=1 & UFO_Condition!=2)
      pigment{rgb .2}
      finish{
        specular 1 roughness .002
        reflection{.4,1.25 falloff 3}
        brilliance 4
      }
    #end
    //Destroyed Condition
    #if (UFO_Textured=1 & UFO_Condition=2)
      pigment{rgb .2}
      normal{
        planar
        normal_map{
          [0 UFO_CP_Normal]
          [.2 UFO_CP_Normal]
          [.6 UFO_CP_HitNormal]
          [1 UFO_CP_HitNormal]
        }
        no_bump_scale rotate z*90 scale 1.5 translate -x
      }
      finish{
        specular 1 roughness .002
        reflection{.4,1.25 falloff 3}
        brilliance 4
      }
    #end

  }
  object{UFO_Cockpit_Bar rotate z*30  translate y}
  object{UFO_Cockpit_Bar rotate z*0   translate y}
  object{UFO_Cockpit_Bar rotate z*-30 translate y}
}

#declare UFO_RingSection =
  difference{
    union{
      intersection{
        torus{3.95,.1}
        box{<4.1,-.11,-4.1>,<0,.11,0>}
      }
      sphere{<0,0,-3.95>,.1}
      rotate y*-10
    }
    box{<4.1,-.11,1><0,.11,0>}
  }

#declare UFO_Ring=
union{  
  intersection{
    torus{3.85,.1}
    box{<-4.1,-.11,-4.1><4.1,.11,0>}
    scale <1,1,1.5>
    //** Textures **//
    //Highlighted Black
    #if (UFO_Textured=-1)
      pigment{rgb 0}
      finish{ambient 0 diffuse 0}
    #end
    //Non-Textured
    #if (UFO_Textured=0)
      pigment{rgb 0}
      finish{ambient 0 diffuse 0}
    #end
    //Textured
    #if (UFO_Textured=1)
      pigment{rgb 1}
      finish{ambient 1 diffuse 0}
    #end
  }
  intersection{
    torus{3.95,.1}
    box{<-4.1,-.11,4.1><4.1,.11,0>}
  }
  object{UFO_RingSection scale <1,1,1.5>}
  object{UFO_RingSection scale <-1,1,1.5>}
  //** Textures **//
  //Highlighted Black
  #if (UFO_Textured=-1)
    pigment{rgb 0}
    finish{
      specular .2 roughness .1
      brilliance 3
    }
  #end
  //Non-Textured
  #if (UFO_Textured=0)
    pigment{rgb 0}
    finish{ambient 0 diffuse 0}
  #end
  //Textured
  #if (UFO_Textured=1)
    pigment{rgb .2}
    finish{
      specular .2 roughness .1
      brilliance 3
    }
  #end
}

//Lights on the UFO
#declare UFO_BaseLight_Pos = Load_Value("ufo/ufo_lite.vec");
#declare UFO_LightOn=
  sphere{0,.05
    //** Textures **//
    //Non-Textured
    #if (UFO_Textured=-1)
      pigment{rgb 0}
      finish{ambient 0 diffuse 0}
    #end
    //Non-Textured
    #if (UFO_Textured=0)
      pigment{rgb 0}
      finish{ambient 0 diffuse 0}
    #end
    //Textured
    #if (UFO_Textured=1)
      pigment{rgb max(1*UFO_Lights,.5)}
      finish{ambient 1}
    #end
    no_shadow
  }
#declare UFO_LightOff=
  sphere{0,.05
    //** Textures **//
    //Non-Textured
    #if (UFO_Textured=-1)
      pigment{rgb 0}
      finish{ambient 0 diffuse 0}
    #end
    //Non-Textured
    #if (UFO_Textured=0)
      pigment{rgb 0}
      finish{ambient 0 diffuse 0}
    #end
    //Textured
    #if (UFO_Textured=1)
      pigment{rgbt 1}
      interior{ior 1.45}
      finish{specular 1 roughness .001}
    #end
  }

#declare UFO_LightAmount = 13;

#declare UFO_Lights=union{
  #declare A=0;
  #while (A<UFO_LightAmount)
    //Generate the power of the light
    #declare UFO_LightWave=sin(radians(720*(A/UFO_LightAmount)+360*UFO_LightClock));
    #if (UFO_LightWave>0)
      #declare UFO_LightIntensity=pow(UFO_LightWave,2);
    #else
      #declare UFO_LightIntensity=0;
    #end
    //Pre-Calculate the position and scale if required
    #declare _Active=vrotate(UFO_BaseLight_Pos,y*360/UFO_LightAmount*A);
    #if (_Active.z<0)
      #declare _Active=_Active*<1,1,1.5>;
    #end
    //Place Light if its power is high enough
    #if (UFO_LightIntensity>.2 & UFO_Lights!=0) 
    union{
      object{UFO_LightOn translate _Active}
      light_source{
        _Active-y*.1 rgb UFO_LightIntensity*UFO_Lights
        fade_power 2 fade_distance .5
      }
    }
    //Otherwise, just place a lightbulb
    #else
      object{UFO_LightOff translate _Active}
    #end
    #declare A=A+1;
  #end
}


//===============
//UFO-Composition
//===============
#declare UFO=
union{
  object{UFO_Cockpit}
  object{UFO_Top}
  object{UFO_Ring}
  object{UFO_Base}
  object{UFO_Lights}
}