#include "colors.inc"                       
#include "wagon.inc" 
 
// Drawing parameters
#declare use_sky = yes;   
#declare use_campfire = yes;
#declare use_ground = yes;
#declare use_wagons = yes;

#declare simple_sky = no;   
#declare simple_campfire = no;
#declare simple_ground = no;

// Scene parameters               
#declare n_wagons = 6; 
#declare wagon_scale = .1;
#declare wagon_center = <5, 0, -65>;
                    
#declare cam_pos =
spline { 
  natural_spline
  0.0   <0, 30, -120>   // Pan down
  3.0   <0, 30, -120> 
  6.0   <0, 30, -120> 
  9.0   <0, 20, -80>    // Zoom in 
  12.0  <0, 10, -40> 
  15.0  <0,  5, -20> 
  18.0  <0,  2, -10>
  20.0  <0,  2, -15>    // Fixed Location
}
#declare cam_look =
spline {                            

  natural_spline 
  0.0   <0, 50, 0>   // Pan down
  3.0   <0, 35, 0>
  6.0   <0, 20, 0>
  9.0   <0, 10, 0> 
  12.0  <0,  5, 0> 
  15.0  <0,  2, 0>
  18.0  <0,  1, 0>
  20.0  <0,  1, 0>
}   

#declare kk = clock;             
                      
// ----- camera -----
#include "screen.inc"
Set_Camera_Location (wagon_center + cam_pos(kk))
Set_Camera_Look_At  (wagon_center + cam_look(kk))
Set_Camera_Angle(30) 


// ----- text -----         
#macro font_tex(a)
  pigment {color a*Gold + (1-a)*Clear} 
  finish  {specular .5 ambient .7}
  normal  {bumps .3 scale .001}
#end

// ----- "FRONTIERS" ----- 
#declare start_text = 1.0;
#declare end_text   = 5.0;
#if (kk > start_text & kk < end_text)
  #declare a = sin(pi*(kk - start_text)/(end_text - start_text));
  #declare a = pow(a, 4*(1-sqrt(a)));
  Screen_Object (
    text {
      ttf "COPRGTB.TTF"
      "Frontiers"
      .01, 0 
      texture {font_tex(a)}                   
      scale .2
    }, 
    <0.2, 0.95>, 0.1,
    true, 0.1  
  )
#end

// ----- "by Caleb Hines" ----- 
#declare start_text = 5.0;
#declare end_text   = 9.0;
#if (kk > start_text & kk < end_text)                                    
  #declare a = sin(pi*(kk - start_text)/(end_text - start_text));
  #declare a = pow(a, 4*(1-sqrt(a)));
  Screen_Object (
    text {
      ttf "COPRGTB.TTF"
      "by Caleb Hines"
      .01, 0  
      texture {font_tex(a)}                 
      scale .1
    }, 
    <0.45, 0.95>, 0.1,
    true, 0.1  
  )
#end 


// ----- lights (except campfire) -----
// Main light.
// Used for testing when the campfire is off.
#if(!use_campfire)
  light_source {
    <-100, 100, -300> 
    color White
  }
#end 

// Fill lights  
light_source {            
  <200, 500, -200> 
  color Violet/1.5 
  shadowless    
}
light_source {            
  <-200, 50, -200> 
  color Violet/2
  shadowless    
} 


// ----- sky -----
#if (use_sky)
  #if (simple_sky)                
    background{ rgb <.1,.1,.3>}
  #else
    #declare galaxy_seed = 23339;
    #declare galaxy_colouration = 0.6;     
    #declare galaxy_bgstars = false;
    #declare star_count = 10000; 
    #declare star_scale = .5;
    #declare galaxy_intensity = .7; 
    #declare galaxy_pattern_scale = 2; 
    #declare galaxy_rotate = -60 * y;
    #include "Galaxy.inc" 
  #end         
#end
          
global_settings {
  max_trace_level 50 
}

// ----- ground -----  
#declare hf_scale = 200;
#declare hf_ratio = .05;  

#declare ground_tex =  
texture {
  pigment {
    agate
    color_map {               
      [0 color rgb <1, 1, 0>]
      [1 color rgb <.8, .7, .3>] 
    }    
    scale 100 
    turbulence .01
  }
  normal  {
    average
    normal_map {          
      [1 bumps .2 scale 10] 
      [1 bumps .2 scale 5]
      [1 bumps .5 scale .1]
    }
  }
  finish {
    ambient .03
  }
}                                                      
                  
#declare ground =
height_field {
  tga
  "terragen1_hires_blur.tga"
  smooth
  translate <-.5, 0, -.5>
  scale hf_scale * <1, hf_ratio, 1>
  
  #if (simple_ground)
    pigment {color rgb <.8, .7, .5>}
  #else
    texture {ground_tex}
  #end
}
                  
#if (use_ground)
  ground
#end


// ----- wagon path -----         
#declare resolution = 100;
  
// -- On the first frame, calculate and cache the path and distance splines
// -- so we don't have to recompute them every time.
#if (clock = initial_clock)      
  #debug "\nCreating and caching wagon's path...\n\n"
    
  #declare r = 5*n_wagons;
  #declare a = 2*pi*(170/360);
  #declare e = 1;      
  #declare d = 2*r/e;
    
  // -- Compute the path spline
  #declare wagon_path_spline =
  spline {
    natural_spline
    #declare i = -1; 
    #while (i < 1.5) 
      #declare theta = a-2*pi*mod(i,1);   
    
      #switch (i)
        #range (-1, 1)
        #declare pt = <r*cos(theta), 1, r*sin(theta)>; 
        #break
          
        #range (1, 1.5)   
        #declare p = e*d/(1-e*cos(theta)) + pow(theta-a, 2);
        #declare pt = <p*cos(theta), 1 + pow(22*(i-1),2), p*sin(theta)>;
        #break; 
      #end
    
      i  pt,
      #declare i = i + .01;
    #end
  }
    
  // -- Cache the path spline.
  #fopen path_cache "path_cache.dat" write 
    #declare i = -1;
    #while (i < 1.5)                        
      #if (i != -1)
        #write(path_cache, ", ")          
      #end
      #write(path_cache, wagon_path_spline(i))
      #declare i = i + 1/resolution;
    #end
  #fclose path_cache
    
  // -- Compute & cache the distance.
  #fopen dist_cache "dist_cache.dat" write
    #declare dist = 0;
    #declare i = -1;
    #declare p_new = wagon_path_spline(i);
    #while (i < 1.5)           
      #declare p_old = p_new;
      #declare p_new = wagon_path_spline(i);
      #declare dist = dist + vlength(p_new - p_old);
      #if (i != -1)
        #write(dist_cache, ", ")          
      #end
      #write(dist_cache, dist)
      #declare i = i + 1/resolution;
    #end
  #fclose dist_cache

#end 
  
// -- Load the cached path and distance spline files
#declare wagon_path =
spline {            
  natural_spline
  #fopen path_cache "path_cache.dat" read 
    #declare i = -1; 
    #while (i < 1.5)              
      #read(path_cache, pt)
      i, pt
      #declare i = i + 1/resolution;
    #end
  #fclose path_cache 
} 
    
#declare wagon_dist =
spline {            
  natural_spline
  #fopen dist_cache "dist_cache.dat" read 
    #declare i = -1;                  
    #declare n = 0;
    #while (i < 1.5)              
      #read(dist_cache, n) 
      i, n*<1,0,0> // spline expects vector, so encode distance in x-component   
      #declare i = i + 1/resolution;
    #end
  #fclose dist_cache 
}

#macro WagonParameter(Clock, i) 
  #declare wagon_accel_start_time = 14;
  #declare wagon_accel_duration = 5;
  #declare wagon_velocity = .07;
  
  // wt: Wagon Time
  // Set wt to be zero before the wagon's move, and increase with clock
  #declare wt = Clock - wagon_accel_start_time;
  #if (wt < 0) #declare wt = 0; #end   
  
  // st: Spline Time
  // Accelerate from zero to wagon_velocity during wagon_accel_duration,
  // and then remain at a constant velocity after that.
  #switch(wt)
    #range(0, wagon_accel_duration)
    #declare st = (wt*wt/(2*wagon_accel_duration)) * wagon_velocity;
    #break
  
    #range(wagon_accel_duration, 1000)
    #declare st = (wt - wagon_accel_duration/2) * wagon_velocity;
    #break
  #end
  
  // Start out half way around the circle, and offset for wagon        
  (.5 + st - i)
#end



// --------------------------------------
// Begin scene objects:             
union {
        
  // ----- wagons -----  
  #if (use_wagons)  
    #declare i = 0;
    #while (i < 1 - 1/n_wagons)
      #declare tt  = WagonParameter(clock, i);                               
      #declare p1  = wagon_path(tt); // current position                                        
      #declare p2  = wagon_path(tt+.05); // slightly ahead (to find direction)
      #declare dir = p2 - p1;           
      #declare dir = ((vlength(dir)>0) ? dir : x); 
      
      #declare wagon_distance = wagon_dist(tt).x;
      UpdateWagon(wagon_distance)
      
      object {
        wagon        
        translate 7*x                  
        transform {Reorient_Trans(x, dir)}
        translate p1
      } 
    
      #declare i = i + 1/n_wagons;
    #end  
  #end
  
  // ----- campfire -----                                   
  #if (use_campfire)
    #if (simple_campfire)   
      #declare a = .5; //minimum campfire intensity
      #declare campfire_intensity = a + 0.5*(1 - a) * 
      (1 + .5*(sin(18*pi*clock) + sin(8*pi*clock)));
    #else                                         
      #include "campfire.inc" 
      #declare campfire_intensity = pow(fire_light/18, 2);
    #end

    light_source {            
      <0, 3, 0> 
      color campfire_intensity * (White+Yellow+Red)/2
      fade_distance 2*n_wagons fade_power 2
      
      #if (simple_campfire)
        looks_like {
          sphere{
            0, 2 * campfire_intensity 
            pigment{color (Yellow+Red)/2}
            finish{ambient .8}
          }
        }
      #else
        looks_like {
          object {
            campfire
            scale 5     
            rotate 120*y
            translate -1.8*y
          }
        }
      #end
      
    }
  #end
  
  // ----- transform -----
  scale wagon_scale
  translate wagon_center
}