#declare max_clock = 20;

#include "colors.inc"     
#include "wagon.inc"
    
#declare use_earth  = yes;
#declare use_atmos  = yes; 
#declare use_wagons = yes; 

#declare simple_sky   = no; 
#declare simple_earth = no; 
#declare simple_wagons = no; 
                                                 
                                                 
// **********************************************    
#declare earth_radius = 1;
#declare sun_radius   = 1;
#declare sun_distance = 80 * sun_radius;
#declare sun_location = sun_distance * z;
                  
// ----- Simple Sun -----
// This code is obsolete, and is only retained for reference!
//#declare sun =
//sphere{
//  0, sun_radius
//  texture {
//    pigment {color White+Yellow}
//    finish {ambient 1}
//  }
//} 

// ----- Earth Texture ----- 
#if (use_earth & !simple_earth)
  #declare land_tex = 
  texture { 
    pigment {image_map {
      sys "../../include/planets/earth4.bmp" 
      map_type 1 interpolate 4
    }} 
    normal {bump_map {
      sys "../../include/planets/earthbump.bmp" 
      map_type 1 interpolate 4
      bump_size 2
    }}
    finish {
      diffuse .8 
      ambient .1
    }
  }
   
  #declare sea_tex =
  texture {
    pigment {image_map {
      sys "../../include/planets/earth4.bmp"
      map_type 1 interpolate 4
    }}
    normal {
      wrinkles .1
      turbulence .15
      scale .001
    }
    finish {
      specular 0.1
      reflection .2
      phong .3     
      phong_size 10
      diffuse.8
      ambient .1
    }
  }       
  
  #declare earth_tex =           
  texture {                         
    material_map{
      sys "../../include/planets/earthspecmono4.bmp" 
      map_type 1 interpolate 4
      texture {land_tex}
      texture {sea_tex}
    }            
  }  
#else                            
  #declare earth_tex =           
  texture {                         
    pigment {color Blue}
    finish {ambient 1}
  }
#end


// ----- Atmosphere Texture -----
#declare clear_color = (Clear+.2*White)/1.2;

#if (use_atmos)
  #declare atmos_tex =
  texture {
    pigment {
      bozo color_map {
        [0.0 clear_color] 
        [0.5 clear_color] 
        [0.7 White]
        [1.0 White]
      } turbulence 1 scale .1*<1, .3, 1>
    } 
    finish {
      ambient .2
    }
  }
#end
                                          
// *************************** Scene ***************************

#declare p0 = <-.92, .5, 0>;
#declare camera_location = p0 -0.25*z - .1*x;
#declare camera_look_at  = p0;
#declare camera_angle = 30;
   
camera{
  location camera_location
  look_at camera_look_at  
  angle camera_angle
}  
  
// ----- Sky -----
#if (!simple_sky)
  #declare galaxy_seed = 23339;
  #declare galaxy_colouration = 0.6;     
  #declare galaxy_bgstars = false;
  #declare star_count = 10000; 
  #declare star_scale = .5;
  #declare galaxy_intensity = .7; 
  #declare galaxy_pattern_scale = 2; 
  #declare galaxy_rotate = -80 * y;
  #include "galaxy.inc"
#else
  background {color Black}
#end

// ----- Sun ----- 
light_source {
  vrotate(sun_location, -30*y)
  color White*2
  //looks_like {sun}
} 

// ----- Flare ----- 
// This code is obsolete, and is only retained for reference!
//#if (!simple_sun)
//  #declare effect_type = "Sun3"
//  #declare effect_always_on_top = false;
//  #declare effect_falloff = 15;
//  #declare rays_flicker = true;
//  #declare effect_colour = <1.1, 1.5, 1.1>;
//  #declare source_colour = <1.5, 1.5, 1.2>;
//  #declare effect_brightness = .3;   
//  #declare effect_location = sun_location;
//  #include "lens.inc"
//#end

// ----- Fill Light
light_source {
  -sun_location + <10, 20, 0>
  color (SkyBlue + Violet + White)/5
}

// ----- Earth -----                               
#if (use_earth)   
sphere{
  0, earth_radius
  texture {earth_tex}        
  rotate 130*y     // China
  //rotate 252*y     // Mexico
  //rotate -10*y     // Sahara 
  no_shadow      // Otherwise, the wagons get eclipsed!
}
#end

// ----- Atmosphere -----
#if (use_atmos)
sphere {
  0, 1.001*earth_radius
  texture {atmos_tex}
  interior {
    media {
      scattering {1, 1}
    }
  }
}
#end                 

// ----- Wagons ------
#if (use_wagons)           
  #declare n_wagons = 6;
  #declare a0 = -50;
  #declare a1 = 25;
  #declare a = a0 + (a1-a0)*(clock/max_clock);
  
  #macro Orbit(tt)
    vrotate(<-1.08*cos(radians(tt)), 0, -1.3*sin(radians(tt))>, -28*z)
  #end
  
  #declare i = 0;
  #while (i < n_wagons)
  
    #declare ai = a - 2*i;
  
    #if (simple_wagons)
      sphere {
        0, .005       
        pigment {color White}
        no_shadow
        translate Orbit(a-i)
      }               
    #else 
      object {
        wagon               
        scale .002  
        Reorient_Trans(x, Orbit(ai+.1)-Orbit(ai-.1))
        Reorient_Trans(y, Orbit(ai))
        no_shadow
        translate Orbit(ai)
      }
    #end
      
    #declare i = i + 1;
  #end
#end   