#declare max_clock = 25;

#include "colors.inc"     
#include "wagon.inc"
    
#declare simple_sky = no;
#declare n_wagons = 6;

camera {
  location <6, 1, -3>
  look_at 0
} 

light_source {
  <30, 10, -50> 
  color (Violet+White)/3
}

// ----- Sky -----
#if (!simple_sky)
  #declare galaxy_seed = 23339;
  #declare galaxy_colouration = 0.6;     
  #declare galaxy_bgstars = false;
  #declare star_count = 10000; 
  #declare star_scale = .5;
  #declare galaxy_intensity = .7; 
  #declare galaxy_pattern_scale = 2; 
  #declare galaxy_rotate = -80 * x;
  #include "galaxy.inc"
#else
  background {color Black}
#end        


// ----- wagons -----  

#declare a0 = < 2, -1, -10>;
#declare a1 = <-2, -1, +10>;
#macro Path(tt)
  a0 + (a1-a0)*(tt+.25)
#end

#declare i = 0;
#while (i < n_wagons) 
  #declare kk = clock/max_clock;
  #declare tt = 1.5*kk - .1*i;            
  #declare r  = Path(tt);     
  #declare dr = Path(tt + .01)-Path(tt - .01);
  
  object {
    wagon        
    scale .09   
    Reorient_Trans(x, dr)
    translate r
  }
  
  #declare i = i + 1;
#end
