

// smooth curve 0->1
//#macro scurve(ih)
//#local ch = clip(ih,0,1);
//	ch*ch*(3-2*ch)
//#end
#macro scurve(ih)
	(0.5-cos(clip(ih,0,1)*3.14159)/2)
#end


// smooth curve 0->1->0
#macro ccurve(ih)
	(0.5-cos(clip(ih,0,1)*3.14159*2)/2)
#end

// iv =0.0->lower 0.0
// iv= lower->upper (linear 0.0->1.0)
// iv= upper->1.0 1.0
#macro interval(iv,lower,upper)
	clip((iv-lower)/(upper-lower),0,1)
#end

#macro lpos(veca,vecb,timea,timeb,ctime)
#if(ctime >timeb)
	vecb;
#else
#if(ctime <timea)
	veca;
#else
#local pt=(ctime-timea)/(timeb-timea);
	(veca+(vecb-veca)*pt);
#end
#end
#end


#macro tpos(veca,vecb,timea,timeb,ctime)
#if(ctime >timeb)
	vecb;
#else
#if(ctime <timea)
	veca;
#else
#local pt=(ctime-timea)/(timeb-timea);
	(veca+(vecb-veca)*scurve(pt));
#end
#end
#end


#macro tpos2(veca,vecb,vecc,timea,timeb,ctime)
#if(ctime >timeb)
	vecb;
#else
#if(ctime <timea)
	veca;
#else
#local pt=(ctime-timea)/(timeb-timea);
	(veca+(vecb-veca)*scurve(pt)+vecc*ccurve(pt));
#end
#end
#end


#macro disp_board(bpos)
#local i=0;
#while(i<8)
#local j=0;
#while(j<8)
#if(bpos[i][j]!=0.0)
#local pnum=int(bpos[i][j]);
#local col=(bpos[i][j]-pnum)*2;
object{peice(pnum,col,0) translate posn(j,i)}
#end
#local j=j+1;
#end
#local i=i+1;
#end
#end

#macro glow(vec,aa,cl)
plane
{
	<0,1,0>,0
	pigment
	{
		function {clip(aa-(x*x+z*z)-f_snoise3d(atan2(x,z)*4+cl*7,f_r(x,0,z)*4,atan2(z,x)*7+cl*5)/2,0,1)}
		colour_map
		{
			[0.0  rgbt <0.7,0.5,0.6,1> ]
			[0.2  rgbt <0.753, 0.645, 0.703,0.7> ]
			[0.75 rgbt <0.871, 0.310, 0.820,0.2> ]
			[0.9  rgbt <0.953, 0.745, 0.933,0.0> ]
			[1.0  rgbt <1,1,1,0.0> ]
		}
	}
	finish
	{
		ambient 2
		diffuse 0
	}
	scale 3.5
	translate vec
	clipped_by{box{<-16,-0.02,-16>,<16,0.02,16>}}
 	no_shadow
}
#end

#macro glow2(pn,cv,rv,tv)
union
{
object
{
	peice2(pn,-1)
	translate -cv
	scale 1.5
	rotate rv
	translate cv
	translate tv
//	pigment {rgbf 0.75}
	pigment {rgbf 1}
}
plane
{
	<0,1,0>,0.001
	pigment
	{
		object
		{
			peice2(pn,-1)
			translate -cv
			scale <1.4,2,1.4>
			rotate rv
			translate cv
			translate tv
			pigment { rgbt <0,0,0,1> }
			pigment { rgbt <1,1,1,0> }
		}
	}
	finish
	{
		ambient 2
		diffuse 0
	}
	clipped_by{box{<-16,-0.02,-16>,<16,0.02,16>}}
	no_shadow
}
}
#end

#declare thing=
union
{
	cone{-x*2,0.05,x*2,0.15 pigment {Red}}
	cone{-y*2,0.05,y*2,0.15 pigment {Green}}
	cone{-z*2,0.05,z*2,0.15 pigment {Blue}}
}
