// $Header: /home/bmh/irtc/RCS/pieces.pov,v 1.17 2005/03/28 12:08:14 bmh Exp bmh $
//1 pov unit ~= 10mm

// TODO pass 'bend' vector to all peices


#declare btext =
texture
{
#if(detail <1)
	finish
	{
		ambient 0.0
		brilliance 8
		diffuse 0.9
		metallic
		specular 0.8
		roughness 0.001
		reflection 0.55
	}
	normal
	{
		bumps 0.1
	}
#end
	pigment {rgb 0.5}
}

#declare rbtext =
texture
{
#if(detail <1)
	finish
	{
		ambient 0.0
		brilliance 8
		diffuse 0.9
		metallic
		specular 0.8
		roughness 0.001
		reflection 0.55
	}
	normal
	{
		bumps 2
		scale 0.25
		translate y*clock
	}
#end
	pigment {rgb 0.5}
}


#declare wtext =
texture
{
#if(detail<1)
	finish
	{
		ambient 0.33
		brilliance 8
		diffuse 0.5
		metallic
		specular 0.8
		reflection 0.4
	}
#end
	pigment {rgb <0.6,0.3,0.15>}
}

#declare rwtext =
texture
{
#if(detail<1)
	finish
	{
		ambient 0.33
		brilliance 8
		diffuse 0.5
		metallic
		specular 0.8
		reflection 0.4
	}
#end
	normal
	{
		bumps 2
		scale 0.25
		translate y*clock
	}
	pigment {rgb <0.6,0.3,0.15>}
}

#declare bluetext =
texture
{
#if(detail<1)
	finish
	{
		ambient 1
//		brilliance 8
		diffuse 0
//		metallic
//		specular 0.8
//		reflection 0.4
	}
#end
	normal
	{
		bumps 2
		scale 0.25
	}
	pigment {rgb <0.2,0.3,0.9>*8}
}

#declare pwtext =
texture
{
	pigment
	{
		bozo
		colour_map
		{
		[0.0 White]
		[0.5 White]
		[1.0 rgb <0.1,0.4,0.05>]
		}
		scale 0.2
	}
}

#declare pbtext =
texture
{
//	pigment{rgb 0.2}
	pigment
	{
		bozo
		colour_map
		{
		[0.0 rgb 0.2]
		[0.5 rgb 0.2]
		[1.0 rgb <0.1,0.4,0.05>]
		}
		scale 0.2
	}
}


#macro ptext(col,pat)
#if(pat!=-1)
#switch(col)
#case(0)
	texture{btext}
#break
#case(1)
	texture{wtext}
#break
#case(3)
	texture{pwtext}
#break
#case(4)
	texture{pbtext}
#break
#range(0.00001,0.99999)
	texture
	{
		bozo
		texture_map
		{
			[0.0 wtext]
			[col*0.95/2 wtext]
			[col*0.95 rwtext]
			[col bluetext]
			[0.05+col*0.95 rbtext]
			[(1.05+col*0.95)/2 btext]
			[1.0 btext]
		}
	}
#break
#end
#end
#end


#macro do_cone(points,num)
union
{
#local i=0;
#while(i<(num-1))
		cone{y*points[i][0],points[i][1],y*points[i+1][0],points[i+1][1]}
#local i=i+1;
#end
}
#end

#macro do_sor(points,num)
sor
{
	num+2,
	<points[0][1],points[0][0]-0.1>,
#local i=0;
#while(i<num)
	<points[i][1],points[i][0]>,
#local i=i+1;
#end
	<points[num-1][1],points[num-1][0]+0.1>
	sturm
}
#end

#declare ppnum=9;

#declare ppoints =
array[ppnum][2]
{
	{0,		0.95},
	{0.3,	0.95},
	{0.4,	0.85},
	{0.5,	0.9},
	{1,		0.45},
	{1.1,	0.5},
	{2.25,	0.25},
	{2.35,	0.5},
	{2.55,	0.25}
}


#macro pawn_old(col,pat)
union
{
	do_cyl(ppoints,ppnum)
	sphere{y*2.85,0.45}
	union
	{
		cone{0,0,y*0.2,0.55}
		cone{y*0.2,0.55,y*0.4,0}
		rotate <25,180,0>
		translate y*2.85
	}
	rotate <0,180*col,0>
	ptext(col,pat)
}
#end

#macro pawn(col,pat)
union
{
	do_sor(ppoints,ppnum)
	sphere{y*2.85,0.45}
	object
	{
//		cone{0,0,y*0.2,0.55}
//		cone{y*0.2,0.55,y*0.4,0}
		sphere{0,0.525 scale <1,0.25,1> translate y*0.175}
		rotate <25,180,0>
		translate y*2.85
	}
	rotate <0,180*col,0>
	ptext(col,pat)
}
#end

#declare rpnum=13;

#declare rpoints =
array [rpnum][2]
{
	{0,		1.1},
	{0.4,	1.1},
	{0.5,	0.95},
	{0.6,	1.05},
	{1.1,	0.6},
	{1.3,	0.7},
	{2.7,	0.5},
	{2.8,	0.6},
	{2.9,	0.5},
	{3.1,	0.8},
	{3.3,	0.6},
	{3.5,	0.8},
	{4.2,	0.8}
}


#macro rook(col,pat)
difference
{
	do_sor(rpoints,rpnum)
	union
	{
		box{<-0.075,0.2,-1> <0.075,0.65,1>}
		box{<-0.075,0.2,-1> <0.075,0.65,1> rotate 90*y }
		cylinder{<0,0.2,1> <0,0.2,-1> 0.075}
		cylinder{<0,0.2,1> <0,0.2,-1> 0.075 rotate 90*y }
		cylinder{0,y*0.65,0.65}
		translate y*3.6
	}
	ptext(col,pat)
	bounded_by{ cylinder {0,y*4.21,1.11} }
//	clipped_by{bounded_by}
}
#end


#declare bpnum=12;

#declare bpoints =
array [bpnum][2]
{
	{0,		1.0},
	{0.4,	1.0},
	{0.5,	0.9},
	{0.6,	1.0},
	{1.1,	0.6},
	{1.3,	0.7},
	{2.7,	0.3},
	{2.9,	0.6},
	{3.1,	0.3},
	{3.55,	0.25},
	{3.7,	0.5},
	{3.85,	0.2}
}

#macro bishop(col,pat)
difference
{
	union
	{
		do_sor(bpoints,bpnum)
		sphere{0, 0.4 scale <1,2,1> translate y*4.4}
		sphere{0, 0.15 translate y*5.1}
	}
	object
	{
		box{<-0.05,0.0,-0.5> <0.05,1,0.5> rotate 35*z}
		translate y*4.3
	}
	ptext(col,pat)
	rotate <0,180*col+90,0>
	bounded_by{ cylinder {0,y*5.7,1.01} }
}
#end

#declare knpnum=7;

#declare knpoints =
array [knpnum][2]
{
	{0,		1.0},
	{0.4,	1.0},
	{0.5,	0.9},
	{0.6,	1.0},
	{1.1,	0.6},
	{1.3,	0.7},
	{1.7,	0.1}
}

#macro knight(col,pat)
union
{
	do_sor(knpoints,knpnum)
	difference
	{
		intersection
		{
			union
			{
				sphere{0,1.5 scale <0.66,1,0.4>}
				cylinder{<-0.75,1.3,0> <1.2,1.1,0>,0.5}
			}
			box{<-1.5,-1.5,-0.35><1.5,2,0.35>}
		}
		union
		{
			sphere{0 1 scale <1,1.5,0.75> rotate <22.5,0,0> translate <-1,-0.2,-0.4>}
			sphere{0 1 scale <1,1.5,0.75> rotate <-22.5,0,0> translate <-1,-0.2,0.4>}

			cylinder{<-1.2,1.8,0> <0.5,1.9,0> 0.2} 
			cylinder{<-1.2,1.8,0.4> <0.5,1.8,0.4> 0.2} 
			cylinder{<-1.2,1.8,-0.4> <0.5,1.8,-0.4> 0.2}
			sphere{0,0.825 scale <2.5,1,1> translate <1.5,2.15,-0.65>}
			sphere{0,0.825 scale <2.5,1,1> translate <1.5,2.15,0.65>}
			sphere {0,0.4 scale <1.5,0.75,1> translate <1.25,0.67,-0.55>}
			sphere {0,0.4 scale <1.5,0.75,1> translate <1.25,0.67,0.55>}
			sphere {<-0,1.35,0.475> 0.2}
			sphere {<-0,1.35,-0.475> 0.2}
		}
		translate <-0.1,2.7,0>
	}
	rotate <0,180*col-90,0>
	ptext(col,pat)
}
#end


#declare kipnum=21;

#declare kipoints =
array [kipnum][2]
{
	{0,		1.3},
	{0.4,	1.3},
	{0.5,	1.1},
	{0.6,	1.2},
	{1.2,	0.7},
	{1.4,	0.8},
	{3.7,	0.4},
	{3.8,	0.7},
	{3.9,	0.4},
	{4.0,	0.6},
	{4.1,	0.4},
	{4.3,	0.5},
	{4.5,	0.4},
	{4.6,	0.7},
	{4.7,	0.4},
	{6.0,	0.8},
	{6.3,	0.75},
	{6.5,	0.7},
	{6.7,	0.5},
	{6.8,	0.3},
	{6.9,	0.2}
}

#macro king(col,pat)
union
{
	do_sor(kipoints,kipnum)
	difference
	{
		intersection
		{
			sphere{0,0.5}
			box{<-0.15,-1,-1><0.15,1,1>}
		}
		box{<-0.2,-0.65,-0.65><0.2,-0.15,-0.25>}
		box{<-0.2, 0.65, 0.65><0.2, 0.15, 0.25>}
		box{<-0.2,-0.65, 0.65><0.2,-0.15, 0.25>}
		box{<-0.2, 0.65,-0.65><0.2, 0.15,-0.25>}
		translate y*7.25
		rotate<0,90,0>
	}
	ptext(col,pat)
}
#end

#declare qpnum=17;

#declare qpoints =
array [qpnum][2]
{
	{0,		1.25},
	{0.4,	1.25},
	{0.5,	1.1},
	{0.6,	1.2},
	{1.2,	0.7},
	{1.4,	0.8},
	{3.7,	0.3},
	{3.8,	0.6},
	{3.9,	0.3},
	{4.0,	0.4},
	{4.1,	0.3},
	{4.3,	0.4},
	{4.5,	0.3},
	{5.7,	0.8},
	{6.0,	0.7},
	{6.3,	0.9},
	{6.5,	0.2}
}

#macro queen(col,pat)
difference
{
	union
	{
		do_sor(qpoints,qpnum)
		sphere{<0,6.5,0> 0.2}
	}
#local i=0;
#while(i<360)
	cylinder{<0.5,7,0> <1.1,6.1,0> 0.25 rotate <0,i,0>}
#local i=i+40;
#end
	ptext(col,pat)
	bounded_by{cylinder{0 y*6.7 1.3}}
}
#end

#macro posn(e,w)
	<e*3.5-12.25+f_snoise3d(e,0,w)/5,0,w*3.5-12.25+f_snoise3d(e,2,w)/5>
#end

#macro scene_text(num)
union
{
#local i=0;
#while(i<15)
	text
	{
		ttf "timrom.ttf" str(num,-3,0) , 0.1,0
		scale 4
		rotate <90,0,0>
		translate <0,0.01,1+i>
		rotate <0,i*153,0>
	}
#local i=i+1;
#end
//	pigment {Black}
}
#end

#macro board(pat)
object
{
	Round_Box_Union(<-16,0,-16> <16,-1,16>, 0.1)
	texture
	{
		object
		{
			box{<-14,0.1,-14><14,-0.1,14>}
			#if(detail <1)
				texture
				{
					T_Wood1
				}
				texture
				{
					checker texture {T_Wood32 scale 2 rotate 15 },texture {T_Wood3 scale 2 rotate -20}
					scale 3.5
				}
			#else
				texture
				{
					pigment
					{
						function{f_r(x/4,y/4,z/4)}
						colour_map
						{
							[0.0 Black]
							[1.0 White]
						}
						translate<-14.0,0,-14.0>
					}
				}
				texture
				{
				#if(detail <2)
					pigment{checker pigment {Red},pigment {Cyan}} scale 3.5
				#else
					object
					{
						scene_text(sceneno)
						texture{pigment{checker pigment {Red},pigment {Cyan}} scale 3.5}
						texture{pigment{Black}}
					}
				#end
				}
		#end
		}
	}
}
#end

#macro peice(pnum,col,pat)
#switch(pnum)
#case(1)
	pawn(col,pat)
#break
#case(2)
	rook(col,pat)
#break
#case(3)
	knight(col,pat)
#break
#case(4)
	bishop(col,pat)
#break
#case(5)
	queen(col,pat)
#break
#case(6)
	king(col,pat)
#break
#end
#end


#macro peice2(pnum,pat)
peice(int(pnum),2*(pnum-int(pnum)),pat)
#end
