// $Header: /home/bmh/irtc/RCS/sc001.pov,v 1.14 2005/03/17 17:43:33 bmh Exp bmh $
#include "colors.inc"
#include "stones.inc"
#include "metals.inc"
#include "woods.inc"
#include "textures.inc"
#include "math.inc"
#include "functions.inc"
//#include "glass.inc"
#include "logo.inc"
#include "shapes.inc"

#declare sceneno=001;
#include "camera.inc"
#include "global.inc"
#include "pieces.pov"
#include "background.pov"

#include "game.inc"

global_settings
{
	ambient_light rgb atan(clock*(1-clock/2)*15)/1.5
	max_trace_level 15
}

light_source { <-100,500,-300> color rgb  (atan(clock*(1-clock/2)*25)) }

// TODO move sky sphere and plane to include file 

do_sky((atan(clock*(1-clock/2)*3))/1.31)

object {ground}


camera
{
	right <image_width/image_height,0,0>
#declare campos=ecamvec+(<0,30,-350>*(clock-1)*(clock-1));
//	location campos+ccurve(clock)*<0,-2,0>
//	rotate<0,(clock-1)*(clock-1)*120,0>
#declare campos=vrotate(campos+ccurve(clock)*<0,-2,0>,<0,(clock-1)*(clock-1)*120,0>);
#declare lapos=tpos(svpvec,evpvec,0,1,clock)
	location campos
	look_at lapos
	sky <0,1,0-ccurve(clock)/4>

#if(vlength(campos-lapos)>35)
#declare fppos=vnormalize(campos)*(vlength(campos)-35);
#else
#declare fppos=lapos;
#end
	focal_point fppos
#if(detail<2)
	focal_point lapos
#declare ap=lpos(sapno,eapno,0,1,clock)
	aperture ap
#if(detail<1)
	blur_samples 128
	variance 1/1536
#else
	blur_samples 10
	variance 1/256
#end
#end
}

#if(detail>1)
object{thing translate lapos}
object{thing translate fppos}
#if(vlength(lapos)!=vlength(fppos))
cone{ lapos, 0.3, fppos, 0.1 pigment {Yellow}}
#end
#end

#declare clmove=
array[7][2]
{
	{-1,-0.1},
	{0,0.5},
	{1,0.6},
	{2,0.7},
    {3,0.8},
    {4,0.9}
    {5,1.0001}
}

object{board(0)}
object{debris(500)}

#declare i=0;
#while(i<8)
#if(clock>clmove[i][1])
#declare moven=clmove[i][0];
#declare mclock=(clock-clmove[i][1])/(clmove[i+1][1]-clmove[i][1]);
#else
#declare i=100;
#end
#declare i=i+1;
#end

#if(moven>0.0)

#declare v1=posn(fromy[moven],fromx[moven]);
#declare v2=posn(toy[moven],tox[moven]);
#if(int(moved[moven])=3)
#declare vt=tpos2(v1,v2,<0,1.75,0>,0.1,0.9,mclock)
#else
#declare vt=tpos(v1,v2,0.1,0.9,mclock)
#end

#declare bpos=ppos[moven-1];

#declare bpos[fromx[moven]][fromy[moven]]=0.0;

#if(capture[moven]>0.0)
#if(mclock>0.5)
#declare bpos[tox[moven]][toy[moven]]=0.0;
#end
#end

object{peice2(moved[moven],0) translate vt}

#else
#declare moven=0;
#declare bpos=ppos[moven];
#end

disp_board(bpos)

