// $Header: /home/bmh/irtc/RCS/sc008.pov,v 1.7 2005/03/24 18:55:52 bmh Exp bmh $

#include "colors.inc"
#include "stones.inc"
#include "metals.inc"
#include "woods.inc"
#include "textures.inc"
#include "math.inc"
#include "functions.inc"
//#include "glass.inc"
#include "logo.inc"
#include "shapes.inc"

#declare sceneno=008;
#include "camera.inc"
#include "global.inc"
#include "pieces.pov"
#include "background.pov"

#include "game.inc"


global_settings
{
	ambient_light rgb 1
	max_trace_level 15
}

light_source { <-100,500,-300> color rgb 1.49 }



#declare sd=0.3;
#declare sr=0.35;
#declare sl=2.5;
#declare sword=
union
{
	intersection
	{
		union
		{
			cylinder {<0,-sd,0> <sl,-sd,0> sr}
			sphere {0  sr scale <3,1,1> translate <sl,-sd,0>}
		}
		union
		{
			cylinder {<0,sd,0> <sl,sd,0> sr}
			sphere {0  sr scale <3,1,1> translate <sl,sd,0>}
		}
		bounded_by{box {<0,-0.05,-0.18>, <3.1, 0.05,0.18>}}
	}
	sphere {0 0.15 scale <0.75,0.75,4>}
	sphere {0 0.15 scale <3,1,1> translate <-0.4,0,0>}
	sphere {0 0.125 translate <0,0,0.5>}
	sphere {0 0.125 translate <0,0,-0.5>}
	sphere {0 0.15 scale <1,0.9,1> translate <-0.8,0,0>}
	bounded_by{box {<-1,-0.133,-0.66>, <3.1, 0.133,0.66>}}
	translate <0.4,0,0>
}


#declare hand=
union
{
	sphere{ 0, 0.30 scale <1,0.66,1>}
	object {sword translate <0,0,0.05>}
}


#macro larm(hvec)
union
{
	sphere{0,0.25}
	cone{0,0.25,<1.33,0,0>,0.175}
	sphere{0,0.175 translate <1.33,0,0>}
	object{hand  translate <0,-0.05,0.1> rotate hvec translate <1.33,0,0>}
}
#end

//object{ larm  translate <0,1,0>}

#macro uarm(hvec,evec)
union
{
	sphere{0,0.33}
	cone{0,0.33,<1.5,0,0>,0.25}
	object{larm(hvec) rotate evec translate <1.5,0,0>}
}
#end

//object{ uarm  translate <0,1,0>}

#macro arm(hvec,evec,svec)
	object{uarm(hvec,evec) scale 0.8 rotate svec}
#end

#declare uspl=
spline
{
	quadratic_spline
	0.0, <0,0,1.0>,
//	0.2, <0,1,0.0>,
	0.5, <0,1,0.0>,
	0.8, <0,0,1.0>,
	0.96, <0,0,1.0>,
	1.0, <0,0,1.0>
}

#declare espl=
spline
{
	quadratic_spline
	0.0, <0,2,0>,
	0.1, <0,1,0>,
	0.3, <0,0,0>,
	0.5, <0,1,0>,
	0.9, <0,1,0>,
	0.98, <0,2,0>,
	1.0, <0,2,0>
}

#declare hspl=
spline
{
	quadratic_spline
	0.0, <0,1,0>,
//	0.1, <0,0,0>,
	0.3, <0,0,0>,
	0.6, <0,0.5,0>,
	0.8, <0,0,0>,
	0.95, <0,1,0>,
	1.0, <0,1,0>
}

#declare moven=20;

object{ground}
do_sky(0.75)

object{board(0)}
object{debris(500)}

#declare bpos=ppos[moven-1];

#declare v1=posn(fromy[moven],fromx[moven]);
#declare v2=posn(toy[moven],tox[moven]);

#declare qmov=
spline
{
	quadratic_spline
	0.0 v1,
	0.3 (v1*3+v2)/4,
	1.0 v2
}

#declare vt=qmov(clock);

#declare sclock=interval(clock,0.1,0.8);

#if((sclock>0)&(sclock<1.0))
object {
	arm(180*hspl(sclock), -90*espl(sclock) ,-90*uspl(sclock))
	rotate <0,180,0>
	translate <0,3.25,0>+vt
	texture {wtext}
}
#end

#declare bpos[fromx[moven]][fromy[moven]]=0.0;

#declare pclock=interval(clock,0.43,1.0);
#if(capture[moven]>0.0)
#if(pclock>0)
	#declare pn=bpos[tox[moven]][toy[moven]];
	#declare bpos[tox[moven]][toy[moven]]=0.0;
	#declare p1=posn(toy[moven],tox[moven]);
	object
	{
		intersection
		{
			peice2(pn,0)
			cylinder{<0,-0.1,0>, <0,3.1,0>, 1.2}
			cutaway_textures
		}
		translate <0,-1.25,0>
		rotate<-20*pclock,60*pclock,-200*pclock>
		translate <0,1.25,0>
#declare p2=(p1-<-8,3.5*pclock,-6>*pclock);
		translate p2
	}
	glow(p2*<1,0,1>+<0,0.001,0>,(pclock+0.1)*(1-pclock*1.1)*3,pclock)

#declare hclock=pclock*1.3;
	object
	{
		intersection
		{
			peice2(pn,0)
			cylinder{<0,5.5,0>, <0,3.1,0>, 1.2}
			cutaway_textures
		}
		translate <0,-3.75,0>
		rotate<40*pclock,120*pclock,800*pclock>
		translate <0,3.75,0>
#declare p3=(p1-<-7,4.5*(hclock-0.2),-10>*hclock);
		translate p3
	}
#declare p4=p3*<1,0,1>;
#declare p3a=p3+<0,3.75,0>;
#if(vlength(p4-p3a)<2)
	glow(p4+<0,0.002,0>,0.66-vlength(p4-p3a)/3,hclock)
#end


#end
#end

object{peice2(moved[moven],0) translate vt}


disp_board(bpos)

camera
{
	right <image_width/image_height,0,0>
//#declare campos= tpos2(scamvec,ecamvec,mcamvec,0,1,clock)
//#declare lapos= tpos(svpvec,evpvec,0,1,clock)
#declare campos=camposspl2(clock+sceneno);
#declare lapos=camlookspl2(clock+sceneno);
	location campos
	look_at lapos

#if(detail<2)
	focal_point lapos
#declare ap=lpos(sapno,eapno,0,1,clock)
	aperture ap
#if(detail<1)
	blur_samples 128
	variance 1/1536
#else
	blur_samples 10
	variance 1/256
#end
#end
}

#if(detail>1)
object{thing translate lapos}
#end


