// $Header: /home/bmh/irtc/RCS/sc010.pov,v 1.8 2005/03/28 07:28:02 bmh Exp bmh $

#include "colors.inc"
#include "stones.inc"
#include "metals.inc"
#include "woods.inc"
#include "textures.inc"
#include "math.inc"
#include "functions.inc"
//#include "glass.inc"
#include "logo.inc"
#include "shapes.inc"

#declare sceneno=010;
#include "camera.inc"
#include "global.inc"
#include "pieces.pov"
#include "background.pov"

#include "game.inc"


global_settings
{
	ambient_light rgb 1
	max_trace_level 15
}

light_source { <-100,500,-300> color rgb 1.49 }

#declare moven=23;

object{ground}
do_sky(0.75)

object{board(0)}
object{debris(500)}

#declare bpos=ppos[moven-1];

#declare v1=posn(fromy[moven],fromx[moven]);
#declare v2=posn(toy[moven],tox[moven]);

#declare pos=
spline
{
	quadratic_spline
	0.0, v1,
	0.15, (v1+v2)/2,
	0.5, v2
}
//#declare vt=tpos(v1,v2,0.1,0.5,clock)
#declare vt=pos(clock);

#declare bpos[fromx[moven]][fromy[moven]]=0.0;

#declare evec=
array[4]
{
	<-1,4,-1>,
	<1,4,-1>,
	<-1,4,1>,
	<1,4,1>
}

#declare sclock=interval(clock,0.2,0.56);

#if(capture[moven]>0.0)
#if(sclock>0)
	#declare pn=bpos[tox[moven]][toy[moven]];
	#declare bpos[tox[moven]][toy[moven]]=0.0;
	#declare p1=posn(toy[moven],tox[moven]);
#declare pclock=interval(clock,0.46,1.0);
#local i=0;
#while(i<4)
#declare modvec=<f_bozo(i,0,0)+0.5,f_bozo(i,2,0)+0.5,f_bozo(i,4,0)+0.5>;
	object
	{
		intersection
		{
			difference
			{
				object
				{
					peice2(pn,0)
					scale 1+(0.4*scurve(sclock))
				}
				object
				{
					peice2(moved[moven],0)
					scale 0.8
					translate vt-p1
					translate <0,-0.01,0>
				}
			}
			box{<0,-0.1,0>,evec[i]*1.5 texture{wtext}}
		}
		translate <0,-1.25,0>
		rotate evec[i]*<-360,60,-360>*pclock*modvec
		translate <0,1.25,0>
#declare p2=(p1-evec[i]*<-6,2,-6>*<1,pclock,1>*pclock);
		translate p2
		normal
		{
			bumps ccurve(sclock)*2
			translate <0,sclock,0>
			scale 0.33
		}
	}
#local i=i+1;
	glow(p2*<1,0,1>+<0,0.001*i,0>,(pclock+0.1)*(1-pclock*1.1)*3,pclock)
#end
#end
#end

object{peice2(moved[moven],0) translate vt}


disp_board(bpos)

camera
{
	right <image_width/image_height,0,0>
//#declare campos= tpos2(scamvec,ecamvec,mcamvec,0,1,clock)
//#declare lapos= tpos(svpvec,evpvec,0,1,clock)
#declare campos=camposspl2(clock+sceneno);
#declare lapos=camlookspl2(clock+sceneno);
	location campos
	look_at lapos

#if(detail<2)
	focal_point lapos
#declare ap=lpos(sapno,eapno,0,1,clock)
	aperture ap
#if(detail<1)
	blur_samples 128
	variance 1/1536
#else
	blur_samples 10
	variance 1/256
#end
#end
}

#if(detail>1)
object{thing translate lapos}
#end


