// $Header: /home/bmh/irtc/RCS/sc014.pov,v 1.8 2005/03/28 10:52:45 bmh Exp bmh $

#include "colors.inc"
#include "stones.inc"
#include "metals.inc"
#include "woods.inc"
#include "textures.inc"
#include "math.inc"
#include "functions.inc"
//#include "glass.inc"
#include "logo.inc"
#include "shapes.inc"

#declare sceneno=014;
#include "camera.inc"
#include "global.inc"
#include "pieces.pov"
#include "background.pov"

#include "game.inc"


global_settings
{
	ambient_light rgb 1
	max_trace_level 15
}

light_source { <-100,500,-300> color rgb 1.49 }

#declare moven=28;

object{ground}
do_sky(0.75)

object{board(0)}
object{debris(500)}

#declare bpos=ppos[moven-1];

#declare v1=posn(fromy[moven],fromx[moven]);
#declare v2=posn(toy[moven],tox[moven]);

#declare v12=(v1*0.3+v2*0.7);

#declare vspl=
spline
{
	quadratic_spline
	0.0, v1,
	0.5, v12,
	0.6, v12,
	0.7, v12,
	0.8, v12,
	0.9, v12,
	1.0, v2
}

#declare vt=vspl(clock);

#declare bpos[fromx[moven]][fromy[moven]]=0.0;

#if(capture[moven]>0.0)
#declare pclock=interval(clock,0.5,1.0);
#if(pclock>0.0)
	#declare pn=bpos[tox[moven]][toy[moven]];
	#declare bpos[tox[moven]][toy[moven]]=0.0;
	#declare p1=posn(toy[moven],tox[moven]);
#local i=0;
#while(i<9)
	object
	{
		intersection
		{
			peice2(pn,0)
			difference
			{
				cylinder{<-2,-1,0> <2,-1,0> ((i+1)/2)+0.625}
				cylinder{<-2,-1,0> <2,-1,0> ((i+1)/2)+0.5}
			}
			cutaway_textures
		}
#declare rclock=interval(pclock,0.4-(i/20),1.0-(i/20));
		translate <0,1,0>
#if(f_snoise3d(i*4,20,30)>0)
		rotate <-180*rclock*rclock,0,(30-60*f_snoise3d(i,clock,0))*rclock>
#else
		rotate <180*rclock*rclock,0,(30-60*f_snoise3d(i,clock,0))*rclock>
#end
		translate <0,-1,0>
		translate p1
	}
#local i=i+0.25;
#end
#declare gclock=interval(pclock,0.4,1);
#if(clock>0.71)
	glow(p1*<1,0,1>+<0,0.001,gclock*5-5>,ccurve(gclock),gclock)
	glow(p1*<1,0,1>+<0,0.002,5-gclock*5>,ccurve(gclock),gclock)
#end
#end
#end

object{peice2(moved[moven],0) translate vt}


disp_board(bpos)

camera
{
	right <image_width/image_height,0,0>
//#declare campos= tpos2(scamvec,ecamvec,mcamvec,0,1,clock)
//#declare lapos= tpos(svpvec,evpvec,0,1,clock)
#declare campos=camposspl2(clock+sceneno);
#declare lapos=camlookspl2(clock+sceneno);
	location campos
	look_at lapos

#if(detail<2)
	focal_point lapos
#declare ap=lpos(sapno,eapno,0,1,clock)
	aperture ap
#if(detail<1)
	blur_samples 128
	variance 1/1536
#else
	blur_samples 10
	variance 1/256
#end
#end
}

#if(detail>1)
object{thing translate lapos}
#end


