// $Header: /home/bmh/irtc/RCS/sc017.pov,v 1.2 2005/03/28 07:28:02 bmh Exp bmh $

#include "colors.inc"
#include "stones.inc"
#include "metals.inc"
#include "woods.inc"
#include "textures.inc"
#include "math.inc"
#include "functions.inc"
#include "logo.inc"
#include "shapes.inc"

#declare sceneno=016;
#include "camera.inc"
#include "global.inc"
#include "pieces.pov"
#include "background.pov"

#include "game.inc"


global_settings
{
	ambient_light rgb 1
	max_trace_level 15
}

light_source { <-100,500,-300> color rgb 1.49 }

#declare moven=30;

object{ground}
do_sky(0.75)

object{board(0)}
object{debris(500)}


#declare sd=0.3;
#declare sr=0.35;
#declare sl=0.75;
#declare sword=
union
{
	intersection
	{
		union
		{
			cylinder {<0,-sd,0> <sl,-sd,0> sr}
			sphere {0  sr scale <3,1,1> translate <sl,-sd,0>}
		}
		union
		{
			cylinder {<0,sd,0> <sl,sd,0> sr}
			sphere {0  sr scale <3,1,1> translate <sl,sd,0>}
		}
		bounded_by{box {<0,-0.05,-0.18>, <3.1, 0.05,0.18>}}
	}
	sphere {0 0.15 scale <0.75,0.75,4>}
	sphere {0 0.15 scale <3,1,1> translate <-0.4,0,0>}
	sphere {0 0.125 translate <0,0,0.5>}
	sphere {0 0.125 translate <0,0,-0.5>}
	sphere {0 0.15 scale <1,0.9,1> translate <-0.8,0,0>}
	bounded_by{box {<-1,-0.133,-0.66>, <3.1, 0.133,0.66>}}
	scale 0.75
	translate <0.4,0,0>
}


#declare hand=
union
{
	sphere{ 0, 0.30 scale <1,0.66,1>}
	object {sword translate <0,0,0.05>}
}

#declare ehand=
object
{
	sphere{ 0, 0.30 scale <1,0.66,1>}
//	object {sword translate <0,0,0.05>}
}


#macro larm(dflag,hvec)
union
{
	sphere{0,0.25}
	cone{0,0.25,<1.33,0,0>,0.175}
	sphere{0,0.175 translate <1.33,0,0>}
#if(dflag>0)
	object{hand  translate <0,-0.05,0.1> rotate hvec translate <1.33,0,0>}
#else
	object{ehand  translate <0,-0.05,0.1> rotate hvec translate <1.33,0,0>}
#end
}
#end

//object{ larm  translate <0,1,0>}

#macro uarm(dflag,hvec,evec)
union
{
	sphere{0,0.33}
	cone{0,0.33,<1.5,0,0>,0.25}
	object{larm(dflag,hvec) rotate evec translate <1.5,0,0>}
}
#end

//object{ uarm  translate <0,1,0>}

#macro arm(dflag,hvec,evec,svec)
	object{uarm(dflag,hvec,evec) scale 0.8 rotate svec}
#end

#declare bpos=ppos[moven-1];

#declare bpos[6][5]=0.0;

#declare sclock=interval(clock,0,0.5);
#declare cclock=interval(clock,0,0.75);
#declare mclock=interval(clock,0.1,0.6);
#declare dclock=interval(clock,0.5,0.9);

#declare vt=posn(5,6)+<1.5,0,1.5>*scurve(mclock);
object
{
	union
	{
		peice2(1.5-(cclock/2),0)
		object
		{
			arm((dclock<0.5),<10,35*ccurve(dclock),10>,<0,60*ccurve(dclock),0>,<0,90*ccurve(dclock),90*ccurve(dclock)-90>)
			scale 0.8
			rotate <0,180,0>
			translate <0,2,0>
			texture{btext}
		}
	}
	scale 1+scurve(sclock)/3
	translate vt
}

#declare bpos[7][6]=0.0;

union
{
	peice2(6.5,0)
#if(dclock>0.5)
	object
	{
		sword
		scale 0.8
		rotate <10,20,0>
		translate <-1.02,2.68,-0.025>
		texture{btext}
	}
#end
	translate posn(6,7)
}

disp_board(bpos)

camera
{
	right <image_width/image_height,0,0>
#declare campos=<5,5,20>+clock*<-2,0,-3>;
#declare lapos=<6,2,8>+clock*<2,-1,2>;

	location campos
	look_at lapos

#if(detail<2)
	focal_point lapos
#declare ap=0.75-(clock/4);
	aperture ap
#if(detail<1)
	blur_samples 256*ap
	variance 1/1536
#else
	blur_samples 10
	variance 1/256
#end
#end
}

#if(detail>1)
object{thing translate lapos}
#end



