// $Header: /home/bmh/irtc/RCS/sc018.pov,v 1.7 2005/03/28 19:01:23 bmh Exp bmh $

#include "colors.inc"
#include "stones.inc"
#include "metals.inc"
#include "woods.inc"
#include "textures.inc"
#include "math.inc"
#include "functions.inc"
//#include "glass.inc"
#include "logo.inc"
#include "shapes.inc"

#declare sceneno=016;
#include "camera.inc"
#include "global.inc"
#include "pieces.pov"
#include "background.pov"

#include "game.inc"


global_settings
{
	ambient_light rgb 1
	max_trace_level 15
}


light_source { <-100,500,-300> color rgb 1.49 }


#declare sd=0.3;
#declare sr=0.35;
#declare sl=0.75;
#declare sword=
union
{
	intersection
	{
		union
		{
			cylinder {<0,-sd,0> <sl,-sd,0> sr}
			sphere {0  sr scale <3,1,1> translate <sl,-sd,0>}
		}
		union
		{
			cylinder {<0,sd,0> <sl,sd,0> sr}
			sphere {0  sr scale <3,1,1> translate <sl,sd,0>}
		}
		bounded_by{box {<0,-0.05,-0.18>, <3.1, 0.05,0.18>}}
	}
	sphere {0 0.15 scale <0.75,0.75,4>}
	sphere {0 0.15 scale <3,1,1> translate <-0.4,0,0>}
	sphere {0 0.125 translate <0,0,0.5>}
	sphere {0 0.125 translate <0,0,-0.5>}
	sphere {0 0.15 scale <1,0.9,1> translate <-0.8,0,0>}
	bounded_by{box {<-1,-0.133,-0.66>, <3.1, 0.133,0.66>}}
	scale 0.75
	translate <0.4,0,0>
}

#declare moven=30;

object{ground}
do_sky(0.75)

object{board(0)}
object{debris(500)}

#declare bpos=ppos[moven-1];

#declare bpos[6][5]=0.0;

#declare v1=posn(5,6)+<1.5,0,1.5>;
#declare v2=posn(6,4);
#declare vt=tpos2(v1,v2,<-2,0,-2>,0,0.4,clock)

object
{
	peice2(1.0,0)
	scale 1.3333
	translate vt
}

#declare bpos[7][6]=0.0;

union
{
	peice2(6.5,0)
	object
	{
		sword
		scale 0.8
		rotate <10,20,0>
		translate <-1.02,2.68,-0.025>
		texture{btext}
	}
	object
	{
		king(0,-1)
		scale <1.01,0.998,1.01>
//		translate <0,-0.001,0>
		texture
		{
			function{clip(0.1+f_r(x+0.9,y-2.7,z+0.4)-clock*f_bozo(x*3,y*3,z*3)*2,0,1)}
			texture_map
			{
				[0.5 Rusty_Iron]
				[0.5 pigment {rgbt <1,1,1,1>}]
				
			}
		}
	}
#declare tclock=interval(clock,0.0,0.8);
	rotate <0,100,0>*tclock
	translate <1.3,0,0>
	rotate<0,0,tclock*tclock*95>
	rotate<0,-tclock*65,0>
	translate <-1.3,0,0>
	translate posn(6,7)+tclock*<-2,0,2>
}



disp_board(bpos)

camera
{
	right <image_width/image_height,0,0>
#declare campos=<3,5,17>+<-5,0,-2>*scurve(clock)+<-4,0,-4>*ccurve(clock);
#declare lapos=<8,1,10>+<-4,0.5,2>*scurve(clock);
	location campos
	look_at lapos

#if(detail<2)
	focal_point lapos
#declare ap=0.5;
	aperture ap
#if(detail<1)
	blur_samples 256*ap
	variance 1/1536
#else
	blur_samples 10
	variance 1/256
#end
#end
}

#if(detail>1)
object{thing translate lapos}
#end



