
#include "colors.inc"
#include "stones.inc"
#include "metals.inc"
#include "woods.inc"
#include "textures.inc"
#include "math.inc"
#include "functions.inc"
//#include "glass.inc"
#include "logo.inc"
#include "shapes.inc"


global_settings
{
	noise_generator 2
	ambient_light rgb <2,2,2>
}

light_source { <-50,90,50-100*clock> color rgb (atan(clock*(1-clock)*20)/1.5) }


#declare textz=0.0;
#declare textd=1;

#declare text_ure =
texture
{
	normal{ bumps 0.0025 scale <1,10,0.1>} 
	finish {phong 0.82 phong_size 16}
	pigment {White}
}

camera
{
	right <image_width/image_height,0,0>
	location <0,7.5,0>
	look_at <0,0,0>
#if(detail<2)
	focal_point <0,3.5,0>
	aperture 0.1
#if(detail<1)
	blur_samples 192
	variance 1/1024
#else
	blur_samples 10
	variance 1/256
#end
#end

}


#declare all_text =
union
{

text
{
	ttf "timrom.ttf" "IRTC Animation",textd,0
	rotate <90,0,0>
	translate <-3.3,textz,2.5>
	texture{text_ure}
}


text
{
	ttf "timrom.ttf" "Entry - IMPOSTER!",textd,0
	rotate <90,0,0>
	translate <-4.15,textz,1.5>
	texture{text_ure}
}

text
{
	ttf "timrom.ttf" "\"CHESS\"",textd,0
	scale 2
	rotate <90,0,0>
	translate <-3.85,textz,-0.5>
	texture{text_ure}
}

text
{
	ttf "timrom.ttf" "Copyright (c) 2005",textd,0
	rotate <90,0,0>
	translate <-4,textz,-1.75>
	texture{text_ure}
}

text
{
	ttf "timrom.ttf" "Bernard Hatt",textd,0
	rotate <90,0,0>
	translate <-2.75,textz,-3>
	texture{text_ure}
}
}


#declare plane_text =
plane
{
	<0, 1, 0>, textz
	pigment
	{
		checker color White, color rgbf 1
	}
	clipped_by { sphere { <0,0,0>, 20 } }
}


object {all_text}


#if (1=0)
#declare inc=(1/25);

blob
{
	threshold 0.5

#declare i=(-6);
#while(i<6)
#declare j=(-4);
#while(j<4)
#declare k=trace(all_text,<i+f_bozo(i*20,clock,j*20)*inc,1,j+f_bozo(i*20,clock+10,j*20)*inc>, <0,-1,0>);
#if (vlength(k)!=0)
	sphere{k-<0,inc/2,0> inc*(1+f_bozo(i*20,clock+5,j*20)) 1}
#end
#declare j=j+inc;
#end
#declare i=i+inc;
#end
	pigment {White}
}
#end

#declare bmh = function(xx,yy,zz,tt)
{
	atan(
		(f_noise3d(xx*2,yy*2,zz*2)/2+f_snoise3d(xx*5,yy*5,zz*5+tt*5)/10+f_r(xx,yy,zz)-(tt*14.5)+8.5)
		*(f_noise3d(xx*3,yy*3,zz*3)/3+f_snoise3d(xx*5,yy*5,zz*5+tt*5)/10+f_r(xx,yy,zz)-(tt*10)+0.5)/2
	)/10
}


#declare new_bmh = function(xx,yy,zz,tt)
{
	atan(
		(f_noise3d(xx*2,yy*2,zz*2)/2+f_snoise3d(xx*5,yy*5,zz*5+tt*5)/10+f_r(xx,yy,zz)-(tt*14.5)+8.5)
		*(f_noise3d(xx*3,yy*3,zz*3)/3+f_snoise3d(xx*5,yy*5,zz*5+tt*5)/10+f_r(xx,yy,zz)-(tt*10)+0.5)/2
	)/3.1415926+0.50
}

#declare old_surface=
isosurface
{
	function{y-bmh(x,y,z,clock)}	
	max_gradient 1.7
	contained_by{ box{<-6,-1.0,-4>,<6,1.0,4>}}
	pigment { rgb <0.2,0.7,0.1> }
	finish {phong 0.82 phong_size 16}
}


#declare new_surface=
height_field
{
	function 256,256 {new_bmh(x*12-6,y*12-6,z*12,clock)}
//	function 256,256 {new_bmh(x*12-6,z*12-6,y*12-6,clock)}
//	function 256,256 {f_bozo(x*12-6,z*12-6,y*12-6)}
	smooth
	translate <-0.5,0,-0.5>
	scale <12,0.5,12>
	translate <0,-0.25,0>
	pigment { rgb <0.25,1,0> }
	finish {phong 0.28 phong_size 16}
}

new_surface
