#macro MAKE_GEAR(inner, outer, nteeth, w, s, h)
prism {
	linear_spline 0,h,nteeth*4
	#local n=0;
	#while (n<nteeth)
		#local a=n/nteeth*pi*2;
		#local b=(n+s)/nteeth*pi*2;
		#local c=(n+s+w)/nteeth*pi*2;
		#local d=(n+s+w+s)/nteeth*pi*2;
		,<sin(a)*inner, cos(a)*inner>,
		<sin(b)*outer, cos(b)*outer>,
		<sin(c)*outer, cos(c)*outer>,
		<sin(d)*inner, cos(d)*inner>
		#local n=n+1;
	#end
}
#end

#macro MAKE_GEAR_PARTIAL(inner, outer, nteeth, w, s, h, real_nteeth)
prism {
	linear_spline 0,h,real_nteeth*4
	#local n=-real_nteeth/2;
	#while (n<real_nteeth/2)
		#local a=n/nteeth*pi*2;
		#local b=(n+s)/nteeth*pi*2;
		#local c=(n+s+w)/nteeth*pi*2;
		#local d=(n+s+w+s)/nteeth*pi*2;
		,<sin(a)*inner, cos(a)*inner>,
		<sin(b)*outer, cos(b)*outer>,
		<sin(c)*outer, cos(c)*outer>,
		<sin(d)*inner, cos(d)*inner>
		#local n=n+1;
	#end
}
#end