// This is my entry into the IRTC Animation competition for 2007.01.15.
// The theme is "Dance".
// Since this is my first animation, it is pretty basic - just a boy ball
// and a girl ball dancing together.

#include "colors.inc"

// This is the title screen, shown for 3 seconds
#if (clock < 3)
  camera
  {
    location <0, 0.5, -10>
    look_at <0, 0.5, 1>
  }

  light_source
  {
    <-10, 10, -10>
    White
  }

  text
  {
    ttf "times.ttf" "Having A Ball" 0.1, 0
    pigment { Gold }
    translate <-3, 2, 0>
  }

  text
  {
    ttf "times.ttf" "IRTC Animation - Dance" 0.1, 0
    pigment { Gold }
    translate <-5, 1, 0>
  }

  text
  {
    ttf "times.ttf" "2007.01.15" 0.1, 0
    pigment { Gold }
    translate <-2.4, 0, 0>
  }

  text
  {
    ttf "times.ttf" "Troy Dolyniuk" 0.1, 0
    pigment { Gold }
    translate <-3.1, -1, 0>
  }
#end

// A second of darkness
#if (clock >= 3 & clock < 4)
  #declare lclock = clock - 3;
  #declare girl_x = -100;
  #declare girl_y = 5;
  #declare girl_z = -100;
  #declare boy_x = 100;
  #declare boy_y = 5;
  #declare boy_z = -100;
#end

// This is the girl walking on screen, 4 seconds
#if (clock >= 4 & clock < 8)
  #declare lclock = clock - 4;
  #declare girl_x = -40 + 10 * lclock * 3/4;
  #declare girl_y = 5;
  #declare girl_z = -30 + 10 * lclock * 3/4;
  #declare boy_x = 100;
  #declare boy_y = 5;
  #declare boy_z = -100;
#end

// This is the boy sphere entering the scene, 4 seconds
#if (clock >= 8 & clock < 12)
  #declare lclock = clock - 8;
  #declare girl_x = -10;
  #declare girl_y = 5;
  #declare girl_z = 0;
  #declare boy_x = 40 - 10 * lclock * 3/4;
  #declare boy_y = 5;
  #declare boy_z = -30 + 10 * lclock * 3/4;
#end

// This is where they get closer together, 2 seconds
#if (clock >= 12 & clock < 14)
  #declare lclock = clock - 12;
  #declare girl_x = -10 + 2.5 * lclock / 2;
  #declare girl_y = 5;
  #declare girl_z = 0;
  #declare boy_x = 10 - 2.5 * lclock / 2;
  #declare boy_y = 5;
  #declare boy_z = 0;
#end

// Pause for one second
#if (clock >= 14 & clock < 15)
  #declare lclock = clock - 14;
  #declare girl_x = -7.5;
  #declare girl_y = 5;
  #declare girl_z = 0;
  #declare boy_x = 7.5;
  #declare boy_y = 5;
  #declare boy_z = 0;

  light_source
  {
    <0, 30, -30>
    colour White
  }
#end

// Girl starts dancing a little, 2 seconds
#if (clock >= 15 & clock < 17)
  #declare lclock = clock - 15;
  #declare girl_x = -7.5;
  #declare girl_y = 5;
  #declare girl_z = 0 + sin(radians(360 * lclock));
  #declare boy_x = 7.5;
  #declare boy_y = 5;
  #declare boy_z = 0;

  light_source
  {
    <0, 30, -30>
    colour White
  }
#end

// Boy joins in, 1 second
#if (clock >= 17 & clock < 18)
  #declare lclock = clock - 17;
  #declare girl_x = -7.5;
  #declare girl_y = 5;
  #declare girl_z = 0 + sin(radians(360 * lclock));
  #declare boy_x = 7.5;
  #declare boy_y = 5;
  #declare boy_z = 0 + sin(radians(360 * lclock));

  light_source
  {
    <0, 30, -30>
    colour White
  }
#end

// Larger dance amplitudes, 1 second
#if (clock >= 18 & clock < 19)
  #declare lclock = clock - 18;
  #declare girl_x = -7.5;
  #declare girl_y = 5;
  #declare girl_z = 0 + 2 * sin(radians(360 * lclock));
  #declare boy_x = 7.5;
  #declare boy_y = 5;
  #declare boy_z = 0 + 2 * sin(radians(360 * lclock));

  light_source
  {
    <0, 30, -30>
    colour White
  }
#end

// Girl goes around boy, 2 seconds
#if (clock >= 19 & clock < 21)
  #declare lclock = clock - 19;
  #declare girl_x = 7.5 - 15 * cos(radians(360 * lclock / 2));
  #declare girl_y = 5;
  #declare girl_z = 0 + 15 * sin(radians(360 * lclock / 2));
  #declare boy_x = 7.5;
  #declare boy_y = 5;
  #declare boy_z = 0;

  light_source
  {
    <0, 30, -30>
    colour White
  }
#end

// Boy goes around girl, 2 seconds
#if (clock >= 21 & clock < 23)
  #declare lclock = clock - 21;
  #declare girl_x = -7.5;
  #declare girl_y = 5;
  #declare girl_z = 0;
  #declare boy_x = -7.5 + 15 * cos(radians(360 * lclock / 2));
  #declare boy_y = 5;
  #declare boy_z = 0 + 15 * sin(radians(360 * lclock / 2));

  light_source
  {
    <0, 30, -30>
    colour White
  }
#end

// Both go in circles, 4 seconds
#if (clock >= 23 & clock < 27)
  #declare lclock = clock - 23;
  #declare girl_x = 0 - 7.5 * cos(radians(360 * lclock));
  #declare girl_y = 5;
  #declare girl_z = 0 + 7.5 * sin(radians(360 * lclock));
  #declare boy_x = 0 + 7.5 * cos(radians(360 * lclock));
  #declare boy_y = 5;
  #declare boy_z = 0 - 7.5 * sin(radians(360 * lclock));

  light_source
  {
    <0, 30, -30>
    colour White
  }
#end

// Away & together, 2 seconds
#if (clock >= 27 & clock < 29)
  #declare lclock = clock - 27;
  #declare girl_x = -7.5 - 2.5 * sin(radians(360 * lclock));
  #declare girl_y = 5;
  #declare girl_z = 0;
  #declare boy_x = 7.5 + 2.5 * sin(radians(360 * lclock));
  #declare boy_y = 5;
  #declare boy_z = 0;

  light_source
  {
    <0, 30, -30>
    colour White
  }
#end

// Lights off, pause, 1 second
#if (clock >= 29 & clock < 30)
  #declare lclock = clock - 29;
  #declare girl_x = -7.5;
  #declare girl_y = 5;
  #declare girl_z = 0;
  #declare boy_x = 7.5;
  #declare boy_y = 5;
  #declare boy_z = 0;
#end

// Both leave the dance floor, 5 seconds
#if (clock >= 30 & clock < 35)
  #declare lclock = clock - 30;
  #declare girl_x = -7.5 - 10 * lclock;
  #declare girl_y = 5;
  #declare girl_z = 0 - 10 * lclock;
  #declare boy_x = 7.5 + 10 * lclock;
  #declare boy_y = 5;
  #declare boy_z = 0 - 10 * lclock;
#end

// This contains the basic framework common to a number of
// different scenes
#if (clock >= 3 & clock < 35)
  camera
  {
    location <0, 30, -30>
    look_at <0, 0, 0>
  }

  plane
  {
    <0, 1, 0>, 0
    pigment
    {
      checker colour Black, White
      scale 4
    }
    finish
    {
      reflection
      {
	0.75
      }
    }
  }

  // Girl's spotlight
  light_source
  {
    <0, 25, 0>
    colour White
    spotlight
    radius 20
    falloff 30
    tightness 10
    point_at <girl_x, girl_y, girl_z>
  }

  // Boy's spotlight
  light_source
  {
    <0, 25, 0>
    colour White
    spotlight
    radius 20
    falloff 30
    tightness 10
    point_at <boy_x, boy_y, boy_z>
  }

  // Girl sphere
  sphere
  {
    <0, 0, 0>, 5
    pigment
    {
      colour Pink
    }
    translate <girl_x, girl_y, girl_z>
  }

  // Boy sphere
  sphere
  {
    <0, 0, 0>, 5
    pigment
    {
      colour Blue
    }
    translate <boy_x, boy_y, boy_z>
  }
#end

// This is the end screen, shown for 3 seconds
#if (clock >= 35 & clock <= 38)
  camera
  {
    location <0, 0.5, -10>
    look_at <0, 0.5, 1>
  }

  light_source
  {
    <-10, 10, -10>
    White
  }

  text
  {
    ttf "times.ttf" "The End" 0.1, 0
    pigment { Gold }
    translate <-1.5, 0, 0>
  }
#end
