package com.firestick.file;

import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;

public class PropertyFile {
	
	private String fileName;
	private Properties properties;
	
	public PropertyFile (String fileName) {
		this.fileName = fileName;
		FileInputStream stream = null;
		try {
			try {
				stream = new FileInputStream (fileName);
				properties = new Properties();
				properties.load(stream);
			} finally {
				if (stream != null) {
					stream.close();
				}
			}
			
		} catch (Exception ex) {
			throw new RuntimeException (ex);
		}
	}
	
	public String getString (String key) {
		return properties.getProperty(key);
	}
	
	public int getInteger (String key) {
		return new Integer(getString(key));
	}

	public boolean containsKey (String key) {
		return properties.containsKey(key);
	}
	
}
