package com.firestick.graphics.format.detailer;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

import com.firestick.graphics.util.Coord;
import com.firestick.graphics.util.IMeshConverter;
import com.firestick.graphics.util.ITriangle;
import com.firestick.stream.DelimitedStreamLineReader;
import com.firestick.stream.IDelimitedStreamLineEventListener;

public class DetailerFile implements IDelimitedStreamLineEventListener {
	
	private File detailerFile;
	private List<Coord> coordinates = new ArrayList<Coord>();
	private List<DetailerTriangle> triangles = new ArrayList<DetailerTriangle>();
	
	
	public DetailerFile (File file) {
		this.detailerFile = file;
	}
	
	private boolean isLoaded() {
		return (coordinates.size() >0);
	}
	
	public void convert (IMeshConverter converter, String povrayFileName) throws IOException {
		Writer writer = null;
		if (!isLoaded()) {
			readDetailerFile();
		}

		try {
			writer = new FileWriter (povrayFileName);
			converter.startEvent(writer);
			for (int idx=0;idx<triangles.size();idx++) {
				converter.triangleEvent(writer, triangles.get(idx));
			}
			converter.endEvent(writer);
		} finally {
			writer.close();
		}
	}
	
	private void readDetailerFile() throws IOException {
		Reader reader = null;
		
		try {
			reader = new FileReader  (detailerFile);
			DelimitedStreamLineReader lineReader = new DelimitedStreamLineReader (reader, this, " (),", true);
			lineReader.start();
		} finally {
			reader.close();
		}	
	}

	public void lineEvent(List<String> line, long lineNumber) {
		if (line.size() > 1) {
			if (line.get(0).equals("coord")) {
				Coord coord = new Coord (new Double(line.get(2)), new Double(line.get(3)), new Double(line.get(4)));
				coordinates.add(coord.rotate180Y());
			} else if (line.get(0).equals("tri")) {
				DetailerTriangle triangle = new DetailerTriangle(new Integer(line.get(7)),new Integer(line.get(8)), new Integer(line.get(9)));
				triangles.add(triangle);
			}
		}
		
	}
	
	private class DetailerTriangle implements ITriangle {
		
		private int idxA;
		private int idxB;
		private int idxC;
		
		public DetailerTriangle(int idxA, int idxB, int idxC) {
			super();
			this.idxA = idxA;
			this.idxB = idxB;
			this.idxC = idxC;
		}
		
		public Coord getA() {
			return coordinates.get(idxA);
		}
		
		public Coord getB() {
			return coordinates.get(idxB);
		}	
		
		public Coord getC() {
			return coordinates.get(idxC);
		}

		public Coord getCenter() {
			Coord cumulative = new Coord(0,0,0);
			cumulative.inc(getA());
			cumulative.inc(getB());
			cumulative.inc(getC());
			return new Coord(cumulative.getX()/3, cumulative.getY()/3, cumulative.getZ()/3);
		}
		
	}

}
