package com.firestick.graphics.format.povray;

import java.io.IOException;
import java.io.Writer;

import com.firestick.graphics.util.IMeshConverter;
import com.firestick.graphics.util.ITriangle;

public class PovrayMeshWriter implements IMeshConverter{

	private String baseVarName;
	
	private String explosionAmmount;
	private String expRndSeed;
	private String expVariance;
	
	
		
	
	public PovrayMeshWriter (String baseVarName) {
		this.baseVarName = baseVarName;
		
		explosionAmmount = baseVarName + "explosionAmmount"; 
		expRndSeed = baseVarName + "expRndSeed";
		expVariance = baseVarName + "expVariance";
		
		
	}
	
	public void startEvent(Writer writer) throws IOException {
		writer.write("#ifndef("  + explosionAmmount + ")\n"); 
		writer.write("#local " + explosionAmmount + "= 0;\n");
		writer.write("#end\n");
		writer.write("#ifndef(" + expRndSeed + ")\n");
		writer.write("#local " + expRndSeed + "=123123412;\n");
	    writer.write("#end\n");
	    writer.write("#ifndef(" + expVariance + ")\n");
	    writer.write("#local " + expVariance + "= 0;\n");
	    writer.write("#end\n");
	    writer.write("#local _" + expRndSeed + "= seed(" + expRndSeed + ");\n");
		
		
		writer.write("union {");
	}

	public void triangleEvent(Writer writer, ITriangle triangle) throws IOException {
		writer.write ("triangle {");
		writer.write (triangle.getA().toString());
		writer.write (",");
		writer.write (triangle.getB().toString());
		writer.write (",");
		writer.write (triangle.getC().toString());
		
		writer.write(" translate (");
		writer.write (triangle.getCenter().toString());
		writer.write ("+");
		writer.write(triangle.getCenter().toStringWithSuffix("*" +  expVariance + "*" + "rand(_" + expRndSeed + ")"));
		writer.write(") * " + explosionAmmount);
		
		writer.write ("}");
	}

	public void endEvent(Writer writer) throws IOException {
		writer.write("}");
	}
	
}
