package com.firestick.graphics.util;

public class Coord {
	private double x;
	private double y;
	private double z;
	
	public Coord(double x, double y, double z) {
		super();
		this.x = x;
		this.y = y;
		this.z = z;
	}

	public double getX() {
		return x;
	}

	public double getY() {
		return y;
	}

	public double getZ() {
		return z;
	}
	
	public String toString() {
		return "<" + x + "," + y + "," + z +">";
	}
	
	public String toStringWithSuffix(String suffix) {
		return "<" + x + suffix + "," + y + suffix + "," + z + suffix + ">";
	}
	
	public void inc(Coord addThis) {
		x+=addThis.getX();
		y+=addThis.getY();
		z+=addThis.getZ();
	}
	
	
	public Coord rotate180Y() {
		return new Coord (invert (x), y, invert(z));
	}
	
	private double invert (double number) {
		return (0-number);
	}
}
