//clock utilities

// clock runs from 0 to 1 between clockStart and clockEnd
// returns a value from 0 to 1
// clockInput the clock that will be scaled
// clockStart the point at which clock value starts to ascend from 0
// clockEnd the point at which clock value will reach 1

#macro rsclock(clockInput, clockStart, clockEnd)
    #if (clockInput > clockEnd)
        #local result = 1;
    #else
        #if (clockInput < clockStart) 
            #local result = 0;
        #else
            #local crange = clockEnd - clockStart;
            #local cdelta = clockInput - clockStart;
            #local result = cdelta/crange;
        #end
    #end

    result
#end                          


// repeat a clock (0 to 1) repeatCount number of times
#macro rsclockRepeat(clockInput, repeatCount) 
    #local crange = 1/repeatCount;
    #local repeatNum = int(clockInput/crange);
    rsclock(clockInput, repeatNum * crange, (repeatNum * crange) + crange)
#end  

